/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Author:  Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 

#include <stdio.h>
#include <signal.h>
#include "condor_sys.h"
#include "debug.h"

int CkptInProgress;
int SyscallInProgress;
int KillWanted;

#ifdef VOID_SIGNAL_RETURN
#define sighandler_t void
#else
#define sighandler_t int
#endif

sighandler_t
CKPT(){}

/* Send signal 9 to self. */
do_kill()
{
	int scm = SetSyscalls( SYS_LOCAL | SYS_RECORDED, __LINE__, __FILE__ );
	int pid = getpid();

	dprintf(D_CKPT,
		"do_kill(): KillWanted %d, CkptInProgress %d, SyscallInProgress %d\n",
			KillWanted, CkptInProgress, SyscallInProgress);

	dprintf(D_CKPT, "do_kill: about to kill(%d, SIGKILL)\n", pid);

	kill( pid, SIGKILL );
}
