/* Do not remove the following line! Required for SCCS. */
static char sccsid[] = "@(#)stubs.c	4.2 10/14/91"; 
/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Author:  Michael J. Litzkow
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#if defined(AIX31) || defined(AIX32)
#define extern 
#define _NO_PROTO
#include <stdio.h>
#include <sys/types.h>
#undef extern
#else
#include <stdio.h>
#include <sys/types.h>
#endif

#include <errno.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/times.h>
#include <sys/resource.h>
#include "condor_sys.h"
#include "syscall.aix.h"
#include "debug.h"
#include "except.h"
#include "ckpt_file.h"

static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */

extern int Syscalls;
extern int FakeRemoteCalls;
char	Condor_CWD[ MAXPATHLEN ];
int	Rval;
int	AvoidNFS = 0;
extern int	Method;
extern char	*LocalName;
extern RESTREC    RestartInfo;

int SyscallInProgress;
int CkptWanted;
int KillWanted;

#define D_RUSAGE( flags, ptr ) { \
	dprintf( flags, "(ptr)->ru_utime = %d.%06d\n", (ptr)->ru_utime.tv_sec, \
											(ptr)->ru_utime.tv_usec ); \
	dprintf( flags, "(ptr)->ru_stime = %d.%06d\n", (ptr)->ru_stime.tv_sec, \
											(ptr)->ru_stime.tv_usec ); \
}

#define UNDOC(call) \
call() \
{ \
	int	rval; \
        IncrSyscallInProgress(); \
	if( (Syscalls & SYS_LOCAL) ) { \
		rval = syscall(SYS_/**/call); \
		SET_ERRNO; \
	} else { \
		rval = REMOTE_syscall(CONDOR_/**/call); \
	} \
	DecrSyscallInProgress(); \
	return rval; \
}

#define ZERO(call) \
call() \
{ \
	int	rval; \
        IncrSyscallInProgress(); \
	if( (Syscalls & SYS_LOCAL) ) { \
		rval = syscall(SYS_/**/call); \
		SET_ERRNO; \
	} else { \
		rval = REMOTE_syscall(CONDOR_/**/call); \
	} \
	DecrSyscallInProgress(); \
	return rval; \
}

#define ONE(call,type_1) \
call( arg_1) \
type_1 arg_1; \
{ \
	int	rval; \
        IncrSyscallInProgress(); \
	if( (Syscalls & SYS_LOCAL) ) { \
		rval = syscall(SYS_/**/call,arg_1); \
		SET_ERRNO; \
	} else { \
		rval = REMOTE_syscall(CONDOR_/**/call,arg_1); \
	} \
	DecrSyscallInProgress(); \
	return rval; \
}

#define TWO(call,type_1,type_2) \
call( arg_1, arg_2 ) \
type_1 arg_1; \
type_2 arg_2; \
{ \
	int	rval; \
        IncrSyscallInProgress(); \
	if( (Syscalls & SYS_LOCAL) ) { \
		rval = syscall(SYS_/**/call,arg_1,arg_2); \
		SET_ERRNO; \
	} else { \
		rval = REMOTE_syscall(CONDOR_/**/call,arg_1,arg_2); \
	} \
	DecrSyscallInProgress(); \
	return rval; \
}

#define THREE(call,type_1,type_2,type_3) \
call( arg_1, arg_2, arg_3) \
type_1 arg_1; \
type_2 arg_2; \
type_3 arg_3; \
{ \
	int	rval; \
        IncrSyscallInProgress(); \
	if( (Syscalls & SYS_LOCAL) ) { \
		rval = syscall(SYS_/**/call,arg_1,arg_2,arg_3); \
		SET_ERRNO; \
	} else { \
		rval = REMOTE_syscall(CONDOR_/**/call,arg_1,arg_2,arg_3); \
	} \
	DecrSyscallInProgress(); \
	return rval; \
}

#define FOUR(call,type_1,type_2,type_3,type_4) \
call( arg_1, arg_2, arg_3, arg_4 ) \
type_1 arg_1; \
type_2 arg_2; \
type_3 arg_3; \
type_4 arg_4; \
{ \
	int	rval; \
        IncrSyscallInProgress(); \
	if( (Syscalls & SYS_LOCAL) ) { \
		rval = syscall(SYS_/**/call,arg_1,arg_2,arg_3,arg_4); \
		SET_ERRNO; \
	} else { \
		rval = REMOTE_syscall(CONDOR_/**/call,arg_1,arg_2,arg_3,arg_4); \
	} \
	DecrSyscallInProgress(); \
	return rval; \
}

#define FIVE(call,type_1,type_2,type_3,type_4,type_5) \
call( arg_1, arg_2, arg_3, arg_4, arg_5 ) \
type_1 arg_1; \
type_2 arg_2; \
type_3 arg_3; \
type_4 arg_4; \
type_5 arg_5; \
{ \
	int	rval; \
        IncrSyscallInProgress(); \
	if( (Syscalls & SYS_LOCAL) ) { \
		rval = syscall(SYS_/**/call,arg_1,arg_2,arg_3,arg_4,arg_5); \
		SET_ERRNO; \
	} else { \
		rval = REMOTE_syscall(CONDOR_/**/call,arg_1,arg_2,arg_3,arg_4,arg_5); \
	} \
	DecrSyscallInProgress(); \
	return rval; \
}

#define SIX(call,type_1,type_2,type_3,type_4,type_5,type_6) \
call( arg_1, arg_2, arg_3, arg_4, arg_5, arg_6 ) \
type_1 arg_1; \
type_2 arg_2; \
type_3 arg_3; \
type_4 arg_4; \
type_5 arg_5; \
type_6 arg_6; \
{ \
	int	rval; \
        IncrSyscallInProgress(); \
	if( (Syscalls & SYS_LOCAL) ) { \
		rval = syscall(SYS_/**/call,arg_1,arg_2,arg_3,arg_4,arg_5,arg_6); \
		SET_ERRNO; \
	} else { \
		rval = REMOTE_syscall(CONDOR_/**/call,arg_1,arg_2,arg_3,arg_4,arg_5,arg_6); \
	} \
	DecrSyscallInProgress(); \
	return rval; \
}

int InProgressEnabled = 1;

static void
IncrSyscallInProgress()
{
        if (InProgressEnabled) {
	  SyscallInProgress += 1;
	}
}

static void
DecrSyscallInProgress()
{
        if (InProgressEnabled) {
	  SyscallInProgress -= 1;

	  if (SyscallInProgress == 0) {
	    if( KillWanted ) {
	      InProgressEnabled = 0;
	      do_kill();
	      InProgressEnabled = 1;
	      SyscallInProgress = 0;
	    }
		
	    if( CkptWanted ) {
	      InProgressEnabled = 0;
	      ckpt();
	      InProgressEnabled = 1;
	      SyscallInProgress = 0;
	    }
	  }
	}
}


/*
** The following system calls need special handling in the condor world.
*/
brk( ptr )
char	*ptr;
{
	int		rval;
        IncrSyscallInProgress();
	rval =  syscall( SYS_brk, ptr );
	SET_ERRNO;
	DecrSyscallInProgress();
	return rval;
}

sbrk( incr )
int		incr;
{
	int		rval;
        IncrSyscallInProgress();
	rval = syscall( SYS_sbrk, incr );
	SET_ERRNO;
	DecrSyscallInProgress();
	return rval;
}

chdir( path )
char	*path;
{
	int rval, status;
	int	scm;
	char tbuf[ MAXPATHLEN ];

        IncrSyscallInProgress();

	if( Syscalls & SYS_LOCAL ) {
		rval = syscall( SYS_chdir, path );
		SET_ERRNO;
		if( (Syscalls & SYS_RECORDED) == SYS_RECORDED ) {
			scm = SetSyscalls( SYS_LOCAL | SYS_UNRECORDED );
			status = getwd( tbuf );
			(void)SetSyscalls( scm );
			if( status == 0 ) {
				EXCEPT( tbuf );
			}
			strcpy( Condor_CWD, tbuf );
		}
	} else {
		rval = REMOTE_syscall( CONDOR_chdir, path );

		if( (Syscalls & SYS_RECORDED) == SYS_RECORDED ) {
			if( REMOTE_syscall(PSEUDO_getwd, tbuf) == 0 ) {
				EXCEPT( tbuf );
			}
			strcpy( Condor_CWD, tbuf );
		}
	}

	DecrSyscallInProgress();

	return( rval );
}

close( user_fd )
int user_fd;
{
	int rval, fd;
	int	is_dupd = 0;
	register FINFO *fi = &RestartInfo.rr_file[ user_fd ];

	/*
	dprintf( D_ALWAYS, "Before close\n" );
	DumpOpenFds();
	*/

	fd = map_fd( user_fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	if( (Syscalls & SYS_RECORDED) == SYS_RECORDED ) {
		if( (fi->fi_flags & FI_WELL_KNOWN) == FI_WELL_KNOWN ) {
			errno = EBADF;
			return -1;
		}
		is_dupd = file_is_dupd( user_fd );
	}

	IncrSyscallInProgress();

	if( is_dupd ) {	/* don't close it if it's a dup */
		rval = 0;
	} else {
		if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
			rval = syscall( SYS_close, fd );
			SET_ERRNO;
		} else {
			rval = REMOTE_syscall( CONDOR_close, fd );
		}
	}

	if( (Syscalls & SYS_RECORDED) == SYS_RECORDED ) {
		if( rval >= 0 ) {
			/*
			MarkFileClosed( fd );
			*/
			MarkFileClosed( user_fd );
		}
	}

	/*
	if( rval < 0 ) {
		dprintf( D_ALWAYS, "Close(%d->%d) -- failed\n", user_fd, fd );
	} else {
		dprintf( D_ALWAYS, "Close(%d->%d) -- OK\n", user_fd, fd );
	}
	*/

	/*
	display_syscall_mode( __LINE__, __FILE__ );
	dprintf( D_ALWAYS, "After close(%d) returns %d\n", user_fd, rval );
	DumpOpenFds();
	*/

	DecrSyscallInProgress();

	return( rval );
}

shmat( fd, addr, flag )
int		fd;
char	*addr;
int		flag;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_shmat, fd, addr, flag );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_shmat, fd, addr, flag );
	}

	DecrSyscallInProgress();

	return( rval );
}




creat( name, mode )
char *name;
int mode;
{
	int rval;

	IncrSyscallInProgress();

	if( Syscalls & SYS_LOCAL ) {
		rval = syscall( SYS_creat, name, mode );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_creat, name, mode );
	}

	if( (Syscalls & SYS_RECORDED) == SYS_RECORDED ) {
		if( rval >= 0 ) {
			rval = MarkFileOpen( rval, name, O_WRONLY );
		}
	}

	DecrSyscallInProgress();

	return( rval );
}

_exit( status )
int		status;
{
	syscall( SYS__exit, status );

	abort();
}

open( path, flags, mode )
char *path;
int flags, mode;
{
	int rval;

	/*
	dprintf( D_ALWAYS, "Before open\n" );
	DumpOpenFds();
	display_syscall_mode( __LINE__, __FILE__ );
	*/

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) == SYS_LOCAL ) {
		rval = syscall( SYS_open, path, flags, mode );
		SET_ERRNO;
		Method = FI_NFS;
		LocalName = NULL;
	} else {
		if( (rval = nfs_open(path,flags,mode)) >= 0 ) {
			Method = FI_NFS;
		} else {
			rval = REMOTE_syscall( CONDOR_open, path, flags, mode );
			Method = FI_RSC;
		}
	}


	if( (Syscalls & SYS_RECORDED) == SYS_RECORDED ) {
		if( rval >= 0 ) {
			rval = MarkFileOpen( rval, path, flags, Method );
		}
	}

	
	/*
	debug_open( path, rval );
	display_syscall_mode( __LINE__, __FILE__ );
	dprintf( D_ALWAYS, "After open(\"%s\",%d,%d) returns %d\n",
										path, flags, mode, rval );
	DumpOpenFds();
	*/

	DecrSyscallInProgress();

	return( rval );
}

openx( path, flags, mode, ext )
char *path;
int flags, mode, ext;
{
	int rval;

        IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) == SYS_LOCAL ) {
		rval = syscall( SYS_openx, path, flags, mode, ext );
		SET_ERRNO;
		Method = FI_NFS;
		LocalName = NULL;
	} else {
		if( (rval = nfs_openx(path,flags,mode,ext)) >= 0 ) {
			Method = FI_NFS;
		} else {
			rval = REMOTE_syscall( CONDOR_openx, path, flags, mode, ext );
			Method = FI_RSC;
		}
	}


	if( (Syscalls & SYS_RECORDED) == SYS_RECORDED ) {
		if( rval >= 0 ) {
			rval = MarkFileOpen( rval, path, flags, Method );
		}
	}

	/*
	debug_open( path, rval );
	*/
	
	DecrSyscallInProgress();

	return( rval );
}

kwritev( fd, iov, iovcnt, ext )
int fd;
struct iovec *iov;
int iovcnt;
int ext;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	if( ext != 0 ) {
		EXCEPT( "kwritev called with extension == %d\n", ext );
	}

        IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_kwritev, fd, iov, iovcnt, ext );
		SET_ERRNO;
	} else {
		rval = fake_writev( fd, iov, iovcnt );
	}

	DecrSyscallInProgress();

	return( rval );
}


kreadv( fd, iov, iovcnt, ext )
int fd;
struct iovec *iov;
int iovcnt;
int ext;
{
	int rval, i;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	if( ext != 0 ) {
		EXCEPT( "kreadv called with extension == %d\n", ext );
	}

        IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		errno = 0;
		rval = syscall( SYS_kreadv, fd, iov, iovcnt, ext );
		SET_ERRNO;
	} else {
		rval = fake_readv( fd, iov, iovcnt );
	}

	DecrSyscallInProgress();

	return( rval );
}

getrusage( who, rusage )
int who;
struct rusage *rusage;
{
	int rval;
	struct rusage accum_rusage;

        IncrSyscallInProgress();

	if( Syscalls & SYS_LOCAL ) {
		rval = syscall( SYS_getrusage, who, rusage );
		SET_ERRNO;
	} else {

		if( who != RUSAGE_SELF ) {
			dprintf( D_ALWAYS,
			"ERROR: Attempted getrusage(RUSAGE_ CHILDREN,...) remotely\n" );
			errno = EINVAL;
			rval = -1;
		} else {
		  /* Get current rusage for the running job. */
		  syscall( SYS_getrusage, who, rusage);
		  D_RUSAGE( D_FULLDEBUG, rusage );

		  /* Get accumulated rusage from previous runs */
		  rval = REMOTE_syscall( CONDOR_getrusage, who, &accum_rusage );
		  D_RUSAGE( D_FULLDEBUG, &accum_rusage );

		  /* Sum the two. */
		  update_rusage(rusage, &accum_rusage);
		  D_RUSAGE( D_FULLDEBUG, rusage );
		}
	}

	DecrSyscallInProgress();

	return( rval );
}

/*
** Keeping track of execution times accumulated over multiple runs
** is a pain.  Since we already do this for getrusage(), we implement
** this as a call to the same.  N.B. The man page for times() talks
** about tms_* in 1/10s of a second and the return value in 1/60s
** of a second.  Actually both appear to be reported in 1/100s, so
** we do it that way here.
*/
times( tms )
struct tms	*tms;
{
	int rval;
	struct rusage	rusage;
	long			now;

	IncrSyscallInProgress();

	if( Syscalls & SYS_LOCAL )  {
		rval = syscall( SYS_times, tms );
		SET_ERRNO;
	} else {
		if( getrusage( RUSAGE_SELF, &rusage ) < 0 ) {
			perror( "getrusage" );
			exit( 1 );
		}
		D_RUSAGE( D_ALWAYS, &rusage );


		tms->tms_utime = rusage.ru_utime.tv_sec * 100 +
						 rusage.ru_utime.tv_usec / 10000;
		dprintf( D_ALWAYS, "Set tms->tms_utime to %d\n", tms->tms_utime );

		tms->tms_stime = rusage.ru_stime.tv_sec * 100 +
						 rusage.ru_stime.tv_usec / 10000;
		dprintf( D_ALWAYS, "Set tms->tms_stime to %d\n", tms->tms_stime );

		tms->tms_cutime = 0;
		tms->tms_cstime = 0;

		(void)time( &now );
		rval =  (now & 0xffff) * 100;
	}

	DecrSyscallInProgress();

	return( rval );
}

	
kfcntl( fd, cmd, arg )
int		fd;
int		cmd;
int		arg;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	if( (Syscalls & SYS_RECORDED) == SYS_RECORDED && cmd == F_DUPFD ) {
		return DoDup2( fd, arg );
	}

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_kfcntl, fd, cmd, arg );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_kfcntl, fd, cmd, arg );
	}

	DecrSyscallInProgress();

	return( rval );
}

off_t
lseek( fd, offset, whence )
int fd;
off_t offset;
int whence;
{
	register FINFO *fi = &RestartInfo.rr_file[ fd ];
	off_t rval;
	int		orig;

	/*
	dprintf( D_ALWAYS, "Before lseek\n" );
	DumpOpenFds();
	*/

	orig = fd;
	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}


	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = (off_t) syscall( SYS_lseek, fd, offset, whence );
		SET_ERRNO;
	} else {
		rval = (off_t) REMOTE_syscall( CONDOR_lseek, fd, offset, whence );
	}

	/*
	dprintf( D_ALWAYS, "lseek(%d->%d) = %d\n", orig, fd, rval );
	dprintf( D_ALWAYS, "After lseek\n" );
	DumpOpenFds();
	*/

	DecrSyscallInProgress();

	return( rval );
}

fchmod( fd, mode )
int fd, mode;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_fchmod, fd, mode );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_fchmod, fd, mode );
	}

	DecrSyscallInProgress();

	return( rval );
}

fchown( fd, owner, group )
int 	fd;
uid_t	owner;
gid_t	group;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_fchown, fd, owner, group  );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_fchown, fd, owner, group  );
	}

	DecrSyscallInProgress();

	return( rval );
}


fchownx( fd, owner, group, flags )
int 	fd;
uid_t	owner;
gid_t	group;
int		flags;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_fchownx, fd, owner, group, flags  );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_fchownx, fd, owner, group, flags  );
	}

	DecrSyscallInProgress();

	return( rval );
}

fstatacl( fd, cmd, acl, acl_size )
int 	fd;
int		cmd;
struct acl *acl;
int		acl_size;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_fstatacl, fd, cmd, acl, acl_size  );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_fstatacl, fd, cmd, acl, acl_size  );
	}

	DecrSyscallInProgress();

	return( rval );
}

fstatfs( fd, buf )
int 	fd;
struct statfs *buf;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_fstatfs, fd, buf );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_fstatfs, fd, buf );
	}

	DecrSyscallInProgress();

	return( rval );
}

fstatpriv( fd, cmd, buf, len )
int 	fd;
int		cmd;
struct pcl	*buf;
int		len;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_fstatpriv, fd, cmd, buf, len );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_fstatpriv, fd, cmd, buf, len );
	}

	DecrSyscallInProgress();

	return( rval );
}

fstatx( fd, buf, len, cmd )
int 	fd;
struct stat	*buf;
int		len;
int		cmd;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_fstatx, fd, buf, len, cmd );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_fstatx, fd, buf, len, cmd );
	}

	DecrSyscallInProgress();

	return( rval );
}

fsync( fd )
int 	fd;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_fsync, fd );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_fsync, fd );
	}

	DecrSyscallInProgress();

	return( rval );
}

ftruncate( fd, len )
int 	fd;
off_t	len;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_ftruncate, fd, len );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_ftruncate, fd, len );
	}

	DecrSyscallInProgress();

	return( rval );
}

getdirent( fd, buf, count )
int 	fd;
char	*buf;
unsigned	count;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_getdirent, fd, buf, count );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_getdirent, fd, buf, count );
	}

	DecrSyscallInProgress();

	return( rval );
}

kioctl( fd, cmd, arg, ext )
int 	fd;
int		cmd;
int		arg;
char	*ext;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	/*
	display_syscall_mode( __LINE__, __FILE__ );
	*/

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_kioctl, fd, cmd, arg, ext );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_kioctl, fd, cmd, arg, ext );
	}

	DecrSyscallInProgress();

	return( rval );
}

faccessx( fd, mode, who )
int 	fd;
int		mode;
int		who;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_faccessx, fd, mode, who );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_faccessx, fd, mode, who );
	}

	DecrSyscallInProgress();

	return( rval );
}

fchacl( fd, acl, acl_size )
int 	fd;
struct acl	*acl;
int		acl_size;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_fchacl, fd, acl, acl_size );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_fchacl, fd, acl, acl_size );
	}

	DecrSyscallInProgress();

	return( rval );
}

fchpriv( fd, pcl, pcl_size )
int 	fd;
struct pcl	*pcl;
int		pcl_size;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_fchpriv, fd, pcl, pcl_size );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_fchpriv, fd, pcl, pcl_size );
	}

	DecrSyscallInProgress();

	return( rval );
}

fclear( fd, bytes )
int 	fd;
unsigned long	bytes;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_fclear, fd, bytes );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_fclear, fd, bytes );
	}

	DecrSyscallInProgress();

	return( rval );
}

frevoke( fd )
int 	fd;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_frevoke, fd );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_frevoke, fd );
	}

	DecrSyscallInProgress();

	return( rval );
}

lockf( fd, request, size )
int 	fd;
int		request;
off_t	size;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	IncrSyscallInProgress();

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_lockf, fd, request, size );
		SET_ERRNO;
	} else {
		rval = REMOTE_syscall( CONDOR_lockf, fd, request, size );
	}

	DecrSyscallInProgress();

	return( rval );
}


/*
** The rest of the system calls can be just passed through to either
** syscall() or REMOTE_syscall() depending on the sytem call mode...
*/
TWO(access,char *,int)
THREE(accessx,char *,int,int)
TWO(adjtime,struct timeval *,struct timeval *)
TWO(audit,int,int)
FOUR(auditbin,int,int,int,int)
THREE(auditevents,int,struct audit_class *,int)
FOUR(auditlog,char *,int,char *,int)
THREE(auditobj,int,struct o_event *,int)
FOUR(auditproc,int,int,int,int)
THREE(chacl,char *,struct acl *,int)
TWO(chmod,char *,mode_t)
THREE(chown,char *,uid_t,gid_t)
FOUR(chownx,char *,uid_t,gid_t,int)
THREE(chpriv,char *,struct pcl *,int)
ONE(chroot,char *)
THREE(disclaim,char *,unsigned int,unsigned int)
THREE(execve,char *,char**,char**)
ZERO(fork)
FOUR(fscntl,int,int,char *,int)
FOUR(getargs,struct procinfo *,int,char *,int)
FOUR(getevars,struct procinfo *,int,char *,int)
ONE(getgidx,int)
TWO(getgroups,int,gid_t *)
ZERO(getpgrp)
ONE(kgetpgrp,pid_t)
ZERO(getpid)
ZERO(getppid)
TWO(getpriority,int,int)
ONE(getpri,pid_t)
UNDOC(getpriv)
THREE(getproc,struct procinfo *,int,int)
TWO(getrlimit,int,struct rlimit *)
ONE(getuidx,int)
FOUR(getuser,struct procinfo *,int,void *,int)
TWO(kill,pid_t,int)
THREE(knlist,struct nlist *,int,int)
FOUR(kwaitpid,int,pid_t,int,struct rusage *)
TWO(link,char *,char *)
THREE(_load,char *,int,char *)
THREE(loadbind,int,void *,void *)
THREE(loadquery,int,void *,unsigned int)
TWO(mkdir,char *, int)
THREE(mknod,char *,int,dev_t)
THREE(mntctl,int,int,char *)
ZERO(pause)
ONE(pipe,int *)
ONE(plock,int)
THREE(poll,struct pollfd *,unsigned long,long)
ONE(privcheck,int)
FOUR(profil,short *,unsigned,unsigned,unsigned)
ONE(psdanger,int)
FIVE(ptrace,int,int,int,int *,int *)
THREE(readlink,char *,char *,int)
ONE(reboot,char *)
TWO(rename,char *,char *)
ONE(revoke,char *)
ONE(rmdir,char *)
THREE(absinterval,timer_t,struct itimerstruc_t *,struct itimerstruc_t *)
TWO(getinterval,timer_t,struct itimerstruc_t *)
TWO(gettimer,int,struct timestruc_t *)
TWO(gettimerid,int,int)
THREE(incinterval,timer_t,struct itimerstruc_t *,struct itimerstruc_t *)
ONE(reltimerid,timer_t)
THREE(resabs,timer_t,struct timestruc_t *,struct timestruc_t *)
THREE(resinc,timer_t,struct timestruc_t *,struct timestruc_t *)
THREE(restimer,int,struct timestruc_t *,struct timestruc_t *)
TWO(settimer,int,struct timestruc_t *)
TWO(nsleep,struct timestruc_t *,struct timestruc_t *)
FIVE(select,int,struct sellist *,struct sellist *,struct sellist *, struct timeval *)
ONE(seteuid,uid_t)
ONE(setgid,gid_t)
TWO(setgidx,int,gid_t)
TWO(setgroups,int,gid_t *)
TWO(setpgid,pid_t,pid_t)
ZERO(setpgrp)
TWO(setpri,pid_t,int)
THREE(setpriority,int,int,int)
UNDOC(setpriv)
TWO(setreuid,uid_t,uid_t)
TWO(setrlimit,int,struct rlimit *)
ZERO(setsid)
ONE(setuid,uid_t)
TWO(setuidx,int,uid_t)
THREE(shmctl,int,int,struct shmid_ds *)
THREE(shmget,key_t,int,int)
ONE(shmdt,char *)
THREE(msgctl,int,int,struct msqid_ds *)
TWO(msgget,key_t,int)
FOUR(msgsnd,int,int,void *,size_t)
FIVE(msgrcv,int,int,void *,size_t,long)
FIVE(msgxrcv,int,int,int,struct msgxbuf *,long)
FOUR(semctl,int,int,int,int)
THREE(semget,key_t,int,int)
THREE(semop,int,struct sembuf *,unsigned)
THREE(sigaction,int,struct sigaction *,struct sigaction *)
ONE(sigcleanup,sigset_t *)
THREE(sigprocmask,int,sigset_t *,sigset_t *)
ONE(sigreturn,struct sigcontext *)
TWO(sigstack,struct sigstack *,struct sigstack *)
ONE(sigsuspend,sigset_t *)
ONE(sigpending,sigset_t *)
FOUR(statacl,char *,int,struct acl *,int)
TWO(statfs,char *,struct statfs *)
FOUR(statpriv,char *,int,struct pcl *,int)
FOUR(statx,char *,struct stat *,int,int)
ONE(swapoff,char *)
ONE(swapon,char *)
TWO(swapqry,char *,struct pginfo *)
TWO(symlink,char *,char *)
ZERO(sync)
THREE(sysconfig,int,void *,int)
TWO(truncate,char *,off_t)
TWO(ulimit,int,off_t)
ONE(umask,mode_t)
ONE(umount,char *)
ONE(uname,struct utsname *)
ONE(unamex,struct xutsname *)
ONE(unlink,char *)
ONE(unload,int *)
THREE(usrinfo,int,int,char *)
TWO(ustat,dev_t,struct ustat *)
TWO(utimes,char *,struct timeval *)
TWO(uvmount,int,int)
TWO(vmount,struct vmount *,int)
FIVE(trcgen,int,int,int,int,char)
THREE(socket,int,int,int)
THREE(bind,int,struct sockaddr *,int)
TWO(listen,int,int)
THREE(accept,int,struct sockaddr *,int *)
THREE(connect,int,struct sockaddr *,int)
FOUR(socketpair,int,int,int,int *)
SIX(sendto,int,char *,int,int,struct sockaddr *,int)
FOUR(send,int,char *,int,int)
THREE(sendmsg,int,struct msghdr *,int)
SIX(recvfrom,int,char *,int,int,struct sockaddr *,int)
FOUR(recv,int,char *,int,int)
THREE(recvmsg,int,struct msghdr *,int)
TWO(shutdown,int,int)
FIVE(setsockopt,int,int,int,char *,int)
FIVE(getsockopt,int,int,int,char *,int)
THREE(getsockname,int,struct sockaddr *,int)
THREE(getpeername,int,struct sockaddr *,int)
TWO(setdomainname,char *,int)
TWO(getdomainname,char *,int)
TWO(sethostname,char *,int)
TWO(gethostname,char *,int)
ONE(sethostid,int)
ZERO(gethostid)

/*
** The kernel exports these, but even Marc Auslander doesn't know
** what they are...
*/
UNDOC(Trconflag)
UNDOC(trchook)
UNDOC(trchk)
UNDOC(trchkt)
UNDOC(trchkl)
UNDOC(trchklt)
UNDOC(trchkg)
UNDOC(trchkgt)
UNDOC(trcgent)
UNDOC(unameu)

/*
** Handle a call to writev which must be done remotely, (not NFS).  Note
** the user file descriptor has already been mapped by the calling routine,
** and we already know this is a remote system call.  We handle the call
** by breaking it up into a series of remote writes.
*/
static
fake_writev( fd, iov, iovcnt )
int fd;
struct iovec *iov;
int iovcnt;
{
	register int i, rval = 0, cc;

	IncrSyscallInProgress();

	for( i = 0; i < iovcnt; i++ ) {
		cc = REMOTE_syscall( CONDOR_write, fd, iov->iov_base, iov->iov_len );
		if( cc < 0 ) {
			break;
		}

		rval += cc;
		if( cc != iov->iov_len ) {
			break;
		}

		iov++;
	}

	DecrSyscallInProgress();

	return( rval );
}

/*
** Handle a call to readv which must be done remotely, (not NFS).  Note
** the user file descriptor has already been mapped by the calling routine,
** and we already know this is a remote system call.  We handle the call
** by breaking it up into a series of remote reads.
*/
static
fake_readv( fd, iov, iovcnt )
int fd;
struct iovec *iov;
int iovcnt;
{
	register int i, rval = 0, cc;

	IncrSyscallInProgress();

	for( i = 0; i < iovcnt; i++ ) {
		cc = REMOTE_syscall( CONDOR_read, fd, iov->iov_base, iov->iov_len );
		if( cc < 0 ) {
			break;
		}

		rval += cc;
		if( cc != iov->iov_len ) {
			break;
		}

		iov++;
	}

	DecrSyscallInProgress();

	return( rval );
}

fp_cpusync(void)
{
	_exit(444);
}

_fp_fpscrx(void)
{
	_exit(444);
}
