/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <sys/types.h>
#include <sys/time.h>
#include <rpc/types.h>
#include <rpc/xdr.h>

#include "trace.h"
#include "except.h"
#include "expr.h"
#include "clib.h"
#include "debug.h"

static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */

bool_t	xdr_elem(), xdr_string(), xdr_float(), xdr_int(), xdr_void(),
		xdr_mywrapstring(), xdr_elem_ptr();
EXPR	*create_expr();
ELEM	*create_elem();
CONTEXT	*create_context();


struct xdr_discrim arms[] = {
	NAME,		xdr_mywrapstring,
	STRING,		xdr_mywrapstring,
	FLOAT,		xdr_float,
	INT,		xdr_int,
	BOOL,		xdr_int,
	-99,		NULL,
};

xdr_elem( xdrs, elem )
XDR		*xdrs;
ELEM	*elem;
{
#if defined(MALLOC_DEBUG)
	label_alloc( __FILE__, __LINE__ );
#endif
	return xdr_union(xdrs,&elem->type,&elem->val,arms,xdr_void);
}

xdr_elem_ptr( xdrs, pp )
XDR		*xdrs;
ELEM	**pp;
{
#if defined(MALLOC_DEBUG)
	label_alloc( __FILE__, __LINE__ );
#endif
	if( *pp == NULL ) {
		*pp = CALLOC( 1, sizeof(ELEM) );
	}
	return xdr_reference(xdrs,pp,sizeof(ELEM),xdr_elem);
	/*
	return xdr_pointer(xdrs,pp,sizeof(ELEM),xdr_elem);
	*/
}

xdr_expr( xdrs, expr )
XDR		*xdrs;
EXPR	*expr;
{
	int		i;

	if( !xdr_int(xdrs,&expr->len) )
		return FALSE;
	if( xdrs->x_op == XDR_DECODE ) {
		if( expr->data ) {
			FREE( (char *)expr->data );	/* should this call be free_expr??? */
		}
		expr->max_len = expr->len;
		expr->data = (ELEM **)CALLOC( (unsigned)expr->max_len, sizeof(ELEM *) );
	}
	for( i=0; i<expr->len; i++ ) {
		if( !xdr_elem_ptr(xdrs,&(expr->data[i])) ) {
			return FALSE;
		}
	}
	return TRUE;
}

xdr_expr_ptr( xdrs, pp )
XDR		*xdrs;
EXPR	**pp;
{
	EXPR	*create_expr();

	if( xdrs->x_op == XDR_DECODE ) {
		if( !*pp ) {
			*pp = create_expr();
		}
	}
	return xdr_expr( xdrs, *pp );
}

xdr_context( xdrs, context )
XDR		*xdrs;
CONTEXT	*context;
{
	if( xdrs->x_op == XDR_DECODE ) {
		return rcv_context( xdrs, context );
	} else {
		return snd_context( xdrs, context );
	}
}

static
snd_context( xdrs, context )
XDR		*xdrs;
CONTEXT	*context;
{
	EXPR	*expr;
	ELEM	*elem;
	int		i;
	int		status;

		/* Send all the expressions in the context */
	if( context ) {
		for( i=0; i<context->len; i++ ) {
			expr = context->data[i];
			if( expr->data[0]->type != NAME ) {
				dprintf( D_ALWAYS, "First elem in expr to send not a NAME\n" );
				break;
			}
			if( !xdr_expr_ptr(xdrs,&expr) ) {
				return FALSE;
			}
		}
	}

		/* Send an endmarker */
	expr = create_expr();
	elem = create_elem();
	elem->type = ENDMARKER;
	add_elem( elem, expr );
	status = xdr_expr_ptr(xdrs,&expr);
	free_expr( expr );

	return status;
}

static
rcv_context( xdrs, context )
XDR		*xdrs;
CONTEXT	*context;
{
	EXPR		*expr;

	if( context == NULL ) {
		EXCEPT( "rcv_context(0x%x,0x%x)", xdrs, context );
	}

	for(;;) {
		expr = NULL;
#if defined(MALLOC_DEBUG)
		label_alloc( __FILE__, __LINE__ );
#endif
		if( !xdr_expr_ptr(xdrs,&expr) ) {
			return FALSE;
		}
		if( expr->data[0]->type == ENDMARKER ) {
#if defined(MALLOC_DEBUG)
			label_alloc( __FILE__, __LINE__ );
#endif
			free_expr( expr );
			break;
		}
		if( expr->data[0]->type != NAME ) {
			dprintf( D_ALWAYS, "First elem in received expr not a NAME\n" );
			return FALSE;
		}
		if( !store_stmt(expr,context) ) {
			return FALSE;
		}
	}
	return TRUE;
}

#ifdef VERIFY_CONTEXT

verify_context( context )
CONTEXT *context;
{
	int expr_index;
	EXPR *expr;

	if( context == NULL ) {
		INVALID_CONTEXT( context );
		return FALSE;
	}

	for( expr_index = 0 ; expr_index < context->len ; expr_index++ ) {
		expr = context->data[expr_index];
		if( !verify_expr( expr ) ) {
			dprintf(D_ALWAYS, "verify_context(%x): invalid expr(%x), expr_index=%d\n", context, expr, expr_index);
			dprintf(D_ALWAYS, "verify_context(%x): length=%d, max_len=%d\n", context, context->len, context->max_len);
			INVALID_CONTEXT( context );
			return FALSE;
		}
	}
	return TRUE;
}

verify_expr( expr )
EXPR *expr;
{
	ELEM *elem;
	int elem_index;

	if( expr == NULL ) {
		dprintf( D_ALWAYS, "verify_expr(%x): NULL expr\n", expr);
		INVALID_EXPR( expr );
		return FALSE;
	}
	if( expr->len > MAX_EXPR_LIST || expr->len < 0 ) {
		dprintf( D_ALWAYS, "verify_expr(%x): bad expr length=%d\n", expr, expr->len);
		dprintf( D_ALWAYS, "verify_expr(%x): len=%d, max_len=%d\n", expr, expr->len,expr->max_len);
		INVALID_EXPR( expr );
		return FALSE;
	}
	for( elem_index = 0 ; elem_index < expr->len ; elem_index++ ) {
		elem = expr->data[elem_index];
		if( !verify_elem( elem, elem_index ) ) {
			dprintf( D_ALWAYS, "verify_expr(%x): bad element, index=%d\n", expr, elem_index);
			dprintf( D_ALWAYS, "verify_expr(%x): len=%d, max_len=%d\n", expr, expr->len,expr->max_len);
			INVALID_ELEM( elem );
			return FALSE;
		}
	}
	return TRUE;
}

verify_elem( elem, index )
ELEM *elem;
int index;
{
	if( elem == NULL ) {
		dprintf( D_ALWAYS, "verify_elem(%x,%d): NULL element\n",elem,index);
		INVALID_ELEM( elem );
		return FALSE;
	}
	if( elem->type > ERROR || (elem->type < LT && elem->type != ENDMARKER ) ) {
		dprintf( D_ALWAYS, "verify_elem(%x,%d): invalid element type is %d\n", elem, index, elem->type);
		INVALID_ELEM( elem );
		return FALSE; 
	}
	if( index == 0 && elem->type != NAME ) {
		dprintf( D_ALWAYS, "verify_elem(%x,%d): first element not a name\n", elem, index);
		dprintf( D_ALWAYS, "verify_elem(%x,%d): element type is %d\n", elem, index, elem->type);
		INVALID_ELEM( elem );
		return FALSE;
	}
	if( elem->type == NAME ) {
		if( verify_string( elem->s_val ) == FALSE ) {
			dprintf( D_ALWAYS, "verify_elem(%x,%d): invalid string for type NAME\n", elem, index);
			INVALID_ELEM( elem );
			return FALSE;
		}
	}
	if( elem->type == STRING ) {
		if( verify_string( elem->s_val ) == FALSE ) {
			dprintf( D_ALWAYS, "verify_elem(%x,%d): invalid string for type STRING\n", elem, index);
			INVALID_ELEM( elem );
			return FALSE;
		}
	}
	return TRUE;
}

verify_string( elt_string )
char *elt_string;
{
	int i;
	char *ptr = elt_string;

	for( i = 0 ; i < MAX_STRING ; i++ ) {
		if( *ptr == '\0' )
			return TRUE;
		ptr++;
	}
	return FALSE;
}
#endif VERIFY_CONTEXT
