#include <cm/cmmd.h>
#include <math.h>
#include "pi.h"

int
approx_pi_points()
{
	float	x = 2.0;
	float	y = 2.0;

	while( x < -1 || x > 1 ) {
		x = 1 - (float) (random() & (long)((1<<20)-1)) / (float)(1<<18);
	}
	while( y < -1 || y > 1 ) {
		y = 1 - (float) (random() & (long)((1<<20)-1)) / (float)(1<<18);
	}
	return sqrt( x*x + y*y) <= 1;
}

void
CMPE_start_workers()
{
	int		work;

	srandom( CMMD_self_address() );
	CMMD_send( CMMD_host_node(), FREE_WORKER, NULL, 0 );
	CMMD_receive( CMMD_host_node(), ANY_TAG, &work, sizeof(int) );

	while( work ) {
		int		i;
		int		hits = 0;

		switch( CMMD_msg_tag() ) {
			case WORK:
				for( i=0; i<work; i++ ) {
					if( approx_pi_points() ) {
						hits++;
					}
				}
				CMMD_send( CMMD_host_node(), ANSWER, &hits, sizeof(int) );
				CMMD_send( CMMD_host_node(), FREE_WORKER, NULL, 0 );
				CMMD_receive( CMMD_host_node(), ANY_TAG, &work, sizeof(int) );
				break;
			case STOP:
				return;
			default:
				printf( "Error: bad tag (%d)\n", CMMD_msg_tag() );
				return;
		}
	}
}
