#include <stdio.h>
#include <sys/file.h>

extern int	AvoidNFS;

usage( my_name )
char	*my_name;
{
	fprintf( stderr, "Usage: %s filename\n", my_name );
	exit( 1 );
}

main( argc, argv )
int		argc;
char	*argv[];
{
	int		a, b, c, x;

	if( argc != 2 ) {
		usage( argv[0] );
	}

	x = open( argv[1], O_RDONLY, 0 );		/* should get 3 */
	a = open( argv[1], O_RDONLY, 0 );		/* should get 4 */
	b = open( argv[1], O_RDONLY, 0 );		/* should get 5 */
	c = dup( b );							/* 6 becomes dup of 5 */
	close( a );								/* deallocate 4 */
	a = dup( b );							/* 4 becomes dup of 5 */
	close( b );								/* deallocate 5 */
	close( x );								/* deallocate 3 */

	/*********************************************************
	**
	** File table should look like this now:
	**
	**	0: Stdin
	**	1: Stdout
	**	2: Stderr
	**	3: Not Open
	**	4: argv[1]		(a)
	**	5: Not Open
	**	6: Dup of 4		(b)
	**
	*********************************************************/

		/* at this point a & c should dups with fd numbers 3 & 5 respectively */
	if( a !=4 || c != 6 ) {
		printf( "Error: a = %d, c = %d\n", a, c );
		abort();
		exit( 1 );
	}
	printf( "OK\n" );
	check( a, c );

	AvoidNFS = 1;
	ckpt();
	check( a, c );

	AvoidNFS = 0;
	ckpt();
	check( a, c );

	printf( "Normal End of Job\n" );
	exit( 0 );
}

/*
** We're given 2 file descriptors which are claimed to be dup's.  Seek
** one to the end, then check that the other is also seek'd to
** the same place.  For good measure, seek the other one to the beginning,
** and check to see that the first got moved to the beginning also.
*/
check( a, b )
int		a, b;
{
	int		end;

	end = lseek( a, 0, 2 );
	if( lseek(b,0,1) != end ) {
		printf( "Error: file %d is not a dup of file %d\n", a, b );
		abort();
		exit( 1 );
	}

	lseek( b, 0, 0 );
	if( lseek(a,0,1) != 0 ) {
		printf( "Error: file %d is not a dup of file %d\n", a, b );
		abort();
		exit( 1 );
	}
	printf( "OK\n" );
}

abort()
{
	int i;
	int j;
	char	*foo = (char *)0;

	fflush( stdout );
	fflush( stderr );
	j = 0;
	i = 1 / j;
	*foo = 'a';
	exit( 13 );
}
