#include <stdio.h>
#include <cm/cmmd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "pi.h"

char	*MyName;

void
main( argc, argv )
int argc;
char *argv[];
{
	int	numtrials;
	int	work_left;
	int	work_increment;
	int	numhits = 0;
	int numworking = 0;
	int	answer;

	MyName = argv[0];

	if( argc < 3 ) {
		print_usage();
		exit( 1 );
	}


	numtrials = atoi( argv[1] );
	work_left = numtrials;
	work_increment = atoi( argv[2] );

	printf( "numtrials = %d\n", numtrials );
	printf( "work_increment = %d\n", work_increment );
	printf( "%d nodes\n", CMMD_partition_size() );


	CMMD_enable();
	start_workers();

	while( work_left ) {
		int		free_worker;

		if( CMMD_msg_pending(ANY_NODE, FREE_WORKER) ) {
			CMMD_receive( ANY_NODE, FREE_WORKER, NULL, 0 );
			free_worker = CMMD_msg_sender();

			if( work_left < work_increment ) {
				CMMD_send( free_worker, WORK, &work_left, sizeof(int) );
				work_left = 0;
			} else {
				CMMD_send( free_worker, WORK, &work_increment, sizeof(int) );
				work_left -= work_increment;
			};
			numworking++;
		}
		if( CMMD_msg_pending(ANY_NODE,ANSWER) ) {
			CMMD_receive( ANY_NODE, ANSWER, &answer, sizeof(int) );
			numhits += answer;

			printf( "\t Worker %d reports %d hits\n",
												CMMD_msg_sender(), answer );

			numworking --;
		}
	}

	while( numworking ) {
		if( CMMD_msg_pending(ANY_NODE,ANSWER) ) {
			CMMD_receive( ANY_NODE, ANSWER, &answer, sizeof(int) );
			numhits += answer;

			printf( "\t Worker %d reports %d hits\n",
												CMMD_msg_sender(), answer );

			numworking --;
		}
	}

	{
		int		worker;

		for( worker=0; worker < CMMD_partition_size(); worker++ ) {
			CMMD_receive( worker, FREE_WORKER, NULL, 0 );
			CMMD_send( worker, STOP, NULL, 0 );
		}
	}

	CMMD_disable();

	printf( "\tpi = %f\n", (float)(4*numhits) / (float)numtrials );
	printf( "task done\n" );
	exit( 0 );
}

print_usage()
{
	fprintf( stderr, "Usage: %s <number of trials> <work increment>\n",
	MyName );
}
