/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 



#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/seg.h>
#include <netinet/in.h>
#include <setjmp.h>

#include <filehdr.h>
#include <aouthdr.h>
#include <scnhdr.h>
#include <sys/pseg.h>

#include "condor_sys.h"
#include "trace.h"
#include "ckpt.h"
#include "except.h"
#include "debug.h"

#undef TRACE
#define TRACE dprintf( D_FULLDEBUG, "At %d in %f\n", __LINE__, __FILE__ )

static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */

#define AOUT_HDR_SIZE   sizeof(struct aouthdr)
#define COFF_HDR_SIZE   sizeof(struct filehdr)

	/* Generate a pointer into memory given another pointer and an offset */
#define MSEEK(ptr,off) ((char *)(ptr)+(int)(off))

#ifdef VOID_SIGNAL_RETURN
#define sighandler_t void
#else
#define sighandler_t int
#endif


#ifdef DEBUG
#define STACKSIZ	(1024*1024)
#else
#define STACKSIZ	(128*1024)
#endif

char	 TmpStack[ STACKSIZ ];

extern char	Condor_CWD[ ];
char	CkptName[ MAXPATHLEN ];
extern int	RunningAsCondor;
extern int	Syscalls;

extern RESTREC	 RestartInfo;

sighandler_t CKPT();
sighandler_t KILL();

int CkptInProgress;
int SyscallInProgress;
int CkptWanted;
int KillWanted;

int	StackSize;
jmp_buf LongJumpBuf;
int		SavedBrk;
int		RestoringStack;




struct sigaction	oUsr2Action;
struct sigstack	SigStack, oSigStack;
int				SigMask;

restart( ckpt_file )
char	*ckpt_file;
{

	sighandler_t 		restart2();
	struct sigaction	usr2_action;
	int					rval;


	strcpy( CkptName, ckpt_file );
	(void) SetSyscalls( SYS_LOCAL | SYS_UNRECORDED );

		/* Set up a temporary stack */
	SigStack.ss_sp = &TmpStack[ STACKSIZ ];
	SigStack.ss_onstack = 0;
	if( sigstack(&SigStack, &oSigStack) < 0 ) {
		EXCEPT( "Can't set signal stack to TmpStack" );
	}

		/* Set up to call restart2 on the temporary stack when USR2 is raised */
	usr2_action.sa_handler = restart2;
	sigemptyset( &usr2_action.sa_mask );
	usr2_action.sa_flags = SA_ONSTACK;


	if( sigaction(SIGUSR2,&usr2_action,&oUsr2Action) < 0 ) {
		EXCEPT( "can't set sigaction for SIGUSR2" );
	}

	dprintf(D_CKPT, "restart: about to kill SIGUSR2\n");

	kill( getpid(), SIGUSR2 );
	sigpause( 0 );
}

sighandler_t
restart2()
{
	char				*coff;
	struct filehdr		*coff_hdr;
	struct scnhdr		*scn_hdrs;
	int					i;
	struct sigaction	tstp_action, usr1_action;

	dprintf(D_CKPT,
		"restart2: CkptWanted %d,CkptInProgress %d, SyscallInProgress %d\n",
			CkptWanted, CkptInProgress, SyscallInProgress);

	/*
	TRACE;
	*/

		/* set TSTP to CKPT() */
	tstp_action.sa_handler = CKPT;
	sigemptyset( &tstp_action.sa_mask );
	tstp_action.sa_flags = 0;
	if( sigaction(SIGTSTP,&tstp_action,(struct sigaction *)0) < 0 ) {
		EXCEPT( "can't set sigaction for SIGTSTP" );
	}
	TRACE;

		/* set USR1 to KILL() */
	usr1_action.sa_handler = KILL;
	sigemptyset( &usr1_action.sa_mask );
	usr1_action.sa_flags = 0;
	if( sigaction(SIGUSR1,&usr1_action,(struct sigaction *)0) < 0 ) {
		EXCEPT( "can't set sigaction for SIGUSR1" );
	}
	TRACE;

		/* set USR2 to original value */
	if( sigaction(SIGUSR2,&oUsr2Action,(struct sigaction *)0) < 0 ) {
		EXCEPT( "can't set sigaction for SIGUSR2" );
	}
	TRACE;

		/* set Signal Stack to original value */
	if( sigstack(&oSigStack, (struct sigstack *) 0) < 0 ) {
		EXCEPT("sigstack(&oSigStack [0x%x], 0), errno = %d",
			&oSigStack, errno );
	}

	sigsetmask( 0 );

	/*
	display_syscall_mode( __LINE__, __FILE__ );
	DumpOpenFds();
	*/

	TRACE;
	coff = (char *)map_file( CkptName, O_RDONLY, 0 );		/* rwong */
	TRACE;
	coff_hdr = (struct filehdr *)coff;
	TRACE;
	scn_hdrs = (struct scnhdr *)MSEEK( coff_hdr, COFF_HDR_SIZE + AOUT_HDR_SIZE);
	TRACE;

	for( i=0; i<coff_hdr->f_nscns; i++ ) {
		/*
		dprintf( D_ALWAYS, "scn_hdrs[%d].s_name = \"%s\"\n",
													i, scn_hdrs[i].s_name );
		*/
		/*
		if( strcmp(".shdata",scn_hdrs[i].s_name) == 0 ) {
			restore_data_seg( scn_hdrs+i, coff );
		}
		*/
		if( strcmp(".stack",scn_hdrs[i].s_name) ==  0 ) {
			RestoringStack = TRUE;
			restore_data_seg( scn_hdrs+i, coff );
			RestoringStack = FALSE;
		}
	}
	unmap_file( coff );
	TRACE;

	/*
	dprintf( D_CKPT, "Not resetting Brk to 0x%x\n", SavedBrk );
	if( brk(SavedBrk) < 0 ) {
		EXCEPT( "brk(0x%x)", SavedBrk );
	}
	dprintf( D_CKPT, "Brk reset to 0x%x\n", SavedBrk );
	*/

	/*
	**	Reopen and reposition all active files.  The open file table
	**	does not need to be read from the checkpoint file because it
	**	resides in memory.  The checkpoint version is there for
	**	initialization and for other programs to examine.
	*/
	if( RunningAsCondor ) {
		(void) SetSyscalls( SYS_REMOTE | SYS_UNRECORDED );
	} else {
		(void) SetSyscalls( SYS_LOCAL | SYS_UNRECORDED );
	}
	if( chdir(Condor_CWD) < 0 ) {
		EXCEPT(Condor_CWD);
	}
	ReopenFiles();
	(void) SetSyscalls( SYS_LOCAL | SYS_RECORDED );


	dprintf(D_CKPT, "restart2: about to longjmp!\n");
	CkptInProgress = 0;
	longjmp( LongJumpBuf, 1 );
	EXCEPT("restart2: what happened to longjmp????");
}

restore_data_seg( hdr, coff )
struct	scnhdr	*hdr;
char			*coff;
{
	char	*src, *dst;
	int		len;

	src = MSEEK( coff, hdr->s_scnptr );
	dst = (char *) (hdr->s_vaddr | PRIVORG);		/* rwong */
	len = hdr->s_size;

	/*
	** Sanity check.  The highest address in the stack area should be
	** a well known address...
	*/
	if( RestoringStack ) {
		if( (long) (dst + len) != USRSTACK ) {		/* rwong */
			dprintf( D_ALWAYS, "Error: User stack not at 0x%x\n", USRSTACK );
			dprintf( D_ALWAYS, "Specified addrs 0x%x - 0x%x (0x%x bytes)\n",
				dst, dst + len, len );
			exit( 1 );
		}
	}

	bcopy( src, dst, len );
	dprintf( D_CKPT, "Restored data seg 0x%x - 0x%x (0x%x bytes)\n",
		dst, dst+len, len );
}
