/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Author:  Rick Rasmussen
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 

#include <stdio.h>
#include <sys/types.h>
#include <ndbm.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/file.h>
#if defined(MIPS) && (defined(ULTRIX) || defined(ULTRIX42))
#include <limits.h>
#endif /* MIPS && ULTRIX */
#include <sys/stat.h>
#include <sys/socket.h>

#include "sched.h"
#include "expr.h"
#include "manager.h"
#include "debug.h"
#include "except.h"

static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)	*/

extern MACH_REC *MachineList;

extern char *strdup();
extern char *param();

/*
** Tuple for the priority database.  Key off of the network address.
*/
typedef struct stored_prio {
    struct in_addr net_addr;
    int prio;
} STORED_PRIO;

#define PRIORITIES_FILE "~condor/log/priorites" /* name of file */
#define PRIORITIES_FILE_FLAGS (O_RDWR|O_CREAT) /* umask for file creation */
#if defined(MIPS) && (defined(ULTRIX) || defined(ULTRIX42))
#define PRIORITIES_FILE_MODE (S_IRUSR|S_IWUSR) /* mode for file creation */
#else
#define PRIORITIES_FILE_MODE (S_IREAD|S_IWRITE)
#endif /* MIPS && ULTRIX */

DBM *PrioDB;
int StablePriosInited = FALSE;

/*
** Determine where priority database will be stored.  This should probably
** be moved to the config files.
*/
char *
prioDB_filename()
{
	char *logdir;
	char filename[BUFSIZ];

	logdir = param( "LOG" );

	sprintf(filename, "%s/priorities", logdir);

	return(strdup(filename));
}

/*
** Initialize the database to contain priorities.
*/
init_stable_prios()
{
	char *priorities_file;

	priorities_file = prioDB_filename();

    PrioDB = dbm_open(priorities_file, PRIORITIES_FILE_FLAGS, 
		      PRIORITIES_FILE_MODE);

	free(priorities_file);

	if(PrioDB == NULL) {
#if !defined(AIX31) && !defined(AIX32)
		dprintf( D_ALWAYS, "Real uid = %d, Effective uid = %d\n",
				getuid(), geteuid() );
#endif
		EXCEPT( "dbm_open(%s,0%o,0%o)", priorities_file, PRIORITIES_FILE_FLAGS,
				PRIORITIES_FILE_MODE );
	}

	dprintf( D_ALWAYS, "prio db opened ok\n" );
    StablePriosInited = TRUE;
}

/*
** Close the priorities DB.
*/
close_stable_prios()
{
    dbm_close(PrioDB);
}

/*
** Store a priority in the DB.
*/
store_prio(addr, prio)
struct in_addr *addr;
int prio;
{
    datum key;
    datum tuple;
    STORED_PRIO stored_prio;

    bcopy((char *)addr, (char *)&stored_prio.net_addr, sizeof(stored_prio));
    stored_prio.prio = prio;

    key.dptr = (char *)&stored_prio.net_addr;
    key.dsize = sizeof(stored_prio.net_addr);
    
    tuple.dptr = (char *)&stored_prio;
    tuple.dsize = sizeof(stored_prio);

    if( dbm_store(PrioDB, key, tuple, DBM_REPLACE) < 0 ) {
		dprintf(D_ALWAYS, "Couldn't store prio.\n");
    }
}

/*
** Retrieve a prio from the DB.  Return zero if it wasn't previously stored.
*/
int
retrieve_prio(addr)
struct in_addr *addr;
{
    STORED_PRIO *stored_prio_ptr;
    STORED_PRIO stored_prio;
    datum key;
    datum tuple;
	struct in_addr newaddr;

    key.dptr = (char *)addr;
    key.dsize = sizeof(struct in_addr);

    tuple = dbm_fetch(PrioDB, key);

	/*
	** If the machine hasn't been stored in the DB previously, create a
	** record for it and give it a priority of zero.
	*/
    if( tuple.dptr == NULL ) {
		store_prio(addr, 0);
		return(0);
    }

    stored_prio_ptr = (STORED_PRIO *)tuple.dptr;

    return(stored_prio_ptr->prio);
}

/*
** Return the name of a host given its address.  Return NULL if unknown.
*/
char *
gethostnamebyaddr(addr)
struct in_addr *addr;
{
	struct hostent *hp;

	hp = gethostbyaddr(addr, sizeof(struct in_addr), AF_INET);

	if(hp) {
		return(strdup(hp->h_name));
	}
	else {
		return(NULL);
	}
}

/*
** Store all priorities to the DB.
*/
store_prios()
{
	MACH_REC *ptr;

	ptr = MachineList->next;

	while(ptr->name) {
		store_prio(&ptr->net_addr, ptr->prio);

		ptr = ptr->next;
	}
}

