/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 

#include <stdio.h>


#define __EXTENSIONS__
/*
** The syms.h file includes a "#pragma once" directive, but the irix
** cpp doesn't accept it.  Here's a crude work around...
*/
#define pragma define
#include <a.out.h>
#undef pragma

#include <sys/file.h>
#include <sys/dir.h>
#include <sys/param.h>
#include <sys/user.h>

#include "coff_desc.h"
#include "debug.h"
#include "except.h"

#if defined(IRIX331)
#include <core.out.h>
typedef struct coreout CORE_HEADER;
typedef struct vmap VMAP;

char	*SectionNames[] = {
	"I_GPREGS",
	"I_FPREGS",
	"I_SPECREGS",
	"I_SIGHANDLER",
	"I_EXDATA",
};

char	*SegNames[] = {
	"(UNKNOWN)",
	"VTEXT",
	"VDATA",
	"VSTACK",
	"VSHMEM",
	"VLIBTEXT",
	"VLIBDATA",
	"VGRAPHICS",
	"VMAPFILE",
};
#endif

static char *_FileName_ = __FILE__;     /* Used by EXCEPT (see except.h)     */

extern int	DebugFlags;


long		StackSize;
DATA_BLOCK	StackLoc;
DATA_BLOCK	MapLoc;

#define pfield(name,ptr,field,how) \
	printf("%-30.30s = how\n", "name.field", ptr->field)


_updateckpt( ckpt, obj, core )
char *ckpt, *obj, *core;
{
	COFF_DESC	desc;
	int			exec_fd, core_fd, ckpt_fd;

	if( core == NULL ) {
		_mkckpt( ckpt, obj );
		return;
	}

	if( (exec_fd=open(obj,O_RDONLY,0)) < 0 ) {
		EXCEPT( "open(%s,O_RDONLY,0)", obj );
	}

	if( (core_fd=open(core,O_RDONLY,0)) < 0 ) {
		EXCEPT( "open(%s,O_RDONLY,0)", core );
	}

	if( (ckpt_fd=open(ckpt,O_WRONLY|O_CREAT|O_TRUNC,0775)) < 0 ) {
		EXCEPT( "open(%s,O_WRONLY|O_CREAT|O_TRUNC,0775)", ckpt );
	}

	dprintf( D_CKPT, "exec_fd = %d, core_fd = %d, ckpt_fd = %d\n",
		exec_fd, core_fd, ckpt_fd );

	create_coff_desc( exec_fd, &desc );
	/*
	if( DebugFlags & D_CKPT ) {
		display_coff_desc( &desc );
	}
	*/

	update_coff_desc( core_fd, &desc );
	if( DebugFlags & D_CKPT ) {
		display_coff_desc( &desc );
	}

	write_coff_file( &desc, ckpt_fd );

	(void)close( exec_fd );
	(void)close( core_fd );
	(void)close( ckpt_fd );
}

FILE_HDR	file_hdr;
AOUT_HDR	aout_hdr;
HDRR		symbolic_hdr;

create_coff_desc( exec_fd, coff_desc )
int		exec_fd;
COFF_DESC	*coff_desc;
{
	SECTION		*sect;
	SCN_HDR		*s_hdr;
	int 		i;
	int			sym_tab_start;
	int			sym_tab_len;
	int			str_tab_start;
	int			str_tab_len;
	int			stack_end;
	long		stack_len = 99;


		/* Deal with coff file header */
	if( read(exec_fd,&file_hdr,FILE_HDR_SIZ) != FILE_HDR_SIZ ) {
		EXCEPT( "read(%d,0x%x,%d)", exec_fd, &file_hdr, FILE_HDR_SIZ);
	}

	coff_desc->file_hdr = &file_hdr;

		/* Deal with optional header (a.out header) */
    if( file_hdr.f_opthdr != AOUT_HDR_SIZ ) {
        EXCEPT( "file_hdr.f_opthdr (%d) != AOUT_HDR_SIZ (%d)",
            file_hdr.f_opthdr, AOUT_HDR_SIZ );
    }

    if( read(exec_fd,&aout_hdr,AOUT_HDR_SIZ) != AOUT_HDR_SIZ ) {
    	EXCEPT( "read(%d,0x%x,%d)", exec_fd, &aout_hdr, AOUT_HDR_SIZ );
	}
	coff_desc->aout_hdr = &aout_hdr;


		/* Deal with section headers */
	coff_desc->section =
		(SECTION *)CALLOC( file_hdr.f_nscns, sizeof(SECTION) );
	coff_desc->file_hdr->f_nscns = file_hdr.f_nscns;

    for( i = 0; i < file_hdr.f_nscns; i++ ) {
		sect = &coff_desc->section[i];
		sect->hdr = (SCN_HDR *)CALLOC( 1, SCN_HDR_SIZ );
		s_hdr = sect->hdr;
        if( read(exec_fd,s_hdr,SCN_HDR_SIZ) != SCN_HDR_SIZ ) {
        	EXCEPT( "read(%d,0x%x,%d)", exec_fd, s_hdr, SCN_HDR_SIZ );
        }
		store_file_data( &sect->raw_data,
					exec_fd, s_hdr->s_scnptr, s_hdr->s_size );
		store_file_data( &sect->reloc_info,
					exec_fd, s_hdr->s_relptr, s_hdr->s_nreloc * RELOC_SIZ );
		store_file_data( &sect->lineno_info,
					exec_fd, &s_hdr->s_lnnoptr, s_hdr->s_nlnno * LINENO_SIZ );
    }


		/* Bring symbol table header into core,
		   we'll need to modify the offsets later */
	sym_tab_start = file_hdr.f_symptr;
	sym_tab_len = file_hdr.f_nsyms * SYM_SIZ;
	if( lseek(exec_fd,sym_tab_start,0) != sym_tab_start ) {
		EXCEPT( "lseek(%d,%d,0)", exec_fd, sym_tab_start );
	}
	if( read(exec_fd,&symbolic_hdr,sym_tab_len) != sym_tab_len ) {
		EXCEPT( "read(%d,0x%x,%d)", exec_fd, &symbolic_hdr, sym_tab_len );
	}
	store_core_data( &coff_desc->sym_tab_loc, &symbolic_hdr, sym_tab_len );

		/* Find out how big the stack is */
	stack_end = lseek( exec_fd, -sizeof(stack_len), L_XTND );
	if( stack_end < 0 ) {
		EXCEPT( "lseek(%d,%d,L_XTND)", exec_fd, sizeof(stack_len) );
	}
	if( read(exec_fd,(char *)&stack_len,sizeof(stack_len)) !=
														sizeof(stack_len) ) {
		EXCEPT( "read(%d,0x%x,%d)", exec_fd, &stack_len );
	}

	stack_len = ntohl( stack_len );

		/* Deal with the string table */
	str_tab_start = sym_tab_start + sym_tab_len;
	str_tab_len = stack_end - stack_len - str_tab_start;
	store_file_data( &coff_desc->str_tab_loc, exec_fd, str_tab_start,
															str_tab_len );

}

SECTION	*
find_section( coff_desc, sect_name )
COFF_DESC	*coff_desc;
char		*sect_name;
{
	int		i;

	for( i=0; i<coff_desc->file_hdr->f_nscns; i++ ) {
		if( strcmp(coff_desc->section[i].hdr->s_name,sect_name) == 0 ) {
			return &coff_desc->section[i];
		}
	}
	return NULL;
}

update_coff_desc( core_fd, coff_desc )
int		core_fd;
COFF_DESC	*coff_desc;
{
	int			vmap_bytes;
	CORE_HEADER	header;
	VMAP		*vmaps;
	int			i;
	SECTION		*sdata_sect;
	SECTION		*rdata_sect;
	SECTION		*data_sect;
	SECTION		*bss_sect;
	SECTION		*sbss_sect;
	int			rdata_size;
	int			data_size;
	int			stack_size;
	int			data_off;
	int			stack_off;
	int			delta;

	/* Read in the core file header */
	if(  read(core_fd,&header,sizeof(header)) != sizeof(header) ) {
		EXCEPT( "read of core file header" );
	}
	/*
	display_core_header( &header );
	*/

		/* Read in the vmaps */
	if( lseek(core_fd,header.c_vmapoffset,0) != header.c_vmapoffset ) {
		EXCEPT( "seek to vmap offset" );
	}
	vmap_bytes = header.c_nvmap * sizeof(VMAP);
	vmaps = (VMAP *)malloc( vmap_bytes );
	if( read(core_fd,vmaps,vmap_bytes) != vmap_bytes ) {
		EXCEPT( "read of vmaps" );
	}

		/* Display the vmaps */
	/*
	for( i=0; i<header.c_nvmap; i++ ) {
		printf( "VMAP[ %d ]\n", i );
		display_vmap( &vmaps[i] );
		printf( "\n" );
	}
	*/

	for( i=0; i<header.c_nvmap; i++ ) {
		if( vmaps[i].v_type == VDATA ) {
			data_size = vmaps[i].v_len;
			data_off = (int)vmaps[i].v_offset;
		}
		if( vmaps[i].v_type == VSTACK ) {
			stack_size = vmaps[i].v_len;
			stack_off = (int)vmaps[i].v_offset;
		}
	}

	delta = data_size - coff_desc->aout_hdr->dsize;

	/*
	printf( "data_size = %d bytes\n", data_size );
	printf( "stack_size = %d bytes\n", stack_size );
	printf( "delta = %d bytes\n", delta );
	*/


		/* Get rid of small data */
	sdata_sect = find_section( coff_desc, ".sdata" );
	sdata_sect->hdr->s_size = 0;
	store_file_data( &sdata_sect->raw_data, 0, 0, 0 );

		/* Set up to get rdata from core file */
	rdata_sect = find_section( coff_desc, ".rdata" );
	rdata_size = rdata_sect->hdr->s_size;
	store_file_data( &rdata_sect->raw_data, core_fd, data_off, rdata_size );

		/* Set up to get data from the core file */
	data_sect = find_section( coff_desc, ".data" );
	data_sect->hdr->s_size = data_size - rdata_size;
	store_file_data( &data_sect->raw_data,
		core_fd, data_off + rdata_size, data_size - rdata_size);

		/* Get rid of bss */
	bss_sect = find_section( coff_desc, ".bss" );
	bss_sect->hdr->s_size = 0;

		/* Get rid of sbss */
	sbss_sect = find_section( coff_desc, ".sbss" );
	sbss_sect->hdr->s_size = 0;

		/* Update dsize in a.out header */
	coff_desc->aout_hdr->bsize = 0;
	coff_desc->aout_hdr->dsize = data_size;

		/* Reflect the change in size of the data area in the
		   location of the symbolic header, and all of the things
		   it points to. */
	delta = ( coff_desc->aout_hdr->tsize + data_size ) -
										coff_desc->file_hdr->f_symptr;
	coff_desc->file_hdr->f_symptr += delta;
	symbolic_hdr.cbLineOffset += delta;
	symbolic_hdr.cbDnOffset += delta;
	symbolic_hdr.cbPdOffset += delta;
	symbolic_hdr.cbSymOffset += delta;
	symbolic_hdr.cbOptOffset += delta;
	symbolic_hdr.cbAuxOffset += delta;
	symbolic_hdr.cbSsOffset += delta;
	symbolic_hdr.cbSsExtOffset += delta;
	symbolic_hdr.cbFdOffset += delta;
	symbolic_hdr.cbRfdOffset += delta;
	symbolic_hdr.cbExtOffset += delta;

		/* Set up to get stack from the core file */
	store_file_data( &StackLoc, core_fd, stack_off, stack_size );
	StackSize = htonl( stack_size );
	store_core_data( &MapLoc, &StackSize, sizeof(StackSize) );

}

store_file_data( block, fd, offset, len )
DATA_BLOCK	*block;
int			fd;
int			offset;
int			len;
{
	block->block_tag = FILE_DATA;
	block->block_val.file_block.fd = fd;
	block->block_val.file_block.offset = offset;
	block->block_val.file_block.len = len;
}

store_core_data( block, ptr, len )
DATA_BLOCK	*block;
char		*ptr;
int			len;
{
	block->block_tag = CORE_DATA;
	block->block_val.core_block.data = ptr;
	block->block_val.core_block.len = len;
}

#define TXTOFF(f) \
((FILHSZ + AOUTHSZ + (f)->f_nscns * SCNHSZ + SCNROUND-1) & ~(SCNROUND-1))

write_coff_file( desc, fd )
COFF_DESC	*desc;
int			fd;
{
	int			i;
	int			n_scns;
	AOUT_HDR	*a_hdr;
	FILE_HDR	*f_hdr;

	a_hdr = desc->aout_hdr;
	f_hdr = desc->file_hdr;
	n_scns = desc->file_hdr->f_nscns;

	dprintf( D_CKPT, "Coff File Header:\n" );
	write( fd, f_hdr, FILE_HDR_SIZ );

	dprintf( D_CKPT, "A.out Header:\n" );
	write( fd, a_hdr, AOUT_HDR_SIZ );

	for( i=0; i<n_scns; i++ ) {
		dprintf( D_CKPT, "Section %d Header:\n", i );
		write( fd, desc->section[i].hdr, SCN_HDR_SIZ );
	}

	for( i=0; i<n_scns; i++ ) {
		if( strcmp(".bss",desc->section[i].hdr->s_name) == 0 ) {
			continue;
		}
		if( strcmp(".sbss",desc->section[i].hdr->s_name) == 0 ) {
			continue;
		}
		if( strcmp(".text",desc->section[i].hdr->s_name) == 0 ) {
			if( lseek(fd,TXTOFF(f_hdr),0) != TXTOFF(f_hdr)) {
				EXCEPT( "lseek(%d,%d,L_SET)", fd, TXTOFF(f_hdr) );
			}
		}
		if( strcmp(".rdata",desc->section[i].hdr->s_name) == 0 ) {
			if( lseek(fd,a_hdr->tsize,L_SET) != a_hdr->tsize ) {
				EXCEPT( "lseek(%d,%d,L_SET)", fd, a_hdr->tsize );
			}
		}
		dprintf( D_CKPT, "Section %d Raw Data:\n", i );
		write_data_block( fd, &desc->section[i].raw_data );
	}

	for( i=0; i<n_scns; i++ ) {
		if( strcmp(".bss",desc->section[i].hdr->s_name) == 0 ) {
			continue;
		}
		if( strcmp(".sbss",desc->section[i].hdr->s_name) == 0 ) {
			continue;
		}
		dprintf( D_CKPT, "Section %d Reloc Info:\n", i );
		write_data_block( fd, &desc->section[i].reloc_info );
	}
	for( i=0; i<n_scns; i++ ) {
		if( strcmp(".bss",desc->section[i].hdr->s_name) == 0 ) {
			continue;
		}
		if( strcmp(".sbss",desc->section[i].hdr->s_name) == 0 ) {
			continue;
		}
		dprintf( D_CKPT, "Section %d Lineno Info:\n", i );
		write_data_block( fd, &desc->section[i].lineno_info );
	}

	dprintf( D_CKPT, "Symbol Table:\n" );
	if( lseek(fd,a_hdr->tsize + a_hdr->dsize,L_SET) !=
											a_hdr->tsize + a_hdr->dsize ) {
		EXCEPT( "lseek(%d,%d,L_SET)", fd, a_hdr->tsize + a_hdr->dsize );
	}
	write_data_block( fd,  &desc->sym_tab_loc );

	dprintf( D_CKPT, "String Table:\n" );
	write_data_block( fd,  &desc->str_tab_loc );

	dprintf( D_CKPT, "Stack:\n" );
	write_data_block( fd, &StackLoc );

	dprintf( D_CKPT, "CkptMap:\n" );
	write_data_block( fd, &MapLoc );
}

write_data_block( fd, block )
int		fd;
DATA_BLOCK	*block;
{
	switch( block->block_tag ) {
		case FILE_DATA:
			write_file_block( fd, &block->block_val.file_block );
			break;
		case CORE_DATA:
			write_core_block( fd, &block->block_val.core_block );
			break;
		default:
			EXCEPT( "write_data_block: unknown type (%d)", block->block_tag );
			break;
	}
}

write_file_block( fd, block )
int		fd;
FILE_BLOCK	*block;
{
	int		n, got;
	char	buf[1024];
	int		start, end;

	if( block->len == 0 ) {
		return;
	}
	dprintf( D_CKPT,"file_block: in_fd=%d, out_fd=%d, in_addr=%d, len=%d\n",
							block->fd, fd, block->offset, block->len );
	if( DebugFlags & D_CKPT ) {
		start = lseek(fd,0,1);
		if( start < 0 ) {
			EXCEPT( "lseek(%d,0,L_INCR)", fd );
		}
	}

	if( lseek(block->fd,block->offset,0) != block->offset ) {
		EXCEPT( "lseek(%d,%d,0)", block->fd, block->offset );
	}

	n = block->len;
	while( n > 0 ) {
		got = read(block->fd,buf,MIN(n,sizeof(buf)));
		if( got < 0 ) {
			EXCEPT( "read(%d,0x%x,%d)", block->fd, buf, MIN(n,sizeof(buf)) );
		}
		if( write(fd,buf,got) != got ) {
			EXCEPT( "write(%d,0x%x,%d)", fd, buf, got );
		}
		n -= got;
	}

	if( DebugFlags & D_CKPT ) {
		end = lseek(fd,0,1);
		if( end < 0 ) {
			EXCEPT( "lseek(%d,0,L_INCR)", fd );
		}
	}
	dprintf( D_CKPT, "\twrote %d bytes (%d - %d)\n",
												block->len, start, end-1 );
}

write_core_block( fd, block )
int		fd;
CORE_BLOCK	*block;
{
	int		start, end;

	if( block->len == 0 ) {
		return;
	}
	dprintf( D_CKPT, "core_block: out_fd=%d, in_addr=0x%x, len=%d\n",
								fd, block->data, block->len );
	if( DebugFlags & D_CKPT ) {
		start = lseek(fd,0,1);
		if( start < 0 ) {
			EXCEPT( "lseek(%d,0,L_INCR)", fd );
		}
	}

	if( write(fd,block->data,block->len) != block->len ) {
		EXCEPT( "write(%d,0x%x,%d)", fd, block->data, block->len );
	}

	if( DebugFlags & D_CKPT ) {
		end = lseek(fd,0,1);
		if( end < 0 ) {
			EXCEPT( "lseek(%d,0,L_INCR)", fd );
		}
	}
	dprintf( D_CKPT, "\twrote %d bytes (%d - %d)\n",
												block->len, start, end-1 );
}

display_vmap( v )
VMAP	*v;
{
	if( v->v_flags == VDUMPED ) {
		pfield(vmap,v,v_vaddr,0x%x);
		pfield(vmap,v,v_len,%d);
		pfield(vmap,v,v_offset,0x%x);
	}
	if( v->v_flags == VDUMPED ) {
		pfield(vmap,v,v_flags,DUMPED);
	} else {
		pfield(vmap,v,v_flags,(MISSING));
	}
		
	/*
	printf("%-30.30s = %s\n", "vmap.v_flags", SegNames[v->v_type] );
	*/
}

display_core_header( h )
CORE_HEADER	*h;
{
	int		i;

	printf( "CORE FILE HEADER\n" );
	if( h->c_magic == CORE_MAGIC ) {
		pfield(header,h,c_magic,CORE_MAGIC);
	} else {
		fprintf( stderr, "Invalid magic number (0x%x)\n", h->c_magic );
		exit( 1 );
	}
	pfield(header,h,c_version,%d);
	pfield(header,h,c_vmapoffset,0x%x);
	pfield(header,h,c_nvmap,%d);
	pfield(header,h,c_name,%s);
	pfield(header,h,c_args,%s);
	pfield(header,h,c_sigcause,%d);
	printf( "\n" );

}

display_uarea( u )
struct user	*u;
{
#if !defined(IRIX331)
	dprintf( D_CKPT, "UPAGES = %d\n", UPAGES * NBPG );
	dprintf( D_CKPT, "u_dsize = %d\n", u->u_dsize * CLBYTES );
	dprintf( D_CKPT, "u_ssize = %d\n", u->u_ssize * CLBYTES );
	dprintf( D_CKPT, "sum is %d\n",
			UPAGES * NBPG + u->u_dsize * CLBYTES + u->u_ssize * CLBYTES );
#endif
}


display_filehdr( fhp )
struct filehdr *fhp;
{
	pfield(filehdr,fhp,f_magic,0%o);
	pfield(filehdr,fhp,f_nscns,%d);
	printf("%-30.30s = %s", "filehdr.f_timdat", ctime(&fhp->f_timdat) );
	pfield(filehdr,fhp,f_symptr,%d);
	pfield(filehdr,fhp,f_nsyms,%d);
	pfield(filehdr,fhp,f_opthdr,%d);
	pfield(filehdr,fhp,f_flags,0x%x);
}

display_aouthdr( ahp )
struct aouthdr *ahp;
{
	pfield(aouthdr,ahp,magic,0%o);
	pfield(aouthdr,ahp,vstamp,0x%x);
	pfield(aouthdr,ahp,tsize,%d);
	pfield(aouthdr,ahp,dsize,%d);
	pfield(aouthdr,ahp,bsize,%d);
	pfield(aouthdr,ahp,entry,0x%x);
	pfield(aouthdr,ahp,text_start,0x%x);
	pfield(aouthdr,ahp,data_start,0x%x);
	pfield(aouthdr,ahp,bss_start,0x%x);
	pfield(aouthdr,ahp,gprmask,0x%x);
	pfield(aouthdr,ahp,cprmask[0],0x%x);
	pfield(aouthdr,ahp,cprmask[1],0x%x);
	pfield(aouthdr,ahp,cprmask[2],0x%x);
	pfield(aouthdr,ahp,cprmask[3],0x%x);
	pfield(aouthdr,ahp,gp_value,0x%x);
}

display_scnhdr( shp )
struct scnhdr *shp;
{
	pfield(scnhdr,shp,s_name,%.8s);
	pfield(scnhdr,shp,s_paddr,0x%x);
	pfield(scnhdr,shp,s_vaddr,0x%x);
	pfield(scnhdr,shp,s_size,0x%x);
	pfield(scnhdr,shp,s_scnptr,0x%x);
	pfield(scnhdr,shp,s_relptr,0x%x);
	pfield(scnhdr,shp,s_lnnoptr,0x%x);
	pfield(scnhdr,shp,s_nreloc,%d);
	pfield(scnhdr,shp,s_nlnno,%d);
	pfield(scnhdr,shp,s_flags,0x%x);
}

display_symbolic_hdr( shp )
HDRR	*shp;
{
	pfield(symbolic_hdr,shp,magic,0%0);
	pfield(symbolic_hdr,shp,vstamp,0%0);
	pfield(symbolic_hdr,shp,ilineMax,%d);
	pfield(symbolic_hdr,shp,cbLine,%d);
	pfield(symbolic_hdr,shp,cbLineOffset,%d);
	pfield(symbolic_hdr,shp,idnMax,%d);
	pfield(symbolic_hdr,shp,cbDnOffset,%d);
	pfield(symbolic_hdr,shp,ipdMax,%d);
	pfield(symbolic_hdr,shp,cbPdOffset,%d);
	pfield(symbolic_hdr,shp,isymMax,%d);
	pfield(symbolic_hdr,shp,cbSymOffset,%d);
	pfield(symbolic_hdr,shp,ioptMax,%d);
	pfield(symbolic_hdr,shp,cbOptOffset,%d);
	pfield(symbolic_hdr,shp,iauxMax,%d);
	pfield(symbolic_hdr,shp,cbAuxOffset,%d);
	pfield(symbolic_hdr,shp,issMax,%d);
	pfield(symbolic_hdr,shp,cbSsOffset,%d);
	pfield(symbolic_hdr,shp,issExtMax,%d);
	pfield(symbolic_hdr,shp,cbSsExtOffset,%d);
	pfield(symbolic_hdr,shp,ifdMax,%d);
	pfield(symbolic_hdr,shp,cbFdOffset,%d);
	pfield(symbolic_hdr,shp,crfd,%d);
	pfield(symbolic_hdr,shp,cbRfdOffset,%d);
	pfield(symbolic_hdr,shp,iextMax,%d);
	pfield(symbolic_hdr,shp,cbExtOffset,%d);
}

display_coff_desc( desc )
COFF_DESC	*desc;
{
	int		i;

	dprintf( D_ALWAYS, "FILE HEADER:\n" );
	printf( "FILE HEADER:\n" );
	display_filehdr( desc->file_hdr );

	printf( "OPT HEADER:\n" );
	display_aouthdr( desc->aout_hdr );

	for( i=0; i<desc->file_hdr->f_nscns; i++ ) {
		display_section( &desc->section[i], i );
	}

	printf( "SYMBOL TABLE LOCATION:\n" );
	display_data_block( &desc->sym_tab_loc );
	if( desc->sym_tab_loc.block_tag == CORE_DATA ) {
		printf( "SYMBOLIC HEADER:\n" );
		display_symbolic_hdr( desc->sym_tab_loc.block_val.core_block.data );
	}

	printf( "STRING TABLE LOCATION:\n" );
	display_data_block( &desc->str_tab_loc );
	printf( "\n" );
}


display_data_block( block )
DATA_BLOCK	*block;
{
	switch( block->block_tag ) {
		case FILE_DATA:
			display_file_block( &block->block_val.file_block );
			break;
		case CORE_DATA:
			display_core_block( &block->block_val.core_block );
			break;
		default:
			fprintf( stderr, "UNKNOWN data block tag (%d)\n", block->block_tag);
			exit( 1 );
	}
}

display_file_block( block )
FILE_BLOCK	*block;
{
	printf( "fd	= %d\n", block->fd );
	printf( "offset	= %d\n", block->offset );
	printf( "len	= %d\n", block->len );
}

display_core_block( block )
CORE_BLOCK	*block;
{
	printf( "data	= 0x%x\n", block->data );
	printf( "len	= %d\n", block->len );
}


display_section( sect, sect_no )
SECTION			*sect;
int				sect_no;
{
	printf( "SECTION %d HEADER:\n", sect_no );
	display_scnhdr( sect->hdr );
	printf( "SECTION %d DATA LOCATION:\n", sect_no );
	display_data_block( &sect->raw_data );
	printf( "SECTION %d RELOC INFO LOCATION:\n", sect_no );
	display_data_block( &sect->reloc_info );
	printf( "SECTION %d LINE NUMBER INFO LOCATION:\n", sect_no );
	display_data_block( &sect->lineno_info );
}
