/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include "condor_sys.h"
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/errno.h>
#include <stdio.h>
#include "debug.h"

extern int	Syscalls;

#if !defined(IRIX331)
getrusage( who, rusage )
int who;
struct rusage *rusage;
{
	int rval;
	struct rusage accum_rusage;

	if( Syscalls & SYS_LOCAL ) {
		rval = syscall( SYS_getrusage, who, rusage );
		SET_ERRNO;
	} else {

		if( who != RUSAGE_SELF ) {
			dprintf( D_ALWAYS,
			"ERROR: Attempted getrusage(RUSAGE_ CHILDREN,...) remotely\n" );
			errno = EINVAL;
			return -1;
		}
		/* Get current rusage for the running job. */
		syscall( SYS_getrusage, who, rusage);
		D_RUSAGE( D_FULLDEBUG, rusage );

		/* Get accumulated rusage from previous runs */
		rval = REMOTE_syscall( CONDOR_getrusage, who, &accum_rusage );
		D_RUSAGE( D_FULLDEBUG, &accum_rusage );

		/* Sum the two. */
		update_rusage(rusage, &accum_rusage);
		D_RUSAGE( D_FULLDEBUG, rusage );
	}

	return( rval );
}
#endif
