/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Author:  Michael J. Litzkow
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 

#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/shm.h>
#include <sys/ipc.h>
#include <errno.h>
#include "debug.h"
#include "except.h"

static char *_FileName_ = __FILE__;     /* Used by EXCEPT (see except.h)     */

extern int		errno;

typedef struct {
	int		fd;
	char	*addr;
} MAP_REC;
MAP_REC	MapRec[100];
int		N_MapRecs = 0;

/*
** Store an association between a mapped memory area and the corresponding
** fd.
*/
store_map_rec( fd, addr )
int		fd;
char	*addr;
{
	int		i;

	for( i=0; i<N_MapRecs; i++ ) {
		if( MapRec[i].fd < 0 ) {
			N_MapRecs -= 1;
			break;
		}
	}
	MapRec[i].fd = fd;
	MapRec[i].addr = addr;
	N_MapRecs += 1;
}

/*
** Unmap the file and close the fd.
*/
unmap_file( addr )
char	*addr;
{
	int		i;
	int		answer;

	for( i=0; i<N_MapRecs; i++ ) {
		if( MapRec[i].addr == addr ) {
			if( shmdt(MapRec[i].addr) < 0 ) {
				EXCEPT( "shmdt(0x%x)", MapRec[i].addr );
			}
			if( close(MapRec[i].fd) < 0 ) {
				EXCEPT( "close(%d)", MapRec[i].fd );
			}
			MapRec[i].fd = -1;
			return;
		}
	}
	errno = EINVAL;
	EXCEPT( "unmap_file(%d)", addr );
}

/*
** Open the file in the specified mode, and map it into memory.
*/
char *
map_file( name, open_mode, permissions )
char	*name;
int		open_mode;
int		permissions;
{
	int		fd;
	char	*answer;
	int		sh_flag = SHM_MAP;


	if( (fd=open(name,open_mode,permissions)) < 0 ) {
		EXCEPT(  "open(%s,0%o,0%o)", name, open_mode, permissions );
	}

	if( open_mode == O_RDONLY ) {
		sh_flag |= SHM_RDONLY;
	}

	if( (answer=shmat(fd,0,sh_flag)) == (char *)-1 ) {
		EXCEPT( "shmat(%d,0,0x%x)", fd, sh_flag );
	}

	store_map_rec( fd, answer );
	return answer;
}
