#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/dir.h>

#ifdef AIX31
#include <sys/mntctl.h>
#include <sys/vmount.h>
#include <sys/sysmacros.h>
#define NMOUNT  256
#else AIX31
#include <mntent.h>
#endif AIX31

struct fs_data_req {
	dev_t	dev;
	char	*devname;
	char	*path;
};
struct fs_data {
	struct fs_data_req fd_req;
};
#define NOSTAT_MANY 0

char			*strdup(), *malloc();

/*
** The function getmnt() is Ultrix specific and returns a different structure
** than the similar AIX function mntctl().  Here
** we simulate "getmnt()" by calling the AIX library routine.
** N.B. we simulate getmnt() only to the extent needed specifically
** for this program.  This is NOT a generally correct simulation.
*/
FILE			*setmntent();
struct mntent	*getmntent();
char			*strdup();

getmnt( start, buf, bufsize, mode, path )
int				*start;
struct fs_data	buf[];
unsigned		bufsize;
int				mode;
char			*path;
{
	int				status;
	char			vmt[2048];
	struct vmount   *ptr = (struct vmount *)vmt;
	struct stat		st_buf;
	int				i;
	int				lim;

	status = mntctl( MCTL_QUERY, sizeof(vmt), ptr );
	if( status < 0 ) {
		perror( "mntctl" );
		exit( 1 );
	}

	lim = bufsize / sizeof(struct fs_data);

	if( status < lim ) {
		lim = status;
	}

	for( i=0; i < lim; i++ ) {
		add( ptr, &buf[i] );
		ptr = (struct vmount *) ( (char *)ptr + ptr->vmt_length );
	}

	return status;
}


#define OBJECT vmt2dataptr(vm,VMT_OBJECT)
#define STUB vmt2dataptr(vm,VMT_STUB)
#define HOSTNAME vmt2dataptr(vm,VMT_HOSTNAME)
add( vm, ent )
struct vmount	*vm;
struct fs_data	*ent;
{
	char	buf[1024];
	struct stat	st_buf;


	if( vm->vmt_gfstype == MNT_NFS ) {
		sprintf( buf, "%s:%s", HOSTNAME, OBJECT );
	} else {
		strcpy( buf, OBJECT );
	}

	if( stat(STUB,&st_buf) < 0 ) {
		ent->fd_req.dev = 0;
	} else {
		if( vm->vmt_gfstype == MNT_NFS ) {
			ent->fd_req.dev = st_buf.st_vfs;
		} else {
			ent->fd_req.dev = st_buf.st_dev;
		}
	}
	ent->fd_req.devname = strdup(buf);
	ent->fd_req.path = strdup( STUB );
}
