#include <stdio.h>

int GROT = 1;

main()
{
	if( OpSysIsCorrect() && ArchIsCorrect() ) {
		exit( 0 );
	} else {
		Error();
	}
}

#include <sys/types.h>
#include <sys/stat.h>

OpSysIsCorrect()
{
	if( GROT ) {
#ifdef DYNIX
#ifdef sequent
	return( 1 );
#else sequent
	return( 0 );
#endif sequent
#endif DYNIX

#ifdef BSD43
#if (vax && !ultrix) || ibm032 || mc68000			/* GROT */
	return( 1 );
#else (vax && !ultrix) || ibm032 || mc68000		/* GROT */
	return( 0 );
#endif (vax && !ultrix) || ibm032 || mc68000		/* GROT */
#endif BSD43

#if defined(ULTRIX) || defined(ULTRIX42)
#ifdef ultrix
	return( 1 );
#else ultrix
	return( 0 );
#endif ultrix
#endif defined(ULTRIX) || defined(ULTRIX42)

#if defined( SUNOS40 ) || defined( SUNOS41 )
#ifdef sun
	struct stat statb;
	int rval = stat("/dev/zero", &statb);
	if( rval >= 0 ) {
		return( 1 );
	} else {
		return( 0 );
	}
#else sun
	return( 0 );
#endif sun
#endif /* SUNOS40 || SUNOS41 */

#if defined( CM5 )
	struct stat statb;
	int rval = stat( "/dev/svme0", &statb );
	if( rval >= 0 ) {
		return( 1 );
	} else {
		return( 0 );
	}
#endif

#ifdef SUNOS32
#ifdef sun
	struct stat statb;							/* GROT */
	int rval = stat("/dev/zero", &statb);		/* GROT */
	if( rval < 0 ) {							/* GROT */
		return( 1 );							/* GROT */
	} else {									/* GROT */
		return( 0 );							/* GROT */
	}											/* GROT */
#else sun
	return( 0 );
#endif sun
#endif SUNOS32

#ifdef R6000
#if defined(__DATE__) && defined(__TIMESTAMP__)
	return( 1 );
#else defined(__DATE__) && defined(__TIMESTAMP__)
	return( 0 );
#endif defined(__DATE__) && defined(__TIMESTAMP__)
#endif R6000

#if defined(IRIX331) || defined(IRIX332)
#ifdef sgi
	return( 1 );
#else
	return( 0 );
#endif
#endif IRIX
	}

#if defined(HPUX8)
#ifdef hpux
	return( 1 );
#else
	return( 0 );
#endif
#endif HPUX
	

	return( 0 );
}

ArchIsCorrect()
{
	if( GROT ) {
#ifdef SPARC
#ifdef sparc
	return( 1 );
#else sparc
	return( 0 );
#endif sparc
#endif SPARC

#ifdef MC68020
#if mc68020 || mc68010 || mc68000
	return( 1 );
#else mc68020 || mc68010 || mc68000
	return( 0 );
#endif mc68020 || mc68010 || mc68000
#endif MC68020

#ifdef VAX
#ifdef vax
	return( 1 );
#else vax
	return( 0 );
#endif vax
#endif VAX

#ifdef I386
#ifdef i386
	return( 1 );
#else i386
	return( 0 );
#endif i386
#endif I386

#ifdef MIPS
#ifdef mips
	return( 1 );
#else mips
	return( 0 );
#endif mips
#endif MIPS

#ifdef IBM032
#ifdef ibm032
	return( 1 );
#else ibm032
	return( 0 );
#endif ibm032
#endif IBM032

#ifdef AIX31
	return( 1 );
#endif AIX31

#ifdef SGI
#ifdef sgi
	return( 1 );
#else
	return( 0 );
#endif
#endif SGI

#ifdef HPPAR
#ifdef hp9000s800
	return( 1 );
#else
	return( 0 );
#endif
#endif HPPAR
	}

	return( 0 );
}

Error()
{
	char *Arch = NULL, *OpSys = NULL;

#ifdef SPARC
	Arch = " SPARC";
#endif SPARC

#ifdef MC68020
	Arch = "n MC68020";
#endif MC68020

#ifdef VAX
	Arch = " VAX";
#endif VAX

#ifdef I386
	Arch = "n I386";
#endif I386

#ifdef IBM032
	Arch = "n IBM032";
#endif IBM032


#ifdef DYNIX
	OpSys = "DYNIX";
#endif DYNIX

#ifdef BSD43
	OpSys = "BSD43 (4.3 BSD Unix)";
#endif BSD43

#ifdef ULTRIX42
	OpSys = "ULTRIX42";
#endif ULTRIX42

#ifdef ULTRIX
	OpSys = "ULTRIX";
#endif ULTRIX

#ifdef SUNOS40
	OpSys = "SUNOS40";
#endif SUNOS40

#ifdef SUNOS41
	OpSys = "SUNOS41";
#endif SUNOS41

#ifdef SUNOS32
	OpSys = "SUNOS32";
#endif SUNOS32

	if( Arch && OpSys ) {
		printf("\7\7\7To create a%s/%s version of Condor,\n", Arch, OpSys);
		printf("you MUST compile on a%s running %s\n", Arch, OpSys);
	} else {
		printf("\7You must customize CheckMachType.c (and all of Condor)\n");
		printf("\7to make a system of this architecture/os combination.\n");
	}

	exit( 1 );
}
