/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <rpc/types.h>
#include <rpc/xdr.h>
#include <netinet/in.h>
#include "expr.h"
#include "manager.h"

xdr_mach_rec( xdrs, ptr )
XDR			*xdrs;
MACH_REC	*ptr;
{
	if( !xdr_mywrapstring(xdrs,&ptr->name) ) {
		return FALSE;
	}


	if( !xdr_u_long(xdrs,&ptr->net_addr.s_addr) ) {
		return FALSE;
	}

	if( !xdr_short(xdrs,&ptr->net_addr_type) ) {
		return FALSE;
	}

	if( !xdr_context(xdrs,ptr->machine_context) ) {
		return FALSE;
	}
	if( !xdr_int(xdrs,&ptr->time_stamp) ) {
		return FALSE;
	}
	if( !xdr_int(xdrs,&ptr->prio) ) {
		return FALSE;
	}
	return TRUE;
}
