/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <stdio.h>
#include "condor_sys.h"
#include "debug.h"

int Syscalls = SYS_LOCAL | SYS_RECORDED;
int RunningAsCondor = 0;
int FakeRemoteCalls = 1;

#define SysLOC(m)	(((m) & SYS_LOCAL) ? "SYS_LOCAL" : "SYS_REMOTE")
#define SysREC(m)	(((m) & SYS_RECORDED) ? "SYS_RECORDED" : "SYS_UNRECORDED")

/*
**	Set Syscalls to the specified mode
**	and return the old mode.
*/
SetSyscalls( mode )
register int mode;
{
	register int scm;

#ifdef notdef
	static int	quiet = 0;

	if( Syscalls != mode && !quiet ) {
		quiet = 1;
		dprintf(D_CKPT, "SetSyscalls: Going from %s|%s to %s|%s\n",
					SysLOC(Syscalls), SysREC(Sys_Calls),
					SysLOC(mode), SysREC(mode) );
		quiet = 0;
	}
#endif notdef

	scm = Syscalls;
	Syscalls = mode;

	return( scm );
}

display_syscall_mode( line, file )
int		line;
char	*file;
{
	dprintf(D_ALWAYS, "At %d in %s, Syscall Mode =  %s|%s (0%o)\n",
				line, file, SysLOC(Syscalls), SysREC(Syscalls), Syscalls );
}
