/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 

#include <stdio.h>
#include <sys/types.h>
#include "condor_setjmp.h"
#include "except.h"
#include "debug.h"

static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */


#define MGIC	0
#define APTR	1
#define FPTR	2
#define PCTR	3

#define MAGIC	0xfeedface

#define FP_OFFSET	24

condor_setjmp( cenv )
u_long *cenv;
{
	struct frame *fp = (struct frame *) ((int) &cenv - FP_OFFSET);

	dprintf(D_CKPT, "setjmp: fp = 0x%x, &cenv = 0x%x, diff = %d\n",
			fp, &cenv, (int) fp - (int) &cenv );

	dprintf(D_CKPT, "setjmp: sp 0x%x, savap 0x%x, savfp 0x%x, savpc 0x%x\n",
		fp, fp->fr_savap, fp->fr_savfp, fp->fr_savpc );
	
	cenv[MGIC] = MAGIC;
	cenv[APTR] = fp->fr_savap;
	cenv[FPTR] = fp->fr_savfp;
	cenv[PCTR] = fp->fr_savpc;

	return( 0 );
}

condor_longjmp( cenv )
u_long *cenv;
{

	struct frame *fp = (struct frame *) ((int) &cenv - FP_OFFSET);

	if( cenv[MGIC] != MAGIC ) {
		EXCEPT("Condor long jump botch");
	}

	fp->fr_savap = cenv[APTR];
	fp->fr_savfp = cenv[FPTR];
	fp->fr_savpc = cenv[PCTR];

	return( 1 );
}
