/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Author:  Michael J. Litzkow,
** 	        University of Wisconsin, Computer Sciences Dept.
** 
*/ 

#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/file.h>
#ifdef AIX31
#include "syscall.aix.h"
#endif AIX31
#include "condor_sys.h"
#include "ckpt_file.h"
#include "debug.h"
#include "except.h"
static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */

extern char	Condor_CWD[];
extern int	AvoidNFS;
extern RESTREC    RestartInfo;
char    *internal_name(), *translate(), *gen_name(), *rindex();

int		Method;
char	*LocalName;

/*
**  See if we can translate the pathname to something we can access via
**  NFS.
*/
nfs_open( path, flags, mode )
char	*path;
int		flags, mode;
{
	int		fd;
	int		scm;

	dprintf( D_FULLDEBUG, "Entering nfs_open\n" );

	if( AvoidNFS ) {
		return -1;
	}

	if( LocalName = gen_name(path,flags) ) {
		dprintf( D_FULLDEBUG, "Calling syscall( %d, %s, 0%o, 0%o )\n",
											SYS_open, LocalName, flags, mode );
		fd = syscall( SYS_open, LocalName, flags, mode );
		dprintf( D_FULLDEBUG, "fd = %d\n", fd );
	} else {
		dprintf( D_FULLDEBUG, "gen_name returns NULL\n" );
		return -1;
	}

	return fd;
}

#ifdef AIX31
/*
**  See if we can translate the pathname to something we can access via
**  NFS.
*/
nfs_openx( path, flags, mode, ext )
char	*path;
int		flags, mode, ext;
{
	int		fd;
	int		scm;

	if( AvoidNFS ) {
		return -1;
	}

	if( LocalName = gen_name(path,flags) ) {
		fd = syscall( SYS_openx, LocalName, flags, mode, ext );
	} else {
		return -1;
	}

	return fd;
}
#endif AIX31

char *
gen_name( file, flags )
char	*file;
int		flags;
{
	static char	buf[ MAXPATHLEN + 1 ];
	char		dir[ MAXPATHLEN + 1];
	char		*ptr;
	char		*answer;

	dprintf( D_FULLDEBUG, "Entering gen_name\n" );
	
	if( answer = translate(file) ) {
		dprintf( D_FULLDEBUG, "translate(%s) returned \"%s\"\n",
			file, answer );
		return answer;
	}
	dprintf( D_FULLDEBUG, "translate(%s) returned NULL\n", file );

	if( !(flags & O_CREAT) ) {
		return NULL;
	}

	strcpy( dir, file );
	if( ptr = rindex(dir,'/') ) {
		if( ptr == dir ) {
			strcpy( dir, "/" );
			file += 1;
		} else {
			*ptr = '\0';
			file = ptr + 1;
		}
	} else {
		strcpy( dir, Condor_CWD );
	}

	dprintf( D_FULLDEBUG, "Directory part = \"%s\"\n", dir );
	dprintf( D_FULLDEBUG, "File part = \"%s\"\n", file );

	if( answer = translate(dir) ) {
		sprintf( buf, "%s/%s", dir, file );
		return buf;
	} else {
		return NULL;
	}
}

char	*
translate( name )
char	*name;
{
	char	remote_name[MAXPATHLEN + 1];
	char	*answer;
	int		scm;

	dprintf( D_FULLDEBUG, "Entering translate(%s)\n", name );

	if( extern_name(name,remote_name,sizeof(remote_name)) < 0 ) {
		return NULL;
	}
	dprintf( D_FULLDEBUG, "External name \"%s\"\n", remote_name );

	scm = SetSyscalls( SYS_LOCAL | SYS_RECORDED );
	answer = internal_name( remote_name );
	SetSyscalls( scm );

	if( answer ) {
		dprintf( D_FULLDEBUG, "Internal name \"%s\"\n", answer );
		return answer;
	} else {
		dprintf( D_FULLDEBUG, "Can't generate an internal name\n" );
		return NULL;
	}
}

extern int Syscalls;
debug_open( path, rval )
char	*path;
int		rval;
{
	register FINFO *fi = &RestartInfo.rr_file[ rval ];

	if( rval >= 0 ) {
		switch( Method ) {

		  case FI_NFS:
			if( LocalName ) {
				dprintf( D_ALWAYS,
					"Opened \"%s\" as \"%s\" via NFS as %d->%d\n",
					path, LocalName, rval, fi->fi_fdno
				);
			} else {
				if( (Syscalls & SYS_RECORDED) == 0 ) {
					dprintf( D_ALWAYS,
						"Opened \"%s\" via Local Sys Call as %d\n",
						path, rval );
				} else {
					dprintf( D_ALWAYS,
						"Opened \"%s\" via Local Sys Call as %d->%d\n",
						path, rval, fi->fi_fdno );
				}
			}
			break;

		  case FI_RSC:
			dprintf( D_ALWAYS,
				"Opened \"%s\" via Remote Sys Call as %d->%d\n",
				path, rval, fi->fi_fdno
			);
			break;

		  default:
			EXCEPT( "Unknown file access method (%d)", Method );
		}
	} else {
		dprintf( D_ALWAYS,"Failed to open \"%s\", errno = %d\n", path,errno);
	}
}
