/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 

#include <stdio.h>

#if defined(IRIX331)
#define __EXTENSIONS__
#include <signal.h>
#undef __EXTENSIONS__
#else
#include <signal.h>
#endif

#include <netdb.h>
#include <pwd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#include "sched.h"
#include "debug.h"
#include "trace.h"
#include "except.h"
#include "expr.h"
#include "clib.h"

static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */

extern char	ThisHost[];

int		FrgnJobsRunning;
int		StarterPid;

start_job( xdrs )
XDR		*xdrs;
{
	PORTS	ports;
	int		sock_1, sock_2;
	int		fd_1, fd_2;
	struct sockaddr_in	from;
	int		len = sizeof from;
	struct hostent	*hp, *gethostbyaddr();

	ports.port1 = create_port( &sock_1 );
	ports.port2 = create_port( &sock_2 );

		/* Send back the port numbers */
	xdrs->x_op = XDR_ENCODE;
	if( !xdr_ports(xdrs,&ports) ) {
		return -1;
	}
	if( !xdrrec_endofrecord(xdrs,TRUE) ) {
		return -1;
	}

	FrgnJobsRunning += 1;

		/* Wait for connection to port1 */
	len = sizeof from;
	bzero( (char *)&from, sizeof from );
	while( (fd_1=accept(sock_1,(struct sockaddr *)&from,&len)) < 0 ) {
		if( errno != EINTR ) {
			EXCEPT( "accept" );
		}
	}
	(void)close( sock_1 );

		/* Wait for connection to port2 */
	len = sizeof from;
	bzero( (char *)&from, sizeof from );
	while( (fd_2=accept(sock_2,(struct sockaddr *)&from,&len)) < 0 ) {
		if( errno != EINTR ) {
			EXCEPT( "accept" );
		}
	}
	(void)close( sock_2 );

		/* Now find out what host we're talking to */
	if( (hp=gethostbyaddr((char *)&from.sin_addr,sizeof(struct in_addr),
												from.sin_family)) == NULL ) {
		dprintf( D_ALWAYS, "Can't find host name\n" );
		return -1;
	}

	exec_starter( hp->h_name, fd_1, fd_2  );
	return 0;
}

create_port( sock )
int		*sock;
{
	struct sockaddr_in	sin;
	int		len = sizeof sin;

	bzero( (char *)&sin, sizeof sin );
	sin.sin_family = AF_INET;
	sin.sin_port = 0;

	if( (*sock=socket(AF_INET,SOCK_STREAM,0)) < 0 ) {
		EXCEPT( "socket" );
	}

	if( bind(*sock,(struct sockaddr *)&sin, sizeof sin) < 0 ) {
		EXCEPT( "bind" );
	}

	if( listen(*sock,1) < 0 ) {
		EXCEPT( "listen" );
	}

	if( getsockname(*sock,(struct sockaddr *)&sin, &len) < 0 ) {
		EXCEPT("getsockname");
	}

	return (int)ntohs( (u_short)sin.sin_port );
}


extern char	*Starter;
extern char	*Execute;

exec_starter( hostname, main_sock, err_sock  )
char	*hostname;
int		main_sock;
int		err_sock;
{
	int		i;
	int		pid;
	int		n_fds = getdtablesize();
	int		omask;

	/*
	omask = sigblock( sigmask(SIGTSTP) );
	*/
	omask = sigblock( -1 );
	if( (pid = fork()) < 0 ) {
		EXCEPT( "fork" );
	}

	if( pid ) {	/* The parent */
		(void)sigblock( omask );
		StarterPid = pid;
		(void)close( main_sock );
		(void)close( err_sock );

		dprintf( D_ALWAYS, "exec_starter( %s, %d, %d ): StarterPid = %d\n",
								hostname, main_sock, err_sock, StarterPid );
	} else {	/* the child */
		/* N.B. The child is born with TSTP blocked, so he can be sure to
		   set up his handler before accepting it. */
		/*
		**	This should not change process groups because the
		**	condor_master daemon may want to do a killpg at some point...
		**
		**	if( setpgrp(0,getpid()) ) {
		**		EXCEPT( "setpgrp(0, %d)", getpid() );
		**	}
		*/
		if( dup2(main_sock,0) < 0 ) {
			EXCEPT( "dup2(%d,%d)", main_sock, 0 );
		}
		if( dup2(main_sock,1) < 0 ) {
			EXCEPT( "dup2(%d,%d)", main_sock, 1  );
		}
		if( dup2(err_sock,2) < 0 ) {
			EXCEPT( "dup2(%d,%d)", err_sock, 2 );
		}
		for( i=3; i<n_fds; i++ ) {
			(void) close( i );
		}
#ifdef NFSFIX
		/*
		** Starter must be exec'd as root so it can change to client's
		** uid and gid.
		*/
		set_root_euid(__FILE__,__LINE__);
#endif NFSFIX
		(void)execl( Starter, "condor_starter", hostname, 0 );
#ifdef NFSFIX
		/* Must be condor to write to log files. */
		set_condor_euid(__FILE__,__LINE__);
#endif NFSFIX
		EXCEPT( "execl(%s, condor_starter, %s, 0)", Starter, hostname );
	}
}
