/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Rick Rasmussen and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/param.h>
#include <pwd.h>

#if defined(HPUX8)
#define _BSD
#endif
#include <sys/wait.h>

#include "sched.h"
#include "debug.h"
#include "except.h"
#include "expr.h"

#if defined(BSD43) || defined(DYNIX)
#define WEXITSTATUS(x) ((x).w_retcode)
#endif

char	*param();

static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */

char	*MyName;

char	Configoff[ MAXPATHLEN ];
char	Daemonsoff[ MAXPATHLEN ];
char	*Lib;

main( argc, argv )
int		argc;
char	*argv[];
{
	int child_pid;
	union wait status;

	MyName = argv[0];
	if( getuid() != 0 ) {
		dprintf( D_ALWAYS, "%s must be run as ROOT\n", MyName );
		exit( 1 );
	}

	config( MyName, (CONTEXT *)0 );
	init_params();

	if( (child_pid = fork()) < 0 ) {
		EXCEPT( "fork" );
	}

	if( child_pid == 0 ) {			/* the child */
		change_config_file();
	} else {						/* the parent */
		wait( &status );
		if( WIFEXITED(status) && WEXITSTATUS(status)==0 ) {
			stop_condor();
		} else {
			dprintf( D_ALWAYS, "Couldn't change Condor config file\n" );
			exit( 1 );
		}
	}
}

change_config_file()
{
	long exit_status;

		/* Must be condor to write to config file. */
	set_condor_ruid(__FILE__,__LINE__);

	if( (exit_status = system(Configoff)) == 127 ) {
		EXCEPT("Couldn't exec shell!!!");
	}
	exit( exit_status );
}

stop_condor()
{
	long exit_status;

	if( (exit_status = system(Daemonsoff)) == 127 ) {
		EXCEPT("Couldn't exec shell!!!");
	}
	exit( exit_status );
}

SetSyscalls(){}

init_params()
{
	if( (Lib = param("LIB")) == NULL ) {
		EXCEPT( "LIB not specified in config file" );
	}

	sprintf( Configoff, "/bin/csh %s/config_off", Lib );
	sprintf( Daemonsoff, "/bin/csh %s/daemons_off", Lib );
}
