/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <rpc/types.h>
#include <rpc/xdr.h>

#include "trace.h"
#include "except.h"
#include "xdr_lib.h"
#include "proc.h"
#include "debug.h"

#ifndef LINT
static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */
#endif LINT

/*
** XDR routine for a PROC.
*/
xdr_proc( xdrs, proc )
XDR		*xdrs;
PROC	*proc;
{
	/*
	if( xdrs->x_op == XDR_FREE ) {
		xdr_free_proc( proc );
		return TRUE;
	}
	*/

	if( !xdr_int(xdrs,&proc->version_num) )
		return FALSE;
	if( proc->version_num != PROC_VERSION ) {
		EXCEPT( "Incorrect PROC version number (%d)", proc->version_num );
	}
	if( !xdr_proc_id(xdrs,&proc->id) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->owner,256) )
		return FALSE;
	if( !xdr_int(xdrs,&proc->q_date) )
		return FALSE;
	if( !xdr_int(xdrs,&proc->completion_date) )
		return FALSE;
	if( !xdr_int(xdrs,&proc->status) )
		return FALSE;
	if( !xdr_int(xdrs,&proc->prio) )
		return FALSE;
	if( !xdr_int(xdrs,&proc->notification) )
		return FALSE;
	if( !xdr_int(xdrs,&proc->image_size) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->cmd,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->args,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->env,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->in,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->out,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->err,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->rootdir,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->iwd,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->requirements,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->preferences,MAXPATHLEN) )
		return FALSE;
	if( !xdr_rusage(xdrs,&proc->local_usage) )
		return FALSE;
	if( !xdr_rusage(xdrs,&proc->remote_usage) )
		return FALSE;
	return TRUE;
}

xdr_free_proc( proc )
PROC	*proc;
{
	XDR		xdrs;

	xdrs.x_op = XDR_FREE;
	xdr_proc( &xdrs, proc );
/*


	if( proc->owner ) {
		FREE( proc->owner );
		proc->owner = NULL;
	}

	if( proc->cmd ) {
		FREE( proc->cmd );
		proc->cmd = NULL;
	}

	if( proc->args ) {
		FREE( proc->args );
		proc->args = NULL;
	}

	if( proc->env ) {
		FREE( proc->env );
		proc->env = NULL;
	}

	if( proc->in ) {
		FREE( proc->in );
		proc->in = NULL;
	}

	if( proc->out ) {
		FREE( proc->out );
		proc->out = NULL;
	}

	if( proc->err ) {
		FREE( proc->err );
		proc->err = NULL;
	}

	if( proc->rootdir ) {
		FREE( proc->rootdir );
		proc->rootdir = NULL;
	}

	if( proc->iwd ) {
		FREE( proc->iwd );
		proc->iwd = NULL;
	}

	if( proc->requirements ) {
		FREE( proc->requirements );
		proc->requirements = NULL;
	}

	if( proc->preferences ) {
		FREE( proc->preferences );
		proc->preferences = NULL;
	}
*/
}

/*
** XDR routine for a PROC_ID.
*/
xdr_proc_id( xdrs, id )
XDR		*xdrs;
PROC_ID	*id;
{
	return xdr_int(xdrs,&id->cluster) && xdr_int(xdrs,&id->proc);
}

/*
** XDR routine for a PROC.
*/
xdr_old_proc( xdrs, proc )
XDR		*xdrs;
OLD_PROC	*proc;
{
	if( xdrs->x_op == XDR_FREE ) {
		xdr_old_free_proc( proc );
		return TRUE;
	}

	if( !xdr_proc_id(xdrs,&proc->id) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->owner,256) )
		return FALSE;
	if( !xdr_int(xdrs,&proc->q_date) )
		return FALSE;
	if( !xdr_int(xdrs,&proc->status) )
		return FALSE;
	if( !xdr_int(xdrs,&proc->prio) )
		return FALSE;
	if( !xdr_int(xdrs,&proc->notification) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->cmd,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->args,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->env,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->in,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->out,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->err,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->rootdir,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->iwd,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->requirements,MAXPATHLEN) )
		return FALSE;
	if( !xdr_string(xdrs,&proc->preferences,MAXPATHLEN) )
		return FALSE;
	if( !xdr_rusage(xdrs,&proc->local_usage) )
		return FALSE;
	if( !xdr_rusage(xdrs,&proc->remote_usage) )
		return FALSE;
	return TRUE;
}

xdr_old_free_proc( proc )
OLD_PROC	*proc;
{
	if( proc->owner ) {
		FREE( proc->owner );
		proc->owner = NULL;
	}

	if( proc->cmd ) {
		FREE( proc->cmd );
		proc->cmd = NULL;
	}

	if( proc->args ) {
		FREE( proc->args );
		proc->args = NULL;
	}

	if( proc->env ) {
		FREE( proc->env );
		proc->env = NULL;
	}

	if( proc->in ) {
		FREE( proc->in );
		proc->in = NULL;
	}

	if( proc->out ) {
		FREE( proc->out );
		proc->out = NULL;
	}

	if( proc->err ) {
		FREE( proc->err );
		proc->err = NULL;
	}

	if( proc->rootdir ) {
		FREE( proc->rootdir );
		proc->rootdir = NULL;
	}

	if( proc->iwd ) {
		FREE( proc->iwd );
		proc->iwd = NULL;
	}

	if( proc->requirements ) {
		FREE( proc->requirements );
		proc->requirements = NULL;
	}

	if( proc->preferences ) {
		FREE( proc->preferences );
		proc->preferences = NULL;
	}
}
