/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#include "debug.h"
#include "xdr_lib.h"

struct sockaddr_in	From;
int		Len;

XDR *
xdr_Init( sock, xdrs )
int		*sock;
XDR		*xdrs;
{
	int	XDR_Read(), XDR_Write();

	dprintf( D_XDR, "Calling xdrrec_create with sock = %d\n", *sock );
	xdrrec_create( xdrs, XDR_BLOCKSIZ, XDR_BLOCKSIZ, sock, XDR_Read, XDR_Write);
	xdrrec_skiprecord( xdrs );	/* flush input buffer */
	return xdrs;
}

XDR *
xdr_Udp_Init( sock, xdrs )
int		*sock;
XDR		*xdrs;
{
	int	XDR_Recvfrom(), XDR_Send();

	xdrrec_create( xdrs, UDP_BLOCKSIZ, UDP_BLOCKSIZ, sock,
													XDR_Recvfrom, XDR_Send);
	xdrrec_skiprecord( xdrs );	/* flush input buffer */
	return xdrs;
}

static
XDR_Send( iohandle, buf, len )
int		*iohandle;
char	*buf;
int	 	len;
{
	int cnt;

	dprintf(D_XDR, "XDR_Send: about to send(%d, 0x%x, %d, 0)\n",
			*iohandle, buf, len);

	cnt = send( *iohandle, buf, len, 0 );

	dprintf(D_XDR, "XDR_Send: cnt = %d\n", cnt);

	return( cnt );
}

static
XDR_Recvfrom( iohandle, buf, len )
int		*iohandle;
char	*buf;
u_int	len;
{
	int	status;
	int terrno = 0;
	extern errno;

	dprintf( D_XDR, "Calling XDR_Recvfrom, iohandle = %d\n", *iohandle );

	Len = sizeof( From );
	status = recvfrom(*iohandle,buf,(int)len,0,(struct sockaddr *)&From,&Len);
	if( status <= 0 ) {
		terrno = errno;
		status = -1;
	}
	dprintf( D_XDR, "XDR_Read read %d bytes\n", status );

	errno = terrno;

	return status;
}
