/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 

/********************************************************************
* Print a summary of each job that has been submitted to condor in the
* history of this machine.
********************************************************************/


#include <stdio.h>
#include <pwd.h>
#include <ctype.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "proc.h"
#include "expr.h"
#include "clib.h"

#define STAR	-1

char		*param();

char	*MyName;
PROC_ID	Filter[100];
int		N_Filters;

usage()
{
	fprintf( stderr, "Usage: %s [-f file_name]  [ cluster | cluster.proc ] ...\n", MyName );
	exit( 1 );
}

/* ARGSUSED */
main( argc, argv)
int		argc;
char	*argv[];
{
	char	*arg;
	char	*file_name = NULL;

	for( MyName = *argv++; arg = *argv; argv++ ) {
		if( isdigit(arg[0]) ) {
			add_to_filter( arg );
		} else {
			if( strcmp("-f",arg) == 0 ) {
				file_name = *(++argv);
			} else {
				usage();
			}
		}
	}

	config( MyName, (CONTEXT *)0 );

	if( !file_name ) {
		file_name = param( "HISTORY" );
	}

	if( file_name == NULL ) {
		fprintf( stderr, "Don't know where to find history file\n" );
		fprintf( stderr, "No specified in config file...\n" );
		exit( 1 );
	}
	do_it( file_name );
	exit( 0 );
}

display( proc )
PROC	*proc;
{
	if( filter(&proc->id) )
		return;
	display_proc_long( proc );
}

do_it( name )
char	*name;
{
	int		fd;
	XDR		xdr, *H = &xdr, *OpenHistory();
	int		display();

	H = OpenHistory( name, H, &fd );
	(void)LockHistory( H, READER );
	ScanHistory( H, display );
	CloseHistory( H );
}


add_to_filter( arg )
char	*arg;
{
	char	*p, *index();
	int		cluster, proc;

	if( p=index(arg,'.') ) {
		cluster = atoi( arg );
		proc = atoi( ++p );
	} else {
		cluster = atoi( arg );
		proc = STAR;
	}

	if( cluster < 1 || proc < STAR )
		usage();

	Filter[N_Filters].cluster = cluster;
	Filter[N_Filters].proc = proc;
	N_Filters += 1;
}

/*
** Return true if this PROC_ID should be filtered from the output (not
** printed). Otherwise return false.
*/
filter( pid )
PROC_ID		*pid;
{
	int		i;

	if( N_Filters == 0 )
		return FALSE;

	for( i=0; i<N_Filters; i++ ) {
		if( pid->cluster == Filter[i].cluster &&
					(pid->proc == Filter[i].proc || Filter[i].proc == STAR) )
			return FALSE;
	}
	return TRUE;
}


SetSyscalls( foo )
int		foo;
{
	return foo;
}
