/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <netinet/in.h>

#include "condor_setjmp.h"
#include "condor_sys.h"
#include "trace.h"
#include "ckpt.h"
#include "machdep.h"
#include "except.h"
#include "debug.h"

static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */

#define DEBUG

#define STACKSIZ	(32*1024)

char	 TmpStack[ STACKSIZ ];

char	 Condor_CWD[ MAXPATHLEN ];
char	 CkptName[ MAXPATHLEN ];
extern int	RunningAsCondor;

RESTREC	 RestartInfo;

#ifdef VOID_SIGNAL_RETURN
#define sighandler_t void
#else
#define sighandler_t int
#endif

sighandler_t CKPT();
sighandler_t KILL();


int CkptInProgress;
int SyscallInProgress;
int CkptWanted;
int KillWanted;

int	StackSize;

extern condor_jmp_buf LongJumpBuf;

struct sigvec	SigVec, oUSR2Vec;
struct sigstack	SigStack, oSigStack;
int				SigMask;


restart()
{

	sighandler_t restart2();

	/*
	dprintf( D_ALWAYS, "Entering restart()\n" );
	DumpOpenFds();
	*/

	(void) SetSyscalls( SYS_LOCAL | SYS_UNRECORDED, __LINE__, __FILE__ );

	ReadStackSize();

#ifdef IBM032	/* Will get done in ReadStack() on other machines */
	grow_stack( StackSize );
#endif IBM032

	SigStack.ss_sp = &TmpStack[ STACKSIZ ];
	SigStack.ss_onstack = 0;

	SigVec.sv_handler = restart2;
	SigVec.sv_mask    = 0;
	SigVec.sv_onstack = 1;

	if( sigstack(&SigStack, &oSigStack) < 0 ) {
		EXCEPT("sigstack(&SigStack [0x%x], &oSigStack [0x%x), errno = %d",
			&SigStack, &oSigStack, errno);
	}

	if( sigvec(SIGUSR2, &SigVec, &oUSR2Vec) < 0 ) {
		EXCEPT("sigvec(SIGUSR2, restart2), errno = %d", errno );
	}

	dprintf(D_CKPT, "restart: about to kill SIGUSR2\n");

	kill( getpid(), SIGUSR2 );
	sigpause( 0 );
}

sighandler_t
restart2()
{
	dprintf(D_CKPT,
		"restart2: CkptWanted %d,CkptInProgress %d, SyscallInProgress %d\n",
			CkptWanted, CkptInProgress, SyscallInProgress);

	/*
	**	Open the checkpoint file to extract any information
	**	that we need (eg. the saved stack).
	*/
	ReadRestartInfo();

	/*
	**	Reopen and reposition all active files.  The open file table
	**	does not need to be read from the checkpoint file because it
	**	resides in memory.  The checkpoint version is there for
	**	initialization and for other programs to examine.
	*/
	if( RunningAsCondor ) {
		(void) SetSyscalls( SYS_REMOTE | SYS_UNRECORDED, __LINE__, __FILE__ );
	} else {
		(void) SetSyscalls( SYS_LOCAL | SYS_UNRECORDED, __LINE__, __FILE__ );
	}

	ReopenFiles();

	/*
	**	Change to the previous current working directory
	*/
	if( chdir(Condor_CWD) < 0 ) {
		EXCEPT(Condor_CWD);
	}

	SigVec.sv_handler = CKPT;
	SigVec.sv_mask    = 0;
	SigVec.sv_onstack = 0;

	(void) SetSyscalls( SYS_LOCAL | SYS_RECORDED, __LINE__, __FILE__ );

	if( sigvec(SIGTSTP, &SigVec, (struct sigvec *) 0) < 0 ) {
		EXCEPT("sigvec(SIGTSTP, CKPT), errno = %d", errno );
	}

	if( sigvec(SIGUSR2, &oUSR2Vec, (struct sigvec *) 0) < 0 ) {
		EXCEPT("sigvec(SIGUSR2, &oUSR2Vec [0x%x]), errno = %d",
			&oUSR2Vec, errno );
	}

	if( sigstack(&oSigStack, (struct sigstack *) 0) < 0 ) {
		EXCEPT("sigstack(&oSigStack [0x%x], 0), errno = %d",
			&oSigStack, errno );
	}

	SigVec.sv_handler = KILL;
	if( sigvec(SIGUSR1, &SigVec, (struct sigvec *) 0) < 0 ) {
		EXCEPT("sigvec(SIGUSR1, KILL), errno = %d", errno );
	}

	sigsetmask( 0 );

	dprintf(D_CKPT, "restart2: about to condor_longjmp( 0x%x)\n", LongJumpBuf);
	CkptInProgress = 0;
	condor_longjmp( LongJumpBuf );
	EXCEPT("restart2: what happened to condor_longjmp????");
}



ReadRestartInfo()
{
	register int fd;
	int scm;	/* System call mode (local or remote */

	/*
	scm = SetSyscalls( SYS_LOCAL | SYS_UNRECORDED, __LINE__, __FILE__ );
	*/

	fd = open(CkptName, O_RDONLY, 0);
	if( fd < 0 ) {
		EXCEPT( "Could not open '%s', errno = %d",
				CkptName, errno );
	}
	dprintf( D_CKPT, "Opened checkpoint file \"%s\"\n", CkptName );

	ReadStack( fd );

	close( fd );

	/*
	(void) SetSyscalls( scm, __LINE__, __FILE__ );
	*/
}


ReadStack( fd )
register int fd;
{
	register char *TStack = (char *) USRSTACK;
	int		i = STACKGROW;


	if( lseek(fd, -(StackSize+sizeof(StackSize)), L_XTND) < 0 ) {
		EXCEPT( "lseek(%d,%d,L_XTND)", fd, -(StackSize+sizeof(StackSize)) );
		goto error;
	}

	TStack -= StackSize;	/* Set TStack pointing at the base of the stack  */

	dprintf(D_CKPT, "ReadStack: USRSTACK = 0x%x, TStack = 0x%x\n",
			USRSTACK, TStack );

	/*
	**	The kernel (probably) won't grow the user stack in the middle
	**	of a system call, so lets grow it now...
	**	Make sure to account for any extra stack the system may give us...
	*/
	*(int *) (TStack+STACKGROW) = 0;

	dprintf(D_CKPT, "ReadStack: Just set *(TStack 0x%x + STACKGROW 0x%x)\n",
					TStack, STACKGROW);

	dprintf(D_CKPT, "ReadStack: About to read(%d, 0x%x, %d)\n",
					fd, TStack, StackSize);

	if( read(fd, TStack, StackSize) != StackSize ) {
		goto error;
	}

	dprintf(D_CKPT, "ReadStack: Just read %d bytes of stack\n", StackSize);

	return;

error:
	EXCEPT("Could not read Checkpoint Stack, errno = %d",
				errno );
}
