/*
**	Imake rules for building "man pages".  For each man page
**	<name>.<section> targets generated are:
**		<name>.xpr		: create man page suitable for an X display
**		<name>.proof	: display on an X display
**		<name>.cat		: create cat'able version
**		<name>.view		: view cat'able version with "less"
**		<name>.PS		: create postscript version
**		<name>.print	: send postscript version to the printer
**
**	A "print" target is also generated which will format and print all of
**	the man pages for the section.
*/

#if IS_R6000_AIX31
#define TO_PROOF(name) troff -TX75 -man name.$(SECTION) > name.xpr
#define SHOW_PROOF(name) xpreview name.xpr
#else
#define TO_PROOF(name) ditroff -t -man name.$(SECTION) > name.xpr
#define SHOW_PROOF(name) xproof name.xpr
#endif

#define TO_CAT(name) nroff -man name.$(SECTION)  > name.cat
#define SHOW_CAT(name) less name.cat

#define TO_POSTSCRIPT(name) ditroff -man -ps name.$(SECTION) > name.PS
#define LPR(name) lpr -P$(PRINTER) name.PS

#define MAKE_PROOF(name)						\
name.xpr: name.$(SECTION) 						@@\
	TO_PROOF(name)								@@\
clean::											@@\
	/bin/rm -f name.xpr							@@

#define PROOF(name)								\
name.proof: name.xpr							@@\
	SHOW_PROOF(name)							@@

#define MAKE_CAT(name)							\
name.cat: name.$(SECTION) 						@@\
	TO_CAT(name)								@@\
	cp name.cat $(CAT_DIR)/name.$(SECTION)		@@\
release:: name.cat								@@\
clean::											@@\
	/bin/rm -f name.cat							@@

#define CAT(name)								\
name.view: name.cat								@@\
	SHOW_CAT(name)								@@

#define MAKE_PRINT(name)						\
name.PS: name.$(SECTION) 						@@\
	TO_POSTSCRIPT(name)							@@\
	cp name.PS $(PS_DIR)/name.$(SECTION)		@@\
release:: name.PS								@@\
clean::											@@\
	/bin/rm -f name.PS							@@

#define PRINT(name)								\
name.print: name.PS								@@\
	LPR(name)									@@\
print:: name.print								@@


#define MAN_PAGE(name)							\
	MAKE_PROOF(name)							@@\
	PROOF(name)									@@\
	MAKE_CAT(name)								@@\
	CAT(name)									@@\
	MAKE_PRINT(name)							@@\
	PRINT(name)									@@

release::
