#include <stdio.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include "debug.h"
#include "except.h"

#ifndef LINT
static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */
#endif LINT

detach()
{
	int		fd;

	(void)close( 0 );
	(void)close( 1 );
	(void)close( 2 );

	if( (fd=open("/dev/tty",O_RDWR,0)) < 0 ) {
		dprintf( D_ALWAYS, "Can't open /dev/tty\n" );
		return;
	}

	if( ioctl(fd,TIOCNOTTY,(char *)0) < 0 ) {
		EXCEPT( "ioctl(%d,TIOCNOTTY,(char *)0)", fd );
	}

	(void)close( fd );
}
