/* 
** Copyright 1986, 1987, 1988, 1989 University of Wisconsin
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of the University of
** Wisconsin not be used in advertising or publicity pertaining to
** distribution of the software without specific, written prior
** permission.  The University of Wisconsin makes no representations about
** the suitability of this software for any purpose.  It is provided "as
** is" without express or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN DISCLAIMS ALL WARRANTIES WITH REGARD TO
** THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF WISCONSIN  BE LIABLE FOR
** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
** ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
** OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <sys/types.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/resource.h>

#include "ckpt_file.h"

PreOpen( fdno )
int fdno;
{
	register FINFO *fi = &RestartInfo.rr_file[ fdno ];

	fi->fi_flags = (FI_OPEN | FI_PREOPEN);
	fi->fi_priv  = 0;
	fi->fi_pos   = 0;
	fi->fi_fdno  = fdno;
	fi->fi_path  = "Pre-Opened";
}

MarkFileOpen( fd, path, flags )
int fd;
char *path;
int flags;
{
	register FINFO *fi = &RestartInfo.rr_file[fd];
	char fullpath[ MAXPATHLEN ];
	char *strdup();

	fi->fi_flags = FI_OPEN;
	fi->fi_priv  = flags & (O_RDONLY|O_WRONLY|O_RDWR);
	fi->fi_fdno  = fd;

	if( *path == '/' ) {
		fi->fi_path = strdup( path );
	} else {
		sprintf(fullpath, "%s/%s", CWD, path);
		fi->fi_path = strdup( fullpath );
	}
}

MarkFileClosed( fd )
int fd;
{
	register FINFO *fi = &RestartInfo.rr_file[fd];
	register FINFO *dupfi;
	register isduped;

	if( (fi->fi_flags & FI_DUP) == FI_DUP ) {
		fi->fi_flags = 0;
		fi->fi_path  = (char *) 0;
		return;
	}

	isduped = 0;

	for( dupfi = &RestartInfo.rr_file[0];
				dupfi < &RestartInfo.rr_file[NOFILE]; dupfi++ ) {
		/*
		**	If this is a dup and it is dup'd to this fd,
		**	make this one the non-dup'd file descriptor
		*/
		if( ((dupfi->fi_flags & FI_DUP) == FI_DUP) && (dupfi->fi_fdno == fd) ) {
			dupfi->fi_flags &= ~FI_DUP;
			dupfi->fi_priv = fi->fi_priv;
			dupfi->fi_fdno = dupfi - &RestartInfo.rr_file[0];
			dupfi->fi_path = fi->fi_path;

			isduped = 1;
			break;
		}
	}

	if( isduped == 0 ) {
		if( (fi->fi_flags & FI_PREOPEN) != FI_PREOPEN ) {
			free( fi->fi_path );
		}

		fi->fi_flags = 0;
		return;
	}

	fi->fi_flags = 0;

	/*
	**	Make all other dups of the same fd point to the 
	**	new file descriptor.
	*/
	for( fi = dupfi+1; fi < &RestartInfo.rr_file[NOFILE]; fi++ ) {
		if( ((fi->fi_flags & FI_DUP) == FI_DUP) && (fi->fi_fdno == fd) ) {
			fi->fi_fdno = dupfi->fi_fdno;
		}
	}
}

MarkFileDup( fd, dupfd )
int fd, dupfd;
{
	register FINFO *fi = &RestartInfo.rr_file[fd];
	register FINFO *dupfi = &RestartInfo.rr_file[dupfd];

	dupfi->fi_flags = FI_OPEN | FI_DUP;
	dupfi->fi_fdno  = fi->fi_fdno;
}

DumpOpenFds()
{
	register FINFO *fi;

	for( fi = &RestartInfo.rr_file[0];
				fi < &RestartInfo.rr_file[NOFILE]; fi++ ) {
		if( (fi->fi_flags & FI_OPEN) == FI_OPEN ) {
			if( (fi->fi_flags & FI_DUP) == FI_DUP ) {
				printf( "FD %d is a dup of %d\n",
					fi - &RestartInfo.rr_file[0], fi->fi_fdno );
			} else if( (fi->fi_flags & FI_PREOPEN) == FI_PREOPEN ) {
				printf( "FD %d was pre-opened\n", fi->fi_fdno);
			} else {
				printf( "FD %d is for '%s' flags %d\n",
					fi->fi_fdno, fi->fi_path, fi->fi_priv);
			}
		}
	}
}
