/* 
** Copyright 1986, 1987, 1988, 1989 University of Wisconsin
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of the University of
** Wisconsin not be used in advertising or publicity pertaining to
** distribution of the software without specific, written prior
** permission.  The University of Wisconsin makes no representations about
** the suitability of this software for any purpose.  It is provided "as
** is" without express or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN DISCLAIMS ALL WARRANTIES WITH REGARD TO
** THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF WISCONSIN  BE LIABLE FOR
** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
** ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
** OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 



#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/resource.h>

#include "condor_sys.h"
#include "ckpt_file.h"
#include "trace.h"
#include "except.h"
#include "fileno.h"
#include "debug.h"

static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */

extern char	CkptName[];
struct sigvec Sigvec;
struct sigvec OSigvec;

static int HasRun = 0;

/*
**	Checkpoint Main routine
*/
MAIN( argc, argv, envp )
int	 argc;
char **argv;
char **envp;
{
	register int i;
	extern int (*_EXCEPT_Cleanup)(), abort();
#ifdef MIPS
	void CKPT();
#else MIPS
	int CKPT();
#endif MIPS

	if( HasRun ) {
		restart();
	}
	HasRun = 1;

	/*
	**	Initial system calls should be local and unrecorded
	*/
	(void) SetSyscalls( SYS_LOCAL | SYS_UNRECORDED );

	Sigvec.sv_handler = CKPT;
	Sigvec.sv_mask = 0;
	Sigvec.sv_onstack = 0;

	i = sigvec( SIGTSTP, &Sigvec, (struct sigvec *) &OSigvec );
	if( i < 0 ) {
		EXCEPT("sigvec(SIGTSTP, 0x%x, 0)", &Sigvec);
	}

	/*
	**	Unblock any blocked signals (SIGTSTP in particular)
	*/
	sigsetmask(0);

	/*
	**	Further system calls will be remote and recorded...
	*/
#ifdef CONDOR
	RSC_Init( RSC_SOCK, CLIENT_LOG );
	dprintf_init( CLIENT_LOG );
	DebugFlags |= D_NOHEADER;
	(void) SetSyscalls( SYS_REMOTE | SYS_RECORDED );
#else CONDOR
	(void) SetSyscalls( SYS_LOCAL | SYS_RECORDED );
#endif CONDOR

#ifdef DEBUG
	DebugFlags = -1;
#endif DEBUG

	(void) strcpy( CkptName, *argv );

	/*
	**	chdir has the side effect of setting the variable CWD
	*/
	if( chdir(".") < 0 ) {
		EXCEPT("Initialize CWD");
	}

	/*
	**	Initialize table of open files
	*/
	for( i = 0; i < NOFILE; i++ ) {
		RestartInfo.rr_file[i].fi_flags = 0;	/* Not open */
	}

	/*
	**	Stdin, stdout, and stderr have been opened before
	**	ckpt_main is called, so don't open them upon restart.
	*/
	PreOpen( fileno(stdin) );
	PreOpen( fileno(stdout) );
	PreOpen( fileno(stderr) );

	_EXCEPT_Cleanup = abort;

	return( main(argc, argv, envp) );
}
