/* 
** Copyright 1986, 1987, 1988, 1989 University of Wisconsin
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of the University of
** Wisconsin not be used in advertising or publicity pertaining to
** distribution of the software without specific, written prior
** permission.  The University of Wisconsin makes no representations about
** the suitability of this software for any purpose.  It is provided "as
** is" without express or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN DISCLAIMS ALL WARRANTIES WITH REGARD TO
** THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF WISCONSIN  BE LIABLE FOR
** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
** ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
** OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include "expr.h"
#include "manager.h"
#include "except.h"

#ifndef LINT
static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */
#endif LINT

char	*index();


display_status_line( line )
STATUS_LINE	*line;
{
	char	*shorten();
	char	*ptr;

	
	if( ptr=index(line->name,'.') ) {
		*ptr = '\0';
	}
	printf( "%-14s ", line->name );
	printf( "%3d ", line->run );
	printf( "%4d ", line->tot);

	if( line->prio < -9999 ) {
		line->prio = -9999;
	} else if( line->prio > 9999 ) {
		line->prio = 9999;
	}
	printf( "%5d ", line->prio );

	printf( "%-6.6s ", shorten(line->state) );
	printf( "%-6.2f ", line->load_avg );

	if( line->kbd_idle > 9999 ) {
		line->kbd_idle = 9999;
	}
	printf( "%4d ", line->kbd_idle );
	printf( "%-7.7s ", line->arch );
	printf( "%-8.8s ", line->op_sys );

	printf( "\n" );
}

char *
shorten( state )
char	*state;
{
	if( stricmp(state,"Running") == 0 ) {
		return "Run";
	}
	if( stricmp(state,"Suspended") == 0 ) {
		return "Susp";
	}
	if( stricmp(state,"Killed") == 0 ) {
		return "Kill";
	}
	if( stricmp(state,"Checkpointing") == 0 ) {
		return "Ckpt";
	}
	if( stricmp(state,"NoJob") == 0 ) {
		return "NoJob";
	}
	if( stricmp(state,"(Down)") == 0 ) {
		return "Down";
	}
	return "(???)";
}

free_status_line( line )
STATUS_LINE	*line;
{
	if( line->name ) {
		free( line->name );
	}

	if( line->state ) {
		free( line->state );
	}

	if( line->arch ) {
		free( line->arch );
	}

	if( line->op_sys ) {
		free( line->op_sys );
	}

	free( (char *)line );
}

print_header()
{

	printf( "%-14s ", "Name" );
	printf( "%-3s ", "Run" );
	printf( "%4.4s ", "Tot" );
	printf( "%5s ", "Prio" );
	printf( "%-6s ", "State" );
	printf( "%-6s ", "LdAvg" );
	printf( "%-4s ", "Idle" );
	printf( "%-7s ", "Arch" );
	printf( "%-8s ", "OpSys" );
	printf( "\n" );
}
