/* 
** Copyright 1986, 1987, 1988, 1989 University of Wisconsin
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of the University of
** Wisconsin not be used in advertising or publicity pertaining to
** distribution of the software without specific, written prior
** permission.  The University of Wisconsin makes no representations about
** the suitability of this software for any purpose.  It is provided "as
** is" without express or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN DISCLAIMS ALL WARRANTIES WITH REGARD TO
** THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF WISCONSIN  BE LIABLE FOR
** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
** ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
** OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 
#include <stdio.h>
#include <sys/signal.h>
#include <sys/types.h>
#include <sys/param.h>

#include <sys/file.h>
#include <netinet/in.h>

#if defined(ultrix) || defined(ibm032)
#include <sys/dir.h>
#endif defined(ultrix) || defined(ibm032)

#include <sys/user.h>

#if defined(sun)
#include <sys/core.h>

static struct core C;
#if defined(SUNOS40)
int StackOffset;
#endif defined(SUNOS40)
#endif defined(sun)

#include "condor_sys.h"
#include "trace.h"
#include "ckpt.h"
#include "machdep.h"
#include "except.h"
#include "debug.h"
#include "clib.h"

static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */

main( argc, argv )
int argc;
char **argv;
{
	CKPTMAP cm;
	int fd;

	printf("sizeof(CKPTMAP) = %d\n", sizeof(CKPTMAP));

	if( argc < 2 ) {
		fprintf(stderr, "Usage: %s ckptfile [...]\n", *argv );
		exit( 1 );
	}

	while( *++argv ) {
		fd = open( *argv, O_RDONLY, 0 );
		if( fd < 0 ) {
			perror(*argv);
			continue;
		}

		if( readsegmap( fd, &cm ) >= 0 ) {
			dumpsegmap( &cm, *argv );
		}

		(void) close( fd );
	}
}

#define TO_HOST_ORDER(i) (int) ntohl( (u_long)i ) 

readsegmap( fd, cmp )
int fd;
register CKPTMAP *cmp;
{
	int i;

	if( lseek(fd, -sizeof(CKPTMAP), L_XTND) < 0 ) {
		perror("lseek(fd, -sizeof(CKPTMAP), L_XTND)");
		return( -1 );
	}

	if( read(fd, (char *) cmp, sizeof(CKPTMAP)) != sizeof(CKPTMAP) ) {
		perror("read cmp");
		return( -1 );
	}

	for( i = 0; i < NCKPTSEGS; i++ ) {
		cmp->cm_segs[i].cs_pos = TO_HOST_ORDER(cmp->cm_segs[i].cs_pos);
		cmp->cm_segs[i].cs_len = TO_HOST_ORDER(cmp->cm_segs[i].cs_len);
	}
}

static char *segnames[] = {
	"TEXT:   ",
	"DATA:   ",
	"T_RELOC:",
	"D_RELOC:",
	"SYMS:   ",
	"STRTAB: ",
	"STACK:  ",
	"JOB:    ",
	"SEGMAP: "
};

static
dumpsegmap( segmap, name )
CKPTMAP *segmap;
char *name;
{
	int i;

	printf("\t\t%s\n", name);

	for( i = 0; i < NCKPTSEGS; i++ ) {
		dumpseg( &segmap->cm_segs[i], segnames[i] );
	}
}

static
dumpseg( seg, name )
CKPTSEG *seg;
char *name;
{
	printf("Segment %s fd %2d, pos %6d (0x%x),\n",
				name, seg->cs_fd, seg->cs_pos, seg->cs_pos);
	printf("                        len %6d (0x%x)\n",
				seg->cs_len, seg->cs_len );
}
