/* 
** Copyright 1986, 1987, 1988, 1989 University of Wisconsin
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of the University of
** Wisconsin not be used in advertising or publicity pertaining to
** distribution of the software without specific, written prior
** permission.  The University of Wisconsin makes no representations about
** the suitability of this software for any purpose.  It is provided "as
** is" without express or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN DISCLAIMS ALL WARRANTIES WITH REGARD TO
** THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF WISCONSIN  BE LIABLE FOR
** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
** ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
** OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <stdio.h>

#define QSIZE 10
#define NOT_FOUND -1
char	Queue[ QSIZE ];
int		First, Last;


main( argc, argv )
int		argc;
char	*argv[];
{
	int		offset, i;
	int		loc = NOT_FOUND;
	char	*string;
	char	ch;

	if( argc != 2 ) {
		fprintf( stderr, "Usage: %s string\n", argv[0] );
		exit( 1 );
	}
	string = argv[1];

	for( i=0; i<strlen(string); i++ ) {
		if( fread(&ch,sizeof(ch),1,stdin) <= 0 ) {
			/*
			** fprintf( stderr, "\"%s\" not found\n", string );
			*/
			exit( 1 );
		}
		init_char( ch );
	}

	for( offset = 0; fread(&ch,sizeof(ch),1,stdin) > 0; offset++ ) {
		if( match(string) ) {
			if( loc == NOT_FOUND ) {
				loc = offset;
			} else {
				/*
				** fprintf( stderr, "Multiple occurances of \"%s\"\n", string );
				*/
				exit( 1 );
			}
		}
		add_char( ch );
	}

	if( loc == NOT_FOUND ) {
		/*
		** fprintf( stderr, "\"%s\" not found\n", string );
		*/
		exit( 1 );
	} else {
		printf( "%d\n", loc );
		exit( 0 );
	}
}

init_char( ch )
char	ch;
{
	Queue[Last] = ch;
	Last = (Last + 1) % QSIZE;
}

add_char( ch )
char	ch;
{
	Queue[Last] = ch;
	Last = (Last + 1) % QSIZE;
	First = (First + 1) % QSIZE;
}

match( string )
char	*string;
{
	int		idx;
	int		i;

	/*
	** show_buf();
	*/
	if( Queue[ (First - 1) % QSIZE ] == '_' ) {
		return 0;
	}

	for( i=0,idx=First; string[i]; i++, idx = (idx + 1) % QSIZE ) {
		if( string[i] != Queue[idx] ) {
			return 0;
		}
	}
	return 1;
}

show_buf()
{
	static char answer[1024];
	int		i, idx;

	for( i=0,idx=First; idx != Last; i++, idx = (idx+1) % QSIZE ) {
		if( Queue[idx] >= 040 && Queue[idx] <= 0176 ) {
			printf( "%c ", Queue[idx] );
		} else {
			printf( "<%o> ", Queue[idx] );
		}
	}
	printf( "\n" );
}
