/* 
** Copyright 1986, 1987, 1988, 1989 University of Wisconsin
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of the University of
** Wisconsin not be used in advertising or publicity pertaining to
** distribution of the software without specific, written prior
** permission.  The University of Wisconsin makes no representations about
** the suitability of this software for any purpose.  It is provided "as
** is" without express or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN DISCLAIMS ALL WARRANTIES WITH REGARD TO
** THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF WISCONSIN  BE LIABLE FOR
** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
** ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
** OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <stdio.h>
#include <pwd.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "proc.h"
#include "expr.h"
#include "clib.h"

char		*param(), *format_time(), *strdup();

char	*MyName;
int		Long;

typedef struct {
	char	*name;
	int		n_jobs;
	float	local_cpu;
	float	remote_cpu;
} USER_REC;

USER_REC	*RecList[1024];
int			N_Recs;

int		TotalJobs;
float	TotalRemoteCpu, TotalLocalCpu;

usage()
{
	fprintf( stderr, "Usage: %s [-l]\n", MyName );
	exit( 1 );
}

/* ARGSUSED */
main( argc, argv)
int		argc;
char	*argv[];
{
	char	*arg;
	char	*tmp;

	for( MyName = *argv++; arg = *argv; argv++ ) {
		if( arg[0] == '-' ) {
			if( arg[1] == 'l' ) {
				Long++;
			} else {
				usage();
			}
		} else {
			break;
		}
	}

	config( MyName, (CONTEXT *)0 );

	if( *argv ) {
		while( *argv ) {
			do_it( *argv++ );
		}
	} else {
		tmp = param( "HISTORY" );
		if( tmp == NULL ) {
			fprintf( stderr, "Don't know where to find history file\n" );
			fprintf( stderr, "No specified in config file...\n" );
			exit( 1 );
		}
		do_it( tmp );
	}
	if( !Long ) {
		display_list();
	}
	exit( 0 );
}

do_it( name )
char	*name;
{
	int		fd;
	XDR		xdr, *H = &xdr, *OpenHistory();
	int		update_list(), display_proc_long();

	H = OpenHistory( name, H, &fd );
	(void)LockHistory( H, READER );
	if( Long ) {
		ScanHistory( H, display_proc_long );
	} else {
		ScanHistory( H, update_list );
	}
	CloseHistory( H );
}

update_list( proc )
PROC	*proc;
{
	USER_REC	*rec, *find_user_rec(), *create_user_rec();

	if( proc->status != 4 ) {
		return;
	}

	if( (rec=find_user_rec(proc->owner)) == NULL ) {
		rec = create_user_rec( proc->owner );
	}

	rec->n_jobs += 1;

	rec->remote_cpu += proc->remote_usage.ru_utime.tv_sec;
	rec->remote_cpu += proc->remote_usage.ru_stime.tv_sec;

	rec->local_cpu += proc->local_usage.ru_utime.tv_sec;
	rec->local_cpu += proc->local_usage.ru_stime.tv_sec;

	TotalRemoteCpu += proc->remote_usage.ru_utime.tv_sec;
	TotalRemoteCpu += proc->remote_usage.ru_stime.tv_sec;

	TotalLocalCpu += proc->local_usage.ru_utime.tv_sec;
	TotalLocalCpu += proc->local_usage.ru_stime.tv_sec;

	TotalJobs += 1;
}

USER_REC *
find_user_rec( name )
char	*name;
{
	int		i;

	for( i=0; i<N_Recs; i++ ) {
		if( strcmp(RecList[i]->name,name) == 0 ) {
			return RecList[i];
		}
	}
	return NULL;
}

USER_REC *
create_user_rec( name )
char	*name;
{
	USER_REC	*rec;

	rec = (USER_REC *)calloc( 1, sizeof(USER_REC) );
	rec->name = strdup( name );
	rec->local_cpu = 0;
	rec->remote_cpu = 0;

	RecList[ N_Recs++ ] = rec;
	return rec;
}

SetSyscalls( foo )
int		foo;
{
	return foo;
}

display_list()
{
	int			i;
	USER_REC	*rec;

	printf( "%8.8s %6.6s %14.14s %14.14s   %12.12s\n",
		"Name", "Jobs", "Local Cpu", "Remote Cpu", "Leverage" );

	for( i=0; i<N_Recs; i++ ) {
		rec = RecList[i];
		print_rec( rec->name, rec->n_jobs, rec->local_cpu, rec->remote_cpu );
	}
	print_rec( "TOTAL", TotalJobs, TotalLocalCpu, TotalRemoteCpu );
}

print_rec( name, n_jobs, local, remote )
char	*name;
int		n_jobs;
float	local;
float	remote;
{

	printf( "%8.8s %6d ", name, n_jobs );
	printf( "%14s ", format_time(local) );
	printf( "%14s   ", format_time(remote) );
	if( local < 1.0 ) {
		printf( "%12.12s\n", "(undefined)" );
	} else {
		printf( "%12.1f\n", remote / local );
	}
}
