#include <a.out.h>

main( argc, argv )
int argc;
char **argv;
{
    while( *++argv ) {
        analyze( *argv );
    }
}

analyze( name )
char *name;
{
	struct exec	exec;

	int fd = open( name, 0, 0 );

    if( fd < 0 ) {
        perror( name );
        exit( 1 );;
    }

	if( read(fd,(char *)&exec,sizeof(exec)) != sizeof(exec) ) {
		perror( "read" );
		exit( 1 );
	}

	printf( "%s:\n", name );
	display_exec_hdr( &exec );
	printf( "\n" );

}

#define pfield(name,ptr,field,how) \
	printf("%-30.30s = how\n", "name.field", ptr->field)

display_exec_hdr( e )
struct exec	*e;
{
	switch( e->a_magic ) {
		case OMAGIC:
			printf( "OMAGIC: impure format - for .o's\n" );
			break;
		case ZMAGIC:
			printf( "ZMAGIC: demand load format - zero at zero\n" );
			break;
		case XMAGIC:
			printf( "XMAGIC: demand load format - invalid at zero\n" );
			break;
		case SMAGIC:
			printf( "SMAGIC: demand load format - standalone\n" );
			break;
		default:
			printf( "Unknown magic number (0x%x)\n", e->a_magic );
			break;
	}
	printf( "N_TXTOFF(x) = %d\n", N_TXTOFF(*e) );
	printf( "N_DATAOFF(x) = %d\n", N_DATAOFF(*e) );
	printf( "N_SHDATAOFF(x) = %d\n", N_SHDATAOFF(*e) );
	printf( "N_TROFF(x) = %d\n", N_TROFF(*e) );
	printf( "N_DROFF(x) = %d\n", N_DROFF(*e) );
	printf( "N_SHDROFF(x) = %d\n", N_SHDROFF(*e) );
	printf( "N_SYMOFF(x) = %d\n", N_SYMOFF(*e) );
	printf( "N_STROFF(x) = %d\n", N_STROFF(*e) );

	pfield(exec,e,a_magic,0%o);
	pfield(exec,e,a_text,%d);
	pfield(exec,e,a_data,%d);
	pfield(exec,e,a_bss,%d);
	pfield(exec,e,a_syms,%d);
	pfield(exec,e,a_entry,0x%x);
	pfield(exec,e,a_trsize,%d);
	pfield(exec,e,a_drsize,%d);
	pfield(exec,e,a_shdata,%d);
	pfield(exec,e,a_shbss,%d);
	pfield(exec,e,a_shdrsize,%d);
	pfield(exec,e,a_version,%d);
}
