/*
** Take apart a core file and display some relevant parts.
*/


#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/param.h>
#include <sys/dir.h>
#include <sys/user.h>

char	*MyName;
int		GetStack;
int		GetData;

usage()
{
	fprintf( stderr, "Usage: %s core_file ...\n", MyName );
	exit( 1 );
}

main( argc, argv )
int		argc;
char	*argv[];
{
	for( MyName = *argv++; *argv; argv++ ) {
		if( (*argv)[0] != '-' ) {
			break;
		}
		if( (*argv)[1] == 'g' ) {
			argv++;
			switch( (*argv)[0] ) {
				case 's':
					GetStack++;
					break;
				case 'd':
					GetData++;
					break;
				default:
					usage();
			}
		} else {
			usage();
		}
	}

	for( ; *argv; argv++ ) {
		do_file( *argv );
	}
}

do_file( name )
char	*name;
{
	int		fd;
	int		got;
	struct user	uarea;
	int		data_len;

	if( (fd=open(name,O_RDONLY,0)) < 0 ) {
		perror( "open" );
		exit( 1 );
	}

	if( (got=read(fd,(char *)&uarea,sizeof(uarea))) != sizeof(uarea) ) {
		perror( "read" );
		exit( 1 );
	}

	printf( "%s:\n", name );
	display_uarea( &uarea );

#ifdef DYNIX
	data_len = ctob( uarea.u_dsize - uarea.u_tsize );
#else DYNIX
	data_len = ctob( uarea.u_dsize );
#endif DYNIX

	if( GetData ) {
		get_stuff( name, ".data", ctob(UPAGES), data_len, fd );
	}

	if( GetStack ) {
		get_stuff( name, ".stack", ctob(UPAGES) + data_len,
											ctob(uarea.u_ssize), fd );
	}
}

get_stuff( file_name, seg_name, offset, len, in_fd )
char	*file_name;
char	*seg_name;
int		offset;
int		len;
int		in_fd;
{
	long	save;
	int		out_fd;
	char	buf[1024];
	char	name[1024];
	int		bytes, got;

	if( (save = lseek(in_fd,0,1)) < 0 ) {
		perror( "lseek" );
		exit( 1 );
	}
		

	strcpy( name, file_name );
	strcat( name, seg_name );
	if( (out_fd=open(name,O_WRONLY|O_CREAT,0644)) < 0 ) {
		perror( "open" );
		exit( 1 );
	}

	if( lseek(in_fd,offset,0) < 0 ) {
		perror( "lseek" );
		exit( 1 );
	}

	for( bytes=len; bytes > 0; bytes -= got ) {
		got = read( in_fd, buf, MIN(sizeof(buf),bytes) );
		if( got == 0 ) {
			fprintf( stderr, "Unexecpted EOF in \"%s\"\n", file_name );
			exit( 1 );
		}
		if( got < 0 ) {
			perror( "read" );
			exit( 1 );
		}
		if( write(out_fd,buf,got) != got ) {
			perror( "write" );
			exit( 1 );
		}
	}
	printf( "Wrote %d bytes to \"%s\"\n", len, name );
	if( lseek(in_fd,save,0) != save ) {
		perror( "lseek" );
		exit( 1 );
	}

}


#define pfield(name,ptr,field,how) \
	printf("%-30.30s = how\n", "name.field", ptr->field)

#define print_field(name,ptr,field,how,func) \
	printf("%-30.30s = how\n", "name.field", func(ptr->field))



display_uarea( u )
struct user	*u;
{
	/*
	pfield(user,u,u_sp,0x%x);
	pfield(user,u,u_procp,0x%x);
	pfield(user,u,u_ar0,0x%x);
	pfield(user,u,u_pffcount,%d);
	pfield(user,u,u_pffvtime,%d);
	pfield(user,u,u_arg[0],0x%x);
	pfield(user,u,u_arg[1],0x%x);
	pfield(user,u,u_arg[2],0x%x);
	pfield(user,u,u_arg[3],0x%x);
	pfield(user,u,u_arg[4],0x%x);
	pfield(user,u,u_arg[5],0x%x);
	pfield(user,u,u_fltaddr,0x%x);
	pfield(user,u,u_qsave,0x%x);
	pfield(user,u,u_error,%d);
	*/
	print_field(user,u,u_tsize,%d,ctob);
	print_field(user,u,u_dsize,%d,ctob);
	print_field(user,u,u_ssize,%d,ctob);
	/*
	pfield(user,u,u_sigonstack,0x%x);
	pfield(user,u,u_oldmask,0x%x);
	*/
}
