/* 
** Copyright 1986, 1987, 1988, 1989 University of Wisconsin
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of the University of
** Wisconsin not be used in advertising or publicity pertaining to
** distribution of the software without specific, written prior
** permission.  The University of Wisconsin makes no representations about
** the suitability of this software for any purpose.  It is provided "as
** is" without express or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN DISCLAIMS ALL WARRANTIES WITH REGARD TO
** THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF WISCONSIN  BE LIABLE FOR
** ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
** ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
** OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <stdio.h>

main( argc, argv )
int argc;
char **argv;
{
	register int fd, addr;
	register int len = 0;
	char ch;

	if( argc < 3 ) {
		printf("Usage: %s file addr [new string]\n", *argv);
		exit( 1 );
	}

	if( argc == 4 ) {
		fd = open( argv[1], 2 );
	} else {
		fd = open( argv[1], 0 );
	}

	if( fd < 0 ) {
		perror(argv[1]);
		exit( 1 );
	}

	addr = atoi(argv[2]);
	if( lseek(fd, addr, 0) < 0 ) {
		perror(argv[1]);
		exit( 1 );
	}

	while( read(fd, &ch, 1) == 1 ) {
		if( ch == '\0' ) {
			break;
		}

		len += 1;
		putchar(ch);
	}

	putchar('\n');

	if( argc < 4 ) {
		exit( 0 );
	}

	if( lseek(fd, addr, 0) < 0 ) {
		perror(argv[1]);
		exit( 1 );
	}

	if( strlen(argv[3]) > len ) {
		printf("The string '%s' is too long.  Must be at most %d characters.\n",
			argv[3], len );
		exit( 1 );
	}

	if( write(fd, argv[3], strlen(argv[3])+1) != strlen(argv[3])+1 ) {
		perror(argv[1]);
		exit( 1 );
	}
}
