/*
**  Dialup IP request device.
**  A daemon should read this device to discover what remote addresses
**  need connections.
**  Copyright (c) 1991 Bolt Beranek and Newman, Inc.
**  All rights reserved.
**
**  Redistribution and use in source and binary forms are permitted
**  provided that: (1) source distributions retain this entire copyright
**  notice and comment, and (2) distributions including binaries display
**  the following acknowledgement:  ``This product includes software
**  developed by Bolt Beranek and Newman, Inc. and CREN/CSNET'' in the
**  documentation or other materials provided with the distribution and in
**  all advertising materials mentioning features or use of this software.
**  Neither the name of Bolt Beranek and Newman nor CREN/CSNET may be used
**  to endorse or promote products derived from this software without
**  specific prior written permission.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
**  WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "du.h"
#if	NDU > 0

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/conf.h"
#include "../h/file.h"
#include "../h/proc.h"
#include "../h/buf.h"
#include "../h/uio.h"
#include "../h/ioctl.h"
#include "../h/socket.h"
#include "../h/mbuf.h"
#include "../netinet/in.h"
#include "../netinet/in_systm.h"
#include "../netinet/ip.h"
#include "../net/if.h"
#include "../net/if_du.h"


#define PACKETLEN	(sizeof (struct du_pkt))

/*
**  We could eventually have one duvar for each address family.
*/
struct du_var duvar[1];
int dialup_readers = 0;


/*
**  Open the device.  Only one person, and for reading.
*/
int
dialupopen(dev, flags)
    dev_t dev;
    int flags;
{
    if ((flags & (FREAD | FWRITE)) == FREAD && dialup_readers == 0) {
	dialup_readers = 1;
	return(0);
    }
    return(EINVAL);
}


/*
**  Close the device.
*/
int
dialupclose(dev,flags)
    dev_t dev;
    int flags;
{
    if ((flags & (FREAD | FWRITE)) == FREAD && dialup_readers == 1) {
	dialup_readers = 0;
	return(0);
    }
    return(EINVAL);
}


/*
**  Read.
*/
int
dialupread(dev,uio)
    dev_t dev;
    struct uio *uio;
{
    register struct du_var *duvp;
    int error;
    int oldspl;

    /* Which family?  For now, only one. */
    duvp = &duvar[0];

    /* ok. now we are fiddling with request structure */
    oldspl = splimp();

    /* no data, sleep until some shows up */
    while (duvp->duv_size == 0)
	sleep((caddr_t)&duvp->duv_wait, PWAIT);

    /* Copy as much data as we can. */
    for (error = 0; duvp->duv_size > 0 && uio->uio_resid >= PACKETLEN; ) {
	error = uiomove((caddr_t)&duvp->duv_list[duvp->duv_index][0],
		    PACKETLEN, UIO_READ, uio);
	if (++(duvp->duv_index) == DIALMAXPENDING)
	    duvp->duv_index = 0;
	duvp->duv_size--;

	if (error)
	    break;
    }
    
    splx(oldspl);
    return(error);
}


/*
**  Request that an address be contacted.
*/
int
dialupreq(ip, sin, ifname, ifunit, checkit)
    struct ip *ip;
    struct sockaddr_in *sin;
    char *ifname;
    int ifunit;
    int checkit;
{
    register struct du_var *duvp;
    struct du_pkt pkt;
    int oldspl;

    if (dialup_readers != 1) {
	printf("dialupreq has no active reader\n");
	return(1);
    }

    bcopy((caddr_t)ip, (caddr_t)&pkt.du_ip, sizeof (struct ip));
    bcopy((caddr_t)sin, (caddr_t)&pkt.du_sin, sizeof (struct sockaddr_in));
    pkt.du_ifname[0] = ifname[0];
    pkt.du_ifname[1] = ifname[1];
    pkt.du_ifname[2] = ifname[2];
    pkt.du_ifname[3] = ifname[3];
    pkt.du_ifunit = ifunit;
    pkt.du_checkit = checkit;

    oldspl = splimp();
    duvp = &duvar[0];
    if (duvp->duv_size >= DIALMAXPENDING) {
	/* No luck; queue full, daemon is too slow. */
	splx(oldspl);
	return(1);
    }

    duvp->duv_size++;
    bcopy((caddr_t)&pkt, duvp->duv_list[duvp->duv_index], PACKETLEN);

    /* Wake up any waiting reader. */
    wakeup((caddr_t)&duvp->duv_wait);

    splx(oldspl);
    return(0);
}


/*
** I/O control
*/
/* ARGSUSED */
dialupioctl(dev, cmd, data, flag)
    dev_t dev;
    int cmd;
    caddr_t data;
    int flag;
{
    register struct du_var *duvp;

    switch (cmd) {
    case DIOINIT:
	duvp = &duvar[0];
	duvp->duv_family = AF_INET;
	duvp->duv_index = 0;
	duattach();
	return(0);
    }

    return(EINVAL);
}
#endif	/* NDU > 0 */
