/*
**  Copyright (c) 1991 Bolt Beranek and Newman, Inc.
**  All rights reserved.
**
**  Redistribution and use in source and binary forms are permitted
**  provided that: (1) source distributions retain this entire copyright
**  notice and comment, and (2) distributions including binaries display
**  the following acknowledgement:  ``This product includes software
**  developed by Bolt Beranek and Newman, Inc. and CREN/CSNET'' in the
**  documentation or other materials provided with the distribution and in
**  all advertising materials mentioning features or use of this software.
**  Neither the name of Bolt Beranek and Newman nor CREN/CSNET may be used
**  to endorse or promote products derived from this software without
**  specific prior written permission.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
**  WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

/*
**  Request packet sent on /dev/dialup.
*/
struct du_pkt {
    struct sockaddr_in	du_sin;
    struct		ip du_ip;
    short		du_checkit;
    char		du_ifname[4];
    int			du_ifunit;
};


#define DIALMAXPENDING	5

struct du_var {
    char	duv_list[DIALMAXPENDING][sizeof (struct du_pkt)];
    u_short	duv_family;	/* address family			*/
    short	duv_size;	/* size of ring buffer			*/
    short	duv_index;	/* index to start of buffer		*/
    short	duv_wait;	/* semaphore for sleep/wakeup		*/
};                        

#define DIOINIT		_IOW(d, 1, short)


/*
**  Global DU statistics.  gds_ndu must be first; see if_du.c
*/
struct globdialstats {
    long	gds_ndu;	/* Number of interfacves configured	*/
    long	gds_ipup;	/* input packets recieved from above (TCP) */
    long	gds_ipln;	/* input packets recieved from lines	*/
    long	gds_opln;	/* output packets sent out on lines	*/
    long	gds_opup;	/* output packets sent upward (TCP)	*/
};


/*
**  Per-interface statistics and state.
*/
struct du_softc {
    /* ds_if must be first; code in if_du.c can depend on it! */
    struct ifnet ds_if;		/* network-visible interface		*/
    short	ds_flags;	/* see below				*/
    short	ds_ilen;	/* length of input-packet-so-far	*/
    struct tty	*ds_ttyp;	/* pointer to tty structure		*/
    char	*ds_mp;		/* pointer to next available buf char	*/
    char	*ds_buf;	/* input buffer				*/
    u_long	ds_atimo;	/* Activity Timeout			*/
    u_long	ds_wtimo;	/* Wait State Timeout			*/
    long	ds_timer;	/* Timer - can't be unsigned		*/
    u_long	ds_cchr;	/* number of characters recieved	*/
    u_long	ds_cchs;	/* number of characters sent		*/
    u_long	ds_cpsip;	/* number of packets sent up to IP	*/
    u_long	ds_cprip;	/* number of packets recieved from IP	*/
    u_long	ds_ctpbusy;	/* # of times tty was active		*/
    u_long	ds_ctpidle;	/* # of times tty was idle		*/
    u_long	ds_sesc;	/* # of chars escaped in packets sent	*/
    u_long	ds_resc;	/* # of chars escaped in packets received */
    short	ds_mtu;		/* mtu for this interface		*/
};


/*
** DU interface state flags.
*/
#define DS_ESCAPED	0x0001	/* saw a FRAME_ESCAPE			*/
#define DS_OACTIVE	0x0002	/* actively sending a packet		*/
#define DS_LWAITING	0x0010	/* waiting for a tty			*/
#define DS_LACTIVE	0x0020	/* have active line			*/
#define DS_LDOWN	0x0040	/* Line lost or no premission to call	*/
#define DS_FAILCALL	0x0080  /* Attempted call recently, but failed	*/
#define DS_MONITORON	0x0100  /* Monitoring activity			*/
#define DS_ENABLECALL	0x0200	/* This side can initiate a call	*/
