#! /bin/sh
##  Copyright (c) 1991 Bolt Beranek and Newman, Inc.
##  All rights reserved.
##
##  Redistribution and use in source and binary forms are permitted
##  provided that: (1) source distributions retain this entire copyright
##  notice and comment, and (2) distributions including binaries display
##  the following acknowledgement:  ``This product includes software
##  developed by Bolt Beranek and Newman, Inc. and CREN/CSNET'' in the
##  documentation or other materials provided with the distribution and in
##  all advertising materials mentioning features or use of this software.
##  Neither the name of Bolt Beranek and Newman nor CREN/CSNET may be used
##  to endorse or promote products derived from this software without
##  specific prior written permission.
##
##  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
##  WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

progname="`basename $0`"

##  Check usage.
case $# in
0)
    DEV=++DEFAULT++
    ;;
1)
    DEV=$1
    ;;
*)
    echo "Usage: $progname [<file-to-link>]"
    exit 1
esac
if [ ! -f ${DEV} ] ; then
    echo "${DEV} does not exist."
    echo "Usage: $progname [<file-to-link>]"
    exit 1
fi

##  Find out how many devices to create.
echo "Please enter the number of network devices the kernel has been"
echo "generated to hold.  This number must match the value given in"
if [ -f /sys/conf/DIALUP ] ; then
    echo "your configuration:"
    awk 'NF == 3 && $2 == "du" { printf "\t%s\n", $0 }' </sys/conf/DIALUP
else
    echo "du.h for the constant NDU."
fi
while : ; do
    echo ""
    echo "How many du network devices to install? " | tr -d '\012'
    read COUNT
    # Is this a number?
    if [ `expr "${COUNT}" : "[0-9]*"` -eq `expr "${COUNT}" : ".*"` ] ; then
	break
    fi
    # Wrong!
    echo "$progname: \"${COUNT}\" is not a number.  Please enter a number."
done

##  Remove old links.
rm -f ${DEV}_*

##  Link the devies.  No better way to do this loop.
I=0
for L in a b c d e f g h i j k l m n o p q r s t u v w x y z ; do
    for J in 0 1 2 3 4 5 6 7 8 9 ; do
	# Done?
	if [ ${I} -ge ${COUNT} ] ; then
	    echo ""
	    echo "$progname:  Created ${COUNT} network devices."
	    exit 0
	fi

	I=`expr ${I} + 1`
	echo "Linking \"${DEV}\" to \"${DEV}_du${L}${J}\""
	ln ${DEV} ${DEV}_du${L}${J}
    done
done

echo "Not enough devices!?"
exit 1
