/*
**  Provide the Dialup IP release string.
**  Copyright (c) 1991 Bolt Beranek and Newman, Inc.
**  All rights reserved.
**
**  Redistribution and use in source and binary forms are permitted
**  provided that: (1) source distributions retain this entire copyright
**  notice and comment, and (2) distributions including binaries display
**  the following acknowledgement:  ``This product includes software
**  developed by Bolt Beranek and Newman, Inc. and CREN/CSNET'' in the
**  documentation or other materials provided with the distribution and in
**  all advertising materials mentioning features or use of this software.
**  Neither the name of Bolt Beranek and Newman nor CREN/CSNET may be used
**  to endorse or promote products derived from this software without
**  specific prior written permission.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
**  WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/
#include <stdio.h>
#include <ctype.h>

char *
dip_release()
{
    static char	buff[20];
    extern char	*strcpy();
    char	rev[20];
    char	*p;

    /* If we have been here before, take the easy way out. */
    if (buff[0])
	return buff;

    /* Pull the release out of the RCS string. */
    for (p = "$Revision: 2.0 $"; *p && !isdigit(*p); p++)
	;
    (void)strcpy(rev, p);
    for (p = rev; *p && !isspace(*p); p++)
	;
    *p = '\0';
	    
    (void)sprintf(buff, "Dialup IP %s", rev);

    return buff;
}
