##
##  Common make include file for Dialup IP.
##  Copyright (c) 1991 Bolt Beranek and Newman, Inc.
##  All rights reserved.
##
##  Redistribution and use in source and binary forms are permitted
##  provided that: (1) source distributions retain this entire copyright
##  notice and comment, and (2) distributions including binaries display
##  the following acknowledgement:  ``This product includes software
##  developed by Bolt Beranek and Newman, Inc. and CREN/CSNET'' in the
##  documentation or other materials provided with the distribution and in
##  all advertising materials mentioning features or use of this software.
##  Neither the name of Bolt Beranek and Newman nor CREN/CSNET may be used
##  to endorse or promote products derived from this software without
##  specific prior written permission.
##
##  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
##  WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
##

##  Some versions of make need this, else they will call the user's shell.
SHELL		= /bin/sh

##  Directory where the system is.
DIAL_BUILD	= /usr/dialupip

##  Directory paths.  See include/dialupip.h before changing these.
DIAL_ROOT	= /usr/dialupip
BIN_DIR		= $(DIAL_ROOT)/bin
LOG_DIR		= $(DIAL_ROOT)/log
CONFIG_DIR	= $(DIAL_ROOT)/config

##  Program flags.
#	Set this to -g or -O, as appropriate.
DEBUG_OR_OPT	= -g
#	Pre-processor definitions, for use below.
DEFS		= -I$(DIAL_BUILD)/src/include
#	C compiler flags.
CFLAGS		= $(DEFS) $(DEBUG_OR_OPT)
#	Linker flags.
LDFLAGS		= $(DEBUG_OR_OPT)
#	Lint flags.
LINTFLAGS	= $(DEFS)
DIPLINTLIB	= $(DIAL_BUILD)/src/lib/llib-ldiputil.ln
#	Library.
DIPLIB		= $(DIAL_BUILD)/src/lib/libdiputil.a
