/*
**  Dialup IP header file.
**
**  Copyright (c) 1991 Bolt Beranek and Newman, Inc.
**  All rights reserved.
**
**  Redistribution and use in source and binary forms are permitted
**  provided that: (1) source distributions retain this entire copyright
**  notice and comment, and (2) distributions including binaries display
**  the following acknowledgement:  ``This product includes software
**  developed by Bolt Beranek and Newman, Inc. and CREN/CSNET'' in the
**  documentation or other materials provided with the distribution and in
**  all advertising materials mentioning features or use of this software.
**  Neither the name of Bolt Beranek and Newman nor CREN/CSNET may be used
**  to endorse or promote products derived from this software without
**  specific prior written permission.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
**  WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/


/*
**  Paths to log files, etc.
*/
#define CALL_LOG		"/usr/dialupip/log/call.log"
#define DIALMOND_LOG		"/usr/dialupip/log/dialmond.log"
#define LOG_FILE		"/usr/dialupip/log/dial.log"
#define PID_FILE		"/usr/dialupip/log/PID.%s"
#define CONFIG_DIR		"/usr/dialupip/config"
#define DEVDIAL			"/dev/dialup0"
#define DIALD_CONFIG		"/etc/diald.conf"


/*
**  How often to log line as up, in minutes.
*/
#define UPTIME_INTERVAL		5


/*
**  Get or set data from the interface.
*/
#ifdef	sun
#define GETDATAVAL(ifr)		(*(int *)ifr.ifr_data)
#define SETDATAVAL(ifr, i)	(*(int *)(ifr).ifr_data = (i))
#else
#define GETDATAVAL(ifr)		((int)ifr.ifr_data)
#define SETDATAVAL(ifr, i)	((ifr).ifr_data = (caddr_t)(i))
#endif	/* sun */


/*
**  Logging levels.
*/
#define DLOG_GENERAL		0	/* Routine log messages		*/
#define DLOG_INFO		1	/* Informational messages	*/
#define DLOG_DIAG		2	/* Diagnostic messages		*/
#define DLOG_ALL		3	/* Verbose			*/


/*
**  Logging variables and functions.
*/
extern int	log_level;		/* Current logging level	*/
extern char	*progname;		/* Program name			*/
extern void	d_log();		/* Write a log entry		*/
extern char	*dip_release();		/* Release string		*/
