/*
**  Copyright (c) 1991 Bolt Beranek and Newman, Inc.
**  All rights reserved.
**
**  Redistribution and use in source and binary forms are permitted
**  provided that: (1) source distributions retain this entire copyright
**  notice and comment, and (2) distributions including binaries display
**  the following acknowledgement:  ``This product includes software
**  developed by Bolt Beranek and Newman, Inc. and CREN/CSNET'' in the
**  documentation or other materials provided with the distribution and in
**  all advertising materials mentioning features or use of this software.
**  Neither the name of Bolt Beranek and Newman nor CREN/CSNET may be used
**  to endorse or promote products derived from this software without
**  specific prior written permission.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
**  WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/if.h>
#include <net/if_du.h>
#include <fcntl.h>
#include "dialupip.h"

extern int	errno;
extern int	optind;
extern char	*optarg;
extern char	*strerror();


static void
usage()
{
    (void)fprintf(stderr, "Usage: %s [-f family#] [device]\n", progname);
    exit(1);
}


main(argc, argv)
    int			argc;
    char		*argv[];
{
    int			fd;
    int			i;
    unsigned short	family;
    char		*device;

    setprogname(argv[0]);
    family = AF_INET;
    device = DEVDIAL;

    while ((i = getopt(argc, argv, "f:")) != EOF)
	switch (i) {
	default:
	    usage();
	    /* NOTREACHED */
	case 'f':
	    family = (u_short)atoi(optarg);
	    if ((int)family <= AF_UNSPEC || (int)family >= AF_MAX) {
		(void)fprintf(stderr, "%s: Bad family \"%s\"\n",
			progname, optarg);
		exit(1);
	    }
	}
    argc -= optind;
    argv += optind;
    switch (argc) {
    default:
	usage();
	/* NOTREACHED */
    case 0:
	break;
    case 1:
	device = argv[0];
	break;
    }

    if ((fd = open(device, O_RDONLY)) < 0) {
	(void)fprintf(stderr, "%s: Can't open device \"%s\", %s\n", 
		progname, device, strerror(errno));
	exit(1);
    }

    if (ioctl(fd, DIOINIT, (caddr_t)&family) < 0) {
	(void)fprintf(stderr, "%s: Can't initialize device, %s\n",
		progname, strerror(errno));
	exit(1);
    }

    (void)close(fd);
    exit(0);
    /* NOTREACHED */
}
