/*
**  Copyright (c) 1991 Bolt Beranek and Newman, Inc.
**  All rights reserved.
**
**  Redistribution and use in source and binary forms are permitted
**  provided that: (1) source distributions retain this entire copyright
**  notice and comment, and (2) distributions including binaries display
**  the following acknowledgement:  ``This product includes software
**  developed by Bolt Beranek and Newman, Inc. and CREN/CSNET'' in the
**  documentation or other materials provided with the distribution and in
**  all advertising materials mentioning features or use of this software.
**  Neither the name of Bolt Beranek and Newman nor CREN/CSNET may be used
**  to endorse or promote products derived from this software without
**  specific prior written permission.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
**  WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

#define DIALMOND_PATH		"/usr/etc/dialmond"
#define DIALMON_SERVICE		"dip-status"
#define DIALMON_DEFAULT_PORT	190
#define MAX_NDU			20

#ifndef	FD_SET
#define fd_set	long
#define FD_SET(n, p)		(*(p) |= (1 << (n)))
#define FD_CLR(n, p)		(*(p) &= ~(1 << (n)))
#define FD_ISSET(n, p)		(*(p) & (1 << (n)))
#define FD_ZERO(p)		(*(p) = 0)
#endif	/* !FD_SET */

typedef struct _LINESTATS {
    unsigned long	ln;		/* Serial line number		*/
    unsigned long	cchr;		/* Characters recieved		*/
    unsigned long	cchs;		/* Characters sent		*/
    unsigned long	cpsip;		/* Packets sent up to IP	*/
    unsigned long	cprip;		/* Packets recieved from IP	*/
    unsigned long	flags;		/* Line status			*/
    unsigned long	ctpbusy;	/* TTY active count		*/
    unsigned long	ctpidle;	/* TTY idle count		*/
    unsigned long	sesc;		/* Chars escaped in packets sent */
    unsigned long	resc;		/* Chars escaped in packets received */
    unsigned long	ierror;		/* Input errors			*/
    unsigned long	oerror;		/* Output errors		*/
    struct in_addr	dest;		/* Host on other end of the line */
} LINESTATS;

typedef struct _DIALSTATS {
    time_t		when;		/* When this record was made	*/
    unsigned long	avenrun[3];	/* Load average			*/
    unsigned long	cputime[CPUSTATES]; /* Time spent in USER/NICE/... */
    unsigned long	ipup;		/* Input pkts recieved from above */
    unsigned long	ipln;		/* Input pkts recieved from lines */
    unsigned long	opln;		/* Output pkts sent out on lines */
    unsigned long	opup;		/* Output pkts sent upward (TCP) */
    unsigned long	ndu;		/* Number of devices configured	*/
    LINESTATS		ln[MAX_NDU];	/* Line stats			*/
} DIALSTATS;
