\" $Header: usenix.paper.ms,v 2.0 91/01/11 17:12:08 rsalz Exp $
.nr PO 1.25i
.FM 1i
.HM 1i
.DS C
.ps 14
.vs 16.8
\fBImplementation of Dial-up IP for UNIX Systems\**\fP
.DE
.FS
UNIX is a registered trademark of AT&T.
.FE
.DS C
.ps 11
.vs 13.2
.ft I
Leo Lanzillo
.ft R
CSNET Coordination and Information Center\**
BBN Systems and Technologies Corporation
Cambridge, MA 02238
617-873-2777
leo@sh.cs.net
.sp
.ft I
Craig Partridge
.ft R
BBN Systems and Technologies Corporation
Cambridge, MA 02238
617-873-2777
craig@nnsc.nsf.net
.DE
.LP
.FS
CSNET is operated by BBN Systems and Technologies Corporation under
a subcontract with the University Corporation for Atmospheric Research,
which operates under contract with the U.S. National Science Foundation.
Any opinions, findings, conclusions or recommendations expressed in this
paper are those of the authors and do not necessarily reflect the views
of BBN, UCAR, or the NSF.
.FE
.fi
.ad
.ce 1
\fBAbstract\fP
.sp 0.5
.in +0.75i
.ll -0.75i
.ps -1.5
.vs -1.8
CSNET has developed a driver to support the sending of Internet
Protocol (IP) datagrams
over dial-up phone lines. This driver can automatically establish and
disconnect phone calls as IP traffic dictates. This code works in
binary-only BSD systems.
.br
.ll +0.75i
.in -0.75i
.NH 1 
Introduction and Motivation
.PP
As the proliferation of computers, workstations, and local area
networks continues, the demand for an inexpensive, simple, and reliable
method of connecting computers and networks also grows.  One
of the least expensive methods of connecting computers is to use dial-up
phone lines.
This approach results in a true pay-for-usage fee service,
but until now the use of dial-up phone lines has been restricted to
application-specific protocols, instead of more
general networking protocols that could be used by multiple applications.
.PP
Dial-up IP is a solution to this problem. Because of its dial-up nature,
its cost is directly related to usage. It requires only modems and
serial interfaces, and, most important, it provides Internet Protocol
(IP) connectivity between the two endpoints. IP connectivity allows the
host administrators to link computers together using any Internet protocol,
including TCP and UDP, and at higher levels, FTP, TELNET, \fIrcp\fP,
\fIrlogin\fP, and NFS.\**
.FS
Don't try this at home.
Currently, commercial NFS systems do not run well
through gateways or over slow links, however
an experimental version of NFS that has been enhanced with Jacobson's
algorithms has been shown to work quite well over complex internets.
.FE
In addition, the system's use of dial-up
links allows for the on-demand joining of different networks by connecting
IP gateways to form an internetwork of computers.
.NH 2
A New CSNET Service
.PP
We view dial-up IP as an enhanced replacement for CSNET's PhoneNet service.
CSNET is a logical network, a metanetwork, which, in addition to
information and consulting services,
offers two distinct types of communication services.
The ``top-of-the-line'' service is full-time IP connectivity with the
Internet through the DARPA-approved gateway, \fIrelay.cs.net\fP.
Connectivity can be provided via X.25 over a public data network [#6], via
Cypress [#4],
or via a leased data line to the CSNET CIC. The monthly costs of such
arrangements are sufficiently high that they are usually
of interest only to high-volume users (i.e., users requiring over
two to four hours of connectivity per day).
.PP
The other CSNET communication service is PhoneNet, which provides
electronic mail connectivity to
over one hundred universities and research centers.
PhoneNet is a star-shaped, store-and-forward mail network
that uses dial-up phone lines and modems to transfer mail between
remote sites and \fIrelay.cs.net\fP. \fIRelay\fP acts as a gateway
to the Internet and to other PhoneNet sites. These sites periodically call or
are called to deliver mail. The average delivery time via PhoneNet
ranges from one hour to one day.
.PP
PhoneNet is limited in that it is used only for mail. Many of the
CSNET clients have asked for access to the wider range of Internet services
available via TCP/IP, in particular, anonymous FTP.
There have also been occasional complaints about the limited error recovery
ability of the PhoneNet protocol.
.PP
Dial-up IP is an intermediate offering that
combines the positive aspects of CSNET's other services:
the robustness and reliability of full-time IP, the efficiency
and cost management aspects of PhoneNet, and ready availability.
Dial-up IP is also
more secure than a full-time IP connection, both because
there are a number of security checks that must be passed before
a connection is established and because the line is only up for
limited periods of time.
.NH 2
Design Goals
.PP
We had three major design goals.  Dial-up IP had to be easy
to install, transparent to users, cost-effective and moderately secure.
.PP
Dial-up IP had to be easy to install and to configure.
Inexperienced system administrators needed to be able to
install software quickly and to not have to worry about it. For these
reasons we designed dial-up IP to fit cleanly into the UNIX kernel,
requiring modifications only to configuration files and a couple of
include files.
.PP
Given the diversity of the CSNET community, and the fact that many
sites are universities with high-turnover student help,
we had to design dial-up IP to be simple to use, or better yet,
transparent to the users.  Other dial-up systems require user
intervention to establish a phone link. We wanted to develop a
version of dial-up IP
which makes the connection establishment transparent to the user.
This approach has a further advantage of saving the user from having
to know which network a particular
host is on. Dial-up hosts, or hosts on LANs accessible only through
dial-up gateways, appear as accessible as hosts on
permanently-connected networks.
.PP
Furthermore, we wanted dial-up IP to be cost-effective. We wanted it
to use the line resources efficiently by filling the line bandwidth
when a phone line was active and minimizing phone charges by
terminating phone lines quickly when they were no longer in use.
.PP
Finally, we wanted dial-up IP to be moderately secure.  In particular,
we wanted sites to be able to control when dial-up links were established
and who was able to establish them.
.PP
We believe we have achieved these goals.
.NH 1
A Datagram's Journey Through Dial-up IP
.PP
To illustrate how dial-up IP works, a brief and slightly
simplified description of an example dial-up IP interaction follows.
.PP
Imagine that \fIbig-college.edu\fP has a dial-up IP link to
\fIrelay.cs.net\fP, and that a user on \fIbig-college.edu\fP wishes
to FTP a file from some other Internet site.
.PP
When \fIftp\fP is invoked by the user, it calls on TCP to establish a
connection to the other site.
TCP, in turn, calls upon IP
to send a TCP SYN datagram (a synchronizing segment used to open
connections) to the remote site.
.PP
When IP receives a datagram it consults its routing tables to find
out which network interface to send the datagram out on. In this example,
the routing tables point to a dial-up IP interface, \fIdu0\fP.
The IP layer then queues the datagram on the outbound queue of
\fIdu0\fP.
.PP
When a datagram arrives on \fIdu0\fP's queue, the dial-up interface code
checks to see if a phone call is currently in progress to
\fIrelay.cs.net\fP. If a call is in progress, the datagram
is sent over the line. However, if a call is not currently in progress,
the dial-up interface must find a way to dial the phone.
.PP
Unfortunately, the interface layer of the kernel is not the best place
to insert code to dial a modem. Dialing a modem takes several seconds
and the interface code in the kernel is running at a high interrupt
level. To get around this problem, we created a pseudo-device,
\fI/dev/dial-up\fP, for requests to dial the phone. \fI/dev/dial-up\fP
maintains a queue of requests for modems to be dialed. \fIDu0\fP
requests a phone call by writing a request structure into the queue.
A daemon, \fIdiald\fP, reads the requests from the queue, finds an
available modem, dials the remote host, and then logs into a special
account. (Note that we use standard UNIX \fIlogin\fP; the account
is special because it has a login shell that brings up dial-up IP).
Once the login is completed, the SLIP protocol [#5] is activated on the line.
At this point, the local dial-up interface is notified that it can start
passing datagrams over the connection.
.PP
On the remote end, when the datagram is received from the dial-up line,
it is passed up to the IP layer, like a datagram from any other interface.
.PP
After the phone call is established, the dial-up IP driver watches
the line. If the line is idle for too long (a few minutes) the driver
initiates a hangup.
.NH 1
Details of the Kernel Implementation
.NH 2
The Dial-up Interface
.PP
Dial-up IP looks like a standard BSD interface to the higher layers.
The interface code is a substantially enhanced version of the SLIP driver
written by Rick Adams and distributed with BSD 4.3. In addition to
handling the SLIP protocol the driver now
includes code to check on the status of the line
(and request a phone call if the line is down), code to time out
the line if it is idle, and extensive support for monitoring tools.
.PP
One complication in the interface is that a phone call may fail,
leaving outbound datagrams sitting in the interface queue.
We handle this problem by having the driver timeout
the connection attempt if it takes too long and discard all queued
datagrams. (Thankfully, IP permits datagrams to be discarded if they
are undeliverable).
.PP
Another source of trouble comes from concurrent connection attempts (phone
calls from both ends of the connection at the same time). This
is handled by having the driver sleeping on a flag, and allowing
it to be awakened either by a successful outgoing call, or a successful
incoming call. The other call is then locked out, and will fail.
.NH 2
The Dial-up Pseudo-Device
.PP
The driver for the pseudo-device, \fI/dev/dial-up\fP, is new
and comprises just a few lines of code.
The one difficulty in writing the pseudo-device code
was to avoid race conditions between the high-interrupt level
interface driver and the application-level daemon. The record
passed to the daemon contains address information and as well as part
of the IP header. This gives \fIdiald\fP enough information to make selective
decisions about when to dial the phone (see below).
.NH 2
Routing
.PP
Routing for dial-up IP is simple. The dial-up IP interface looks
like a standard point-to-point link to the rest of the kernel.  Thus
any datagram that can be sent over a point-to-point link can be
sent over dial-up IP, including datagrams to networks that are
on the other side of a dial-up link. Multiple dial-up IP links
on a single host are feasible, although we recommend using
dial-up IP only in a star topology; establishing multi-hop
connections takes too long.
.PP
One small routing complication we encountered was that
the BSD kernel checks to see if an interface is in the UP state
before queuing datagrams on it. A dial-up link may not
be up before it receives a datagram, so we had to fool the kernel
into thinking that the interface was up, when in fact, no call
was active. We solved this by simplying leaving the interface state
hardwired as UP, and keeping track of whether we need to make a
phone call with another flag maintained by the interface code.
.NH 2
Support for Multiple Platforms
.PP
The dial-up IP software package provides full IP support over
dial up phone lines. It runs on Ultrix, Sun and BSD UNIX
systems and
requires a modem and a serial port on the computer.
This software communicates with other computers that support
dial-up IP or at least some version of SLIP. For example, dial-up IP
works with Phil Karn's KA9Q SLIP package for IBM compatible PCs. We
are currently investigating using it with Sun's dial-up PC-NFS package.
.NH 1
Support Applications
.PP
Dial-up IP requires some programs that run as user processes. These
programs take care of call set up, interface configuration, monitoring
and so on. These programs also make use of configuration files which specify
phone numbers, devices, account names and connection-time restrictions.
User level programs have also been developed for monitoring the
dial-up IP link at both the IP and serial line level.
Finally, utilities have been written for examining and changing timeouts and
other interface parameters.
.NH 2
The Dialing Daemon
.PP
The key support program for providing transparency to the
user is the dialing daemon, \fIdiald\fP,
which dials the modem when dial-up interfaces need a connection established.
.PP
\fIDiald\fP is partially derived from the existing PhoneNet code that
knows how to dial telephones. The dialing code reads a script that lists
the commands necessary to establish a connection and log in. The
command language for scripts is sufficiently diverse that \fIdiald\fP
can establish a link not only over phone lines, but also through
\fItelnet\fP, X.25 PAD and various switching devices such
as port-selectors and even PC-Pursuit.
.PP
\fIDiald\fP also supports facilities that restrict access to the
dial-up sites. Recall that the \fI/dev/dialup\fP device passes up
some information from the IP header of the datagram that caused
the request to bring up the link.  By checking this information with
instructions in a configuration file, \fIdiald\fP
can refuse to initiate calls based based on the source or destination IP
address of the packet, the time of day, or higher level protocols
(ICMP, UDP etc). These facilities allow the host
to filter requests for bringing up the line and give administrators
greater control over costs and access to their network.
.PP
When a dial-up interface must make a phone call, it places
a request in the \fI/dev/dial-up\fP pseudo-device.
When \fIdiald\fP reads this request, it matches the IP destination of the
request with a specific remote host. The daemon then performs
the security checks on the IP protocol number, the source and
destination addresses,
and the time of day. If the request is legitimate, \fIdiald\fP forks a
child that runs the script to dial the phone number and perform the login
sequence. At the remote (passive) end, a special shell is invoked that
does further handshaking between the shell and the daemon child.
Once the handshake is complete, both the child and the remote
special shell do \fIioctl()\fPs to activate their dial-up interfaces.
(The interfaces are brought up by switching the \fItty\fPs to
a special line discipline.)
The processes then sleep until the line is dropped. When
the drivers time out the line, they send a SIGHUP to the controlling
processes, at which time the processes clean up and exit.
.PP
Because the daemon-child and the special shell sleep instead of dying,
the UNIX kernel believes that the \fItty\fP port is still in use.
This prevents other \fIgetty\fPs from running on the passive end of the
connection and prevents the line discipline from being reset on both ends. 
.NH 2
Manually Starting or Ending a Connection
.PP
In order to provide greater control to system administrators, we provide
a utility called \fIupline\fP
for manually establishing a connection to a
particular dial-up site. The \fIupline\fP program can be run
by hand or from shell scripts, and it takes a hostname or
IP number as an argument. It operates much like the \fIdiald\fP
daemon to establish a link.
.PP
In order to save phone charges, the dial-up IP driver will timeout inactive
lines and terminate connections, which saves the user or administrator from
dealing with disconnects. But if they wish, there is also a program,
\fIdownline\fP, which allows administrators to take down a link manually.
.NH 2
Access Control
.PP
Currently, the only limits on the access and use of dial-up IP links
are the checks done by \fIdiald\fP before establishing a connection.
We are considering enhancing the dial-up IP access controls
to filter out unwanted traffic while the link is up.  The justification
for such filtering is both that sites may wish to protect themselves
from unauthorized IP access from outside and, more importantly, that
the dial-up links only be used by traffic that the site wants to pay for.
.PP
So far, the best algorithm appears to be to maintain a hash table of
remote addresses.  Under this scheme, a remote IP address is 
accredited by receiving a datagram from the dial-up IP site
destined for the remote address.  Thus, whenever a datagram is
received from the link, the outbound IP address is added to the hash table,
and any time a datagram is presented to be sent out the link,
the driver would first check to confirm that the source IP address
was in the table.  Given that most links are only up for a brief period
(usually much less than one hour) and the number of remote sites with
which it exchanges data in one session is small, the hash table
of accredited addresses should not need to be very large.
.NH 1
Services and Facilities
.PP
Dial-up IP provides a basic connection to \fIrelay.cs.net\fP but
applications programs must be run
to accomplish any real work. One problem is get these programs running
(on remote systems) after a phone line is brought up. Since one of
the main functions of dial-up IP in the CSNET community is to handle
mail delivery, we have developed software that allows dial-up sites
to request mail and other services from \fIrelay.cs.net\fP.
(All Internet mail to the site can be directed to \fIrelay.cs.net\fP
for queuing through judicious use of domain name system's MX resource
records [#8].)
.PP
This software is based on a client-server model in which the client is
able to ask the server to start mail delivery via the Simple Mail
Transfer Protocol (SMTP) [#7] to a particular site, or
to get usage data for a site, or to provide access to the BIND
nameserver.  We believe a number of services remain which
would be useful to dial-up IP users, and this client-server program
provides a platform for these additional services.
.PP
Because dial-up IP is a pay-for-usage service, we provide tools for
monitoring the usage at both the calling and the called end. Each
call is logged, and the duration of the call is recorded so that
administrators can monitor usage of the service. In addition,
there are facilities for dynamic monitoring of the link at both
the IP level and and at the serial line level.  A monitoring
package is available that allows lines to be monitored locally or
remotely, and can display statistics on the amount of traffic,
utilization, number of characters, number of errors, and so on.
There is also a tool for examining and dynamically modifying some of the
dial-up parameters such as the timeout values and flags. 
.NH 1
Performance
.PP
When we started work on dial-up IP, we were concerned that its
performance might not be satisfactory. In particular, we were concerned
about the so-called ``slow-line problem.'' The slow-line problem
affects communications over transmission lines whose speed is
sufficiently low that the size of a datagram noticeably influences
its transmission time. For example, IP datagrams typically vary
in size from about 40 to 2048 bytes. On a 10Mbit (1.25Mbyte) Ethernet, any
datagram in this size range can be transmitted in a fraction of a second.
But on a 2400 bps telephone line, while a 40 byte datagram takes
a sixth of a second, a 2048 byte datagram takes nearly 7 seconds.
.PP
The dramatic variation in transmission times can confuse TCP implementations.
TCP uses an estimation of the network transmission times to decide
when to retransmit a piece of data. On a slow link it is possible for
a TCP implementation that has a low transmission estimate (based on
transmission times of small datagrams) to send multiple, unnecessary
retransmissions of large datagrams which clog up the link.
In early 1988, most TCP implementations used time
estimation algorithms that did not deal well with large variations,
and informal reports suggested that in some scenarios, the slow-line
problem caused 90% of the nominal bandwidth to be lost.
As a result, we feared that the slow link problem would make dial-up IP
uneconomical.
.PP
Thanks to the work of several researchers, primarily Van Jacobson and
Phil Karn [#2,#3],
TCP time estimation algorithms have improved dramatically in the past
year.  By the time we tested our TCP implementation (which incorporated
these new time estimation algorithms) over the dial-up IP links, we
achieved throughput rates of over two-thirds of the line speed.
.PP
One unexpected problem with using dial-up IP is that
it can take over one minute to make a phone call and establish a
dial-up IP link. This presents a problem for many current
implementations of TCP that use a timeout of only 30 seconds for
the initial connection setup (the time they are willing to wait for
an acknowledgement to the first SYN datagram sent out). We found that
we had to increase the TCP connection timeout value to be 75 seconds
for dial-up IP to work smoothly.   To ensure that all TCP implementations
use equally high timeout values we have asked the Internet Engineering
Task Force, which is in the process of developing a set of standards for
hosts running TCP/IP, to require a longer TCP connection timeout.
.NH 1
Conclusion
.PP
We believe that dial-up IP is an excellent replacement for CSNET's
PhoneNet service. In addition to cost savings, we have experienced fewer
problems with PhoneNet sites using dial-up IP. Less overhead is required
to support each site. There are fewer problems establishing the connection.
TCP has proved better able to deal with transmission problems than PhoneNet.
The biggest gain is that SMTP is more robust than the PhoneNet protocol so
that there are fewer stuck messages which clog the mail queues. 
.PP
More generally, we believe this service is well suited for linking a number
of remote stations or isolated LANs to each other, particularly for
sites which require only infrequent IP access to computers at other sites.
One limitation of dial-up IP is its long link setup time.  Because link
setup currently takes a long time, TCP connections cannot currently
establish a connection over a path that has multiple dial-up links.
(Note that once a dial-up link has been established, dial-up links
perform just as fast as dedicated lines).
.SH
References
.IP [#2]
V. Jacobson,
``Congestion Avoidance and Control,''
\fIProc. ACM SIGCOMM '88\fP, pp. 314-329,
Stanford, California, August 1988.
.IP [#3]
P. Karn and C. Partridge,
``Improving Round-Trip Time Estimates in Reliable Transport Protocols,''
\fIProc. ACM SIGCOMM '87\fP, pp. 1-7,
Stowe, Vermont, August 1987.
.IP [#4]
D.E. Comer and T. Narten,
``UNIX Systems as Cypress Implets,''
\fIProc. 1988 Winter USENIX Conf.\fP,
pp. 55-62, Dallas, TX, February 1988.
.IP [#5]
J. Romkey, \fIA Nonstandard for Transmission of IP Datagrams Over Serial
Lines: Slip; RFC 1055\fP,
Internet Working Group, Requests for Comments,
No. 1055, DDN Network Information Center (NIC) at SRI International,
Menlo Park, California, June 1988.
.IP [#6]
D.E. Comer and J.T. Korb,
``CSNET Protocol Software: The IP-to-X.25 Interface,''
\fIProc. ACM SIGCOMM '83\fP, pp. 154-169,
Austin, TX, March 1983.
.IP [#7]
J. Postel,
\fISimple Mail Transfer Protocol; RFC 821\fP,
Internet Working Group, Requests for Comments,
No. 821, DDN Network Information Center (NIC) at SRI International,
Menlo Park, California, August 1982.
.IP [#8]
C. Partridge,
\fIMail Routing and the Domain System; RFC 974\fP,
Internet Working Group, Requests for Comments,
No. 974, DDN Network Information Center (NIC) at SRI International,
Menlo Park, California, January 1986.
