.\" $Header: install.ms,v 2.0 91/01/11 17:12:04 rsalz Exp $
.\"  Copyright (c) 1991 Bolt Beranek and Newman, Inc.
.\"  All rights reserved.
.\"
.\"  Redistribution and use in source and binary forms are permitted
.\"  provided that: (1) source distributions retain this entire copyright
.\"  notice and comment, and (2) distributions including binaries display
.\"  the following acknowledgement:  ``This product includes software
.\"  developed by Bolt Beranek and Newman, Inc. and CREN/CSNET'' in the
.\"  documentation or other materials provided with the distribution and in
.\"  all advertising materials mentioning features or use of this software.
.\"  Neither the name of Bolt Beranek and Newman nor CREN/CSNET may be used
.\"  to endorse or promote products derived from this software without
.\"  specific prior written permission.
.\"
.\"  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
.\"  WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
.\"  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.de XX
.br
.IP "\(rh\ \ \ [\ ]\ \ " 1i
..
.TL
Installing and Operating Dialup IP 2.0*\*F
.FS
*This paper has been extensively revised for Dialup IP 2.0,
but is based upon Leo Lanzillo's version 1.0 documentation
done while at the CSNET CIC.
.FE
.AU
John Curran
.AI
CSNET Coordination and Information Center
BBN Systems and Technologies
Cambridge, MA  02139
<jcurran@bbn.com>
.AU
Rich Salz
.AI
BBN Systems and Technologies
Cambridge, MA  02139
<rsalz@bbn.com>
.AB
The Dialup IP package is a collection of drivers and support programs that
allow Internet Protocol (IP) traffic over over dynamically-activated
phone connections.
This paper describes a step-by-step installation procedure for the package
and will explain how to configure the software for normal operation.
The topics covered include software installation, configuration,
and troubleshooting.
.AE
.NH 1
Overview
.NH 2
Introduction
.LP
The Dialup IP software runs on Sun 3.5, BSD 4.3, and Ultrix 3.1 operating
systems and uses the system's serial ports to establish IP connections as
needed to other hosts running either Dialup IP or SLIP.
This document is divided into 4 parts.
The Overview section provides background information on the
Dialup IP software including its components and their interrelation.
The subsequent sections cover installation, configuration, and troubleshooting.
In each section, a checklist of steps has been provided for your convenience.
Please resist the urge to work directly from these checklists and
read the entire document before proceeding.
.NH 2
Dialup IP Terminology
.LP
In this document, the following terms will apply:
.IP \fBlocal\ system\fP 15
The system which is running the Dialup IP software at this location.
The local system frequently acts as a gateway for other systems
on the same network.
.IP \fBremote\ system\fP 15
The system being connected to via Dialup IP.
The remote system usually, but not always, is acting as a gateway to the Internet.
.IP \fBdial-out\fP 15
The mode of operation in which the local system automatically 
initiates a connection to the remote system as needed.
.IP \fBdial-in\fP 15
The mode of operation in which the remote system automatically
initiates a connection to the local system when necessary.
.NH 2
Dialup IP Components
.LP
The Dialup IP package is made up of several distinct components:
.IP \fBThe\ dialup\ network\ interface\fP 15
.br
This kernel interface delivers packets to and from the dialup IP software.
It is based upon the SLIP interface, but it has been modified to initiate
connections as needed.
.IP \fBThe\ dialup\ request\ device\fP 15
.br
This device supports a queue of pending connection requests.
The device driver code adds routines to the kernel for opening the device and writing
requests to it.
.IP \fBThe\ diald\ daemon\fP 15
.br
This daemon processes the queued connection requests by acquiring a serial
line and running the appropriate login script for each.
The daemon is started at system initiation from the startup commands and runs
until system shutdown.
.IP \fBThe\ dudisc\ program\fP 15
.br
This program is run by dial-in hosts connecting to the local system.
It sets the line discipline of the tty port to Dialup IP.
.IP \fBThe\ duioctl\ program\fP 15
.br
This command is used to configure the ``\fBdu\fP'' interfaces.
It must be run under
.B root
as it makes device control calls.
.IP \fBThe\ dulogin\ program\fP 15
.br
This program is an optional replacement for the \fIlogin\fP program
which speeds up dial-in connection establishment.
.IP \fBThe\ dialmond\ daemon\fP 15
.br
This daemon collects Dialup IP traffic and usage statistics from the
dialup interfaces and passes it to \fIdialmon\fP for display.
.IP \fBThe\ dialmon\ program\fP 15
.br
This monitor program displays the statistics collect by \fIdialmond\fP.
.NH 2
Dialup IP Organization
.LP
The Dialup IP software is organized in a hierarchical directory structure.
The top level directories are:
.IP \fBsrc\fP 15
This directory contains the source code for the Dialup IP package.
.IP \fBdoc\fP 15
This directory contains the source code for the Dialup IP documentation.
.IP \fBsys\fP 15
This directory contains the source code for the kernel changes necessary
for Dialup IP.
.IP \fBbin\fP 15
This directory contains the Dialup IP binaries.
.IP \fBlog\fP 15
This directory is where the Dialup IP logs are kept.
This includes the overall logs as well as any transaction logs generated.
.IP \fBconfig\fP 15
This directory is where Dialup IP searches for configuration files such
as login scripts and access control files.
.LP
Note that these directories can be split into two trees;
one for software installation with the
\fBsrc\fP, \fBdoc\fP, and \fBsys\fP subdirectories,
and the other for execution with the \fBbin\fP, \fBlog\fP, and \fBconfig\fP
subdirectories.
This is described below under ``Site Preparation.''
.NH 1
Dialup IP Installation
.LP
Installing Dialup IP is relatively straightforward; you prepare for the
installation by loading the distribution media and setting site-specific
parameters.
You then build the kernel code, and finally you build the support code.
.NH 2
Site Preparation
.LP
There are two parameters that must be set prior to installing Dialup IP.
The first is the location of the Dialup IP installation directory, referred
to in this document as DIAL_BUILD.
This is directory where the Dialup IP software will be installed.
The released source specifies \fI/usr/dialupip\fP but this may be changed.
.XX
Decide on the location of the installation directory DIAL_BUILD.
.LP
You should now load the software in the DIAL_BUILD directory.
The package is distributed in \fBtar\fP format.
The full source takes less than a megabyte of space while the installation
will require about three megabytes of disk space as the system is
compiled.  
As distributed, all the files in the Dialup IP distribution are "read-only."  
You should use the \fIchmod\fP(1) command before editing any of them.
Create the DIAL_BUILD directory and extract the software with the following
commands:
.DS
mkdir DIAL_BUILD
cd DIAL_BUILD
tar -xvf \fI<release file>\fP
.DE
This will create the necessary files and directories within DIAL_BUILD.
.XX
Load the distribution tape into directory DIAL_BUILD.
.LP
The second site parameter is the execution directory, referred to as the
DIAL_ROOT directory.
This directory is used as a base for the configuration and
log files and must have \fBbin\fP, \fBconfig\fP, and \fBlog\fP subdirectories.
The released source specifies \fI/usr/dialupip\fP but this may be changed.
.XX
Decide on the location of the execution directory DIAL_ROOT.
.LP
You must change the DIAL_BUILD and DIAL_ROOT parameters in
.I DIAL_BUILD/src/Makefile.inc
and
.I DIAL_BUILD/sys/include/dialup.h
files.  
Edit these files and change the parameters to reflect
your site's configuration.  
.XX
Change the definition of DIAL_BUILD and DIAL_ROOT as needed.
.NH 2
Kernel Installation
.LP
This step modifies several system-wide header files, and hence must be done
prior to installing the support programs.
Prior to starting, you should familiarize yourself with how to configure, build,
and install a new kernel on your system.
Consult your system administrator's guide for more information.
.LP
The Dialup IP kernel code is contained in DIAL_BUILD/src/sys.
Some files are new files which must be added to your kernel's source tree,
and some contain modifications which must be made to existing files.
When modifying a kernel file, save a copy of the original using a new
extension; for example, copy \fI/sys/conf/files\fP to
\fI/sys/conf/files.pre-dip\fP before editing it.
Descriptions of all the files that need to be modified are found in the
directory DIAL_BUILD/sys/kernel_mods.
.LP
The following paragraphs describe the kernel modifications:
.IP 1.
The first step is to tell the \fIconfig\fP procedure about the new
devices.
To do this, add the following lines to \fI/sys/conf/files\fP:
.DS
.ta \w'sys/dialup.c      'u
sys/dialup.c	optional du
net/if_du.c	optional du
.DE
It is not important where in the file these lines are added, but you may want
to group them with lines of a similar format, such as next to other
\fInet/if_\fP lines.
Note that Ultrix has no \fI/sys/sys\fP directory, so use \fInet/dialup.c\fP
instead of \fIsys/dialup.c\fP.
.IP 2.
Copy your current kernel configuration file to \fI/sys/conf/DIALUP\fP.
Edit \fI/sys/conf/DIALUP\fP to add the following line:
.DS
pseudo\-device   du   3
.DE
Again, it is not important where this line appears, but you should probably
put it next to the other pseudo-devices.
The number of devices, shown above as \fI3\fP, represents the number of
Dialup IP interfaces to configure into the kernel.
One interface is allocated for each dialup destination.
Unless you running a major Dialup IP hub, three interfaces should be sufficient.
.IP
Some systems will also require changes to the entries for the serial
devices that are going to be used for Dialup IP.
For example, under Ultrix you should probably edit the \fIflags\fP
word on the \fIdz\fP device to turn \fBoff\fP the control bits for the serial
lines; Dialup IP and \fItip\fP want the modem to properly assert carrier
detect, and not have the system blindly assume it is always on.
On a Sun, it is possible to configure \fIzs\fP devices so that they may be 
used for both dial-in and dial-out connections.
In either case, refer to your relevant system manuals.
.IP 3.
The system configuration file must have pointers to the appropriate
routines to handle the Dialup IP request device, \fI/dev/dialup0\fP.
Change to the \fI/sys/vax\fP directory, or to \fI/sys/sun\fP on a Sun.
Edit \fIconf.c\fP and insert the following lines somewhere before the
declaration of the \fIcdevsw\fP variable:
.DS
/* Dialup IP request device. */
#include "du.h"
.ta \w'#endif   'u
#if	NDU > 0
int dialupopen(), dialupclose(), dialupread(), dialupioctl();
#else
.ta \w'#define dialupclose   'u
#define dialupopen	nodev
#define dialupclose	nodev
#define dialupread	nodev
#define dialupioctl	nodev
.ta \'w#endif   'u
#endif /* NDU > 0 */
.DE
.IP
Next add the routines into the \fIcdevsw\fP dispatch table.
To do this find the variable declaration and move down to the end looking
for the last used number.
Add one to this number to determine the du device number (shown below as
\fI60\fP) and add these lines:
.DS
.ta \w'dialupioctl  'u +\w'dialupclose  'u +\w'dialupread  'u +\w'nodev  'u
{
dialupopen,	dialupclose,	dialupread,	nodev,	/* 60 */
dialupioctl,	nulldev,	nulldev,	0
nodev,	nodev,	0,
}
.DE
Note that on some systems, the exact format of the \fIcdevsw\fP entries
might be different.
The important part is to get the function declarations for the major
routines in the right place, and put null pointers and no-ops to fill
out the entries.
You might want to double-check against your system's \fI<sys/conf.h>\fP
header file.
.IP 4.
Create the request device.
Note the number used in the dispatch table above, and execute the following
commands:
.DS
/etc/mknod /dev/dialup0 c \fI60\fP 0
chmod 400 /dev/dialup0
chown root /dev/dialup0
.DE
.IP 5.
The ``du'' line discipline must be added to the terminal driver.
On Ultrix, change to the \fI/sys/data\fP directory and edit
\fItty_conf_data.c\fP
On a Sun, the file is \fItty_conf.c\fP in the \fI/sys/sys\fP directory.
Look for the \fIlinesw\fP variable, and add the following declarations
before it:
.DS
#include "du.h"
.ta \w'#endif  'u
#if	NDU > 0
int dutopen(), dutclose(), dutinput(), dutioctl(), dutstart(), dutmodem();
#endif	/* NDU > 0*/
.DE
Next add these routines into the dispatch table.  You should use the next available
line discipline number, shown below as \fI8\fP:
.DS
#if	NDU > 0
	dutopen, dutclose, nodev, nodev, dutioctl,
	dutinput, nodev, nulldev, dutstart, dutmodem,	/* \fI8\fP DUDISC */
#else
	nodev, nodev, nodev, nodev, nodev,
	nodev, nodev, nodev, nodev, nodev,
#endif	/* NDU */
.DE
.IP 6.
Next change to the \fI/sys/h\fP directory and edit the \fIioctl.h\fP file.
Look for the definition of line disciplines (such as the #define for
\fINTTYDISC\fP) and add the following line:
.DS
#define DUDISC    \fI8\fP     /* Dialup IP */
.DE
Use the same number that you specified when you edited
the \fIlinesw\fP variable above.
.IP
You also have to add the new ioctl #define's that will be used to
control the devices.
Look for a block of #define's that relate to other interfaces, such as
\fISIOCSIFMETRIC\fP and find the last number in the block.
Assuming it is \fI43\fP, add the following lines after that block:
.DS
/* dialup interface ioctls */
.ta \w'define SIOCGSOFTFLAGS  'u +\w'_IOWR(i,49,struct ifreq)   'u
#define SIOCSATIMEO	_IOWR(i,44,struct ifreq)	/* Set Active timer */
#define SIOCGATIMEO	_IOWR(i,45,struct ifreq)	/* Get Active timer */
#define SIOCSWTIMEO	_IOWR(i,46,struct ifreq)	/* Set Wait timer */
#define SIOCGWTIMEO	_IOWR(i,47,struct ifreq)	/* Get Wait timer */
#define SIOCCLEARQ	_IOWR(i,48,struct ifreq)	/* Clear interf. queue */
#define SIOCSSOFTFLAGS	_IOWR(i,49,struct ifreq)	/* Set soft flags */
#define SIOCGSOFTFLAGS	_IOWR(i,50,struct ifreq)	/* Get soft flags */
#define SIOCSSOFTTIMER	_IOWR(i,51,struct ifreq)	/* Set soft timer */
#define SIOCFAILCALL	_IOWR(i,52,struct ifreq)	/* Mark a failed call */
#define SIOCGIPKTS	_IOWR(i,53,struct ifreq)	/* get input packets */
#define SIOCGOPKTS	_IOWR(i,54,struct ifreq)	/* get output packets */
#define SIOCBRINGUP	_IOWR(i,55,struct ifreq)	/* Bring up interface */
#ifndef SIOCGIFMTU
#define SIOCSIFMTU	_IOW(i, 56, struct ifreq)	/* set if_mtu */
#define SIOCGIFMTU	_IOWR(i,57, struct ifreq)	/* get if_mtu */
#endif /* SIOCGIFMTU */
.DE
The ioctl definitions may have different numbers on your machine.
It is \fBcrucial\fP that unique numbers get assigned!
.IP
On some systems the user directory, \fI/usr/include/sys\fP is linked to the
system directory \fI/sys/h\fP, while on other systems there are two separate
copies.
Verify that the file in \fI/usr/include/sys\fP has the changes you just made,
and if it doesn't, copy the \fIioctl.h\fP file from \fI/sys/h\fP to
\fI/usr/include/sys\fP.
.IP 7.
Copy the Dialup IP drivers into the kernel's source tree:
.DS
cp DIAL_BUILD/sys/sys/dialup.c /sys/sys/.
cp DIAL_BUILD/sys/net/if_du.[ch] /sys/net/.
.DE
Remember that on Ultrix you must use \fI/sys/net\fP instead of \fI/sys/sys\fP.
As you did with the ioctl.h file, make sure that the new file \fI/sys/net/if_du.h\fP
appears in directory \fI/usr/include/net\fP.
Depending on the system, you may need to make a copy or a link.
.IP
Note that \fIif_du.c\fP includes some header files which do not exist on a Sun.
Although they are surrounded by #ifdef's, the Sun ``make depend'' may have
problems and insert false dependencies into the Makefile.
If this happens, edit \fIif_du.c\fP and comment out Vax-specific
#include files.
.XX
Change the kernel files as described above.
.IP 8.
Create a directory for the new kernel, \fI/sys/DIALUP\fP.
This directory will be used to build the Dialup IP kernel.
.DS
mkdir /sys/DIALUP
.DE
.IP 9.
Configure and build a new kernel by using the following commands:
.DS
cd /sys/conf
/etc/config DIALUP
cd /sys/DIALUP
make depend
make
.DE
Save the current kernel and copy \fI/sys/DIALUP/vmunix\fP to \fI/vmunix\fP
and reboot your system.
.XX
Build and install the new kernel.
.NH 2
Support Program Installation
.LP
The support programs, header files, and utility libraries are all located
in DIAL_BUILD\fI/src\fP.
The file DIAL_BUILD\fI/Makefile.inc\fP is an include file used by all the
Makefiles within the \fIsrc\fP directory.
.LP
If the \fImake\fP on your system can't process ``include'' statements,
then the utility \fIfixmake\fP program should be used.
Compile it and run it in each source directory by doing the following:
.DS
cd DIAL_BUILD/src/dulib
cc -o fixmake fixmake.c
cd diald ; ../fixmake ; cd ..
cd dialmon ; ../fixmake ; cd ..
cd dulib ; ../fixmake ; cd ..
cd dumisc ; ../fixmake ; cd ..
.DE
This procedure must be done whenever any \fIMakefile\fP or the file
\fIMakefile.inc\fP changes.
.XX
Run \fIfixmake\fP if necessary.
.LP
The support programs may be installed individually, or may be built all at one time.
If you wish to install all the utilities, you may skip to the ``easy" method listed below.
.LP
If you are going to install each support program manually, 
the utility library must be installed.
To do this, type the following:
.DS
cd DIAL_BUILD/src/lib
make install
make clean
.DE
You can now change to each of the source directories, \fIdiald\fP,
\fIdialmon\fP, and \fIdumisc\fP and do ``make.''
This will build the dialing daemon \fIdiald\fP,
the monitoring programs, and the support programs in turn.
Within each source directory ``make install'' will install the programs
in DIAL_BUILD/bin, ``make lint'' will run \fIlint\fP(1) over the sources,
and ``make clean'' will remove all object files and programs.
If you install the system in pieces this way, you must first do the following:
.DS
cd DIAL_ROOT
mkdir log config bin
cd log
touch call.log dial.log
cd ..
cp DIAL_BUILD/config/* config
.DE
.LP
The ``easy'' way to install all of the support programs
is to change to the \fIsrc\fP directory and just do ``make install'':
.DS
cd DIAL_BUILD/src
make install
make clean
.DE
The top-level Makefile will build the utility library, the directory
structure, and then each of the support programs in turn.
.XX
Build and install the support programs.
.LP
One of the support programs must be setuid root before it will run; the Makefile
tries to do the necessary \fIchown\fP(8) and \fIchmod\fP(1) commands.
If you did not run the \fImake\fP as root, then these commands will
fail (but the \fImake\fP will continue.)
In that case, once the system is compiled and installed, execute the
following commands as root:
.DS
cd DIAL_ROOT/bin
chown root dudisc
chmod 4755 dudisc
.DE
.XX
Make sure that \fIdudisc\fP has the setuid bit set and is owned by root.
.LP
Once the support programs are installed, you should create links to the Dialup IP
login shell, \fIdudisc\fP.
This is done by running the \fIduinstall\fP program.
You will need one link for each system that will have dial-in access to
your system.
If you are running a gateway for many Dialup IP sites, you will have many
du interfaces and many sites calling in.
In most cases there will be one or two sites and one or two devices.
The script prompts for the number of devices that are configured into
the kernel:
.DS
Please enter the number of network devices the kernel
has been generated to hold.  This number must match the value given in
du.h for the constant NDU.

How many du network devices to install? \fI3\fP
Linking "/usr/dialupip/bin/dudisc" to "/usr/dialupip/bin/dudisc_dua0"
Linking "/usr/dialupip/bin/dudisc" to "/usr/dialupip/bin/dudisc_dua1"
Linking "/usr/dialupip/bin/dudisc" to "/usr/dialupip/bin/dudisc_dua2"

duinstall:  Created 3 network devices.
.DE
.XX
Run duinstall to create the necessary links.
.NH 1
Dialup IP Configuration
.LP
Before you can use Dialup IP, you must perform these basic configuration steps:
preparing the dialup interfaces, configuring the dial-out connections, and
configuring the dial-in connections.
The necesary steps are described in the following sections.
Note that if you do not have any connections of a particular mode (e.g.
dial-in), you may skip that part of the configuration.
There are two additional steps that may be needed at some sites: changing
the IP routing table, and enabling the dialup monitor.
These instructions are also supplied below and may be done once Dialup IP
is running.
.NH 2
Setting up the dialup interfaces
.LP
Connections to remote sites are made via the dialup (``du'') interfaces.
Each interface forms a point-to-point IP connection to a specific remote site.
An interface can be configured to support only dial-in, only dial-out,
or both types of connections.
Before the interfaces can be configured, they must be created via the
\fIduattach\fP command.
This program adds ``du'' interfaces to the system.
The number of interfaces created is specified during Dialup IP installation.
Login or \fIsu\fP(8) to root and run:
.DS
duattach /dev/dialup0
.DE
.LP
After running this command, you should confirm the results by entering
a ``netstat \-i \-n'' command:
.DS
.ta \w'Name  'u +\w'1500  'u +\w'Network  'u +\w'128.89.0.94  'u +\w'27179  'u +\w'Ierrs  'u +\w'Opkts  'u +\w'Oerrs  'u +\w'Collis  'u
Name	Mtu	Network	Address	Ipkts	Ierrs	Opkts	Oerrs	Collis
qe0	1500	128.89	128.89.0.94	27179	0	25210	0	1337
lo0	1536	127	127.0.0.1	2884	0	2884	0	0
dua0*	1006	none	none	0	0	0	0	0
dua1*	1006	none	none	0	0	0	0	0
.DE
You should see one or more ``du'' interfaces.
Note that if you are on a Sun, these interfaces will not show up until after
\fIifconfig\fP has been run in the next step.
.XX
Run duattach to create the network interfaces.
.LP
You should now configure each interface as a point-to-point IP link.
You will need a unique IP address for each end of the link.
For example, CSNET uses network 192.31.242 for its
Dialup IP network and assigns to each site a pair of addresses on this network
to use for their link.
One address is for the host at the site and the
other address is given to the \fIrelay2.cs.net\fP system.
.LP
A site assigned the address 192.31.242.5 would use the following command
to configure their interface to connect to the \fIrelay2.cs.net\fP system
at 192.31.242.6:
.DS
/etc/ifconfig dua0 192.31.242.5 192.31.242.6
.DE
.LP
You should next verify that the interfaces are correctly configured.
The ``netstat \-i \-n'' command should display information similar to the
following:
.DS
.ta \w'Name  'u +\w'1500  'u +\w'192.31.242  'u +\w'192.31.242.5  'u +\w'327179  'u +\w'Ierrs  'u +\w'Opkts  'u +\w'Oerrs  'u +\w'Collis  'u
Name	Mtu	Network	Address	Ipkts	Ierrs	Opkts	Oerrs	Collis
qe0	1500	128.89	128.89.0.94	27179	0	25210	0	1337
lo0	1536	127	127.0.0.1	2884	0	2884	0	0
dua0	1006	192.31.242	192.31.242.5	0	0	0	0	0
dua1*	1006	none	none	0	0	0	0	0
.DE
.XX
Configure each dialup network interface with appropriate IP addresses.
.LP
Once you have determined the correct \fIduattach\fP and \fIifconfig\fP
commands, edit your system start-up scripts (such as \fI/etc/rc.local\fP)
so that these commands are run at boot time.
.XX
Add the interface configuration commands to your system startup file.
.NH 2
Configuring Dial-out Connections
.LP
Dial-out connections are automatically initiated by the \fIdiald\fP daemon
whenever there is a datagram queued for a remote Dialup IP site.
You must have the \fIdiald\fP daemon started at system startup.
Add the following line to the end of your \fI/etc/rc.local\fP file
(substituted the correct value for DIAL_ROOT):
.DS
DIAL_ROOT/bin/diald & (echo -n ' diald') >/dev/console
.DE
\fIDiald\fP reads a configuration file \fI/etc/diald.conf\fP to determine
the remote sites that are connected.
You must create the \fIdiald\fP configuration file as follows:
.DS
touch /etc/diald.conf
chmod 400 /etc/diald.conf
chown root /etc/diald.conf
.DE
.XX
Add \fIdiald\fP to the system startup commands and create the configuration
file.
.LP
For each remote site, you must add an entry to the configuration file.
The format of these entries is documented in \fIdiald.conf\fP(5).
The minimum entry consists of the interface name, the site name,
the tty port to used for dialing out, and the name of script file.
You may also want to place a transaction log in the entry as this will
aid in debugging.
.XX
Add an entry to \fI/etc/diald.conf\fP for each dial-out connection.
.LP
For each remote site, you must also write a script to log on to the remote
system.
The mechanics of making the call are controlled by a scripting language
documented in \fIdiald-script\fP(5).
The script file should be in directory DIAL_ROOT/config and readable by
\fIdiald\fP.
You will find sample script files in the DIAL_ROOT/config directory which
may be copied and modified for your environment.
Note that the script files may be nested and have parameters.
For example, the file \fItb-unix.script\fP calls the \fItb.script\fP script
file to dial out using a Telebit Trailblazer modem,
and then calls \fIunix-login.script\fP to log in to a Unix system.
When specifying the script file field in the \fIdaild.conf\fP,
you may include parameters to be passed to the script.
For example, the following script-file field will call the trailblazer script
with three parameters:
.DS
tb-unix.script 16175551212 yourname yourpass
.DE
.XX
Create the script file for each dial-out connection.
.LP
Once you have the connection working, you may want to add an access control
file.
This file can specify the conditions under which \fIdiald\fP will initiate
a connection.
It is possible to prevent certain systems from initiating requests to
long-distance Dialup IP sites, as well as allowing only higher-level IP
protocols such as TCP to start a connection.
The access-file is the last field in a \fIdiald.conf\fP entry and if not
specified will allow any queued data to initiate the connection regardless
of source, destination, or protocol.
See \fIdiald-access\fP(5) for more information on access controls.
.XX
Add access controls to any dial-out connections needing them.
.NH 2
Configuring Dial-in Connections
.LP
Each site using a dial-in connection must have a username to access the local
system.
The username must be set up in particular manner if Dialup IP is to work
correctly.
Create the entries in \fI/etc/passwd\fP as normal, only specify that the home
directory be DIAL_ROOT and determine the login shell by appending their
interface name to "DIAL_ROOT/bin/dusdisc_".
.LP
For example, a site which connects via interface ``dua3'' should have
DIAL_ROOT/bin/dudisc_dua3 as their login shell.
If the DIAL_ROOT is \fI/usr/dialupip\fP and the site's username ``dialinabc'',
then the complete \fIpasswd\fP entry would be:
.DS
\fIdialinabc:passwd:uid:gid:ABC Dialup IP:/usr/dialupip:/usr/dialupip/bin/dudisc_dua3\fP
.DE
Use values appropriate at your site for the passwd, uid, and gid fields.
.XX
Add a dialup username for each dial-in connection.
.LP
In order for a remote system to log in and start the dialup protocol, you
must have a \fIgetty\fP process running on the serial port that they will be
using.
If a serial port is going to be used only for Dialup IP, then the
\fIdulogin\fP program can be configured on that line to provide faster setup
than the standard \fIlogin\fP(1) program.
If \fIdulogin\fP is used, each dial-in user must also be a member of
the ``dialupip'' group.
For more details, see \fIdulogin\fP(1).
.NH 2
Changing the IP Routing table
.LP
The ``netstat \-r \-n'' command should return information similar to the
following:
.DS
Routing table
.ta \w'192.31.242.6  'u +\w'192.31.242.5  'u +\w'Flags  'u +\w'Refcnt  'u +\w'Use  'u +\w'Interface  'u
Destination	Gateway 	Flags	Refcnt	Use	Interface
127.0.0.1	127.0.0.1	UH	2	28	lo0
192.31.242.6	192.31.242.5	UH	0	0	dua0
.DE
.LP
This indicates that you may reach host 192.31.242.6 via your ``dua0''
interface.
You can modify this table using the \fIroute\fP(8) command.
You will probably want to add routes for the destinations available via your
dialup IP link.
You can do this for each destination individually or you can set a default
route for all non-local traffic.
Note that the remote system must be configured to forward any non-local
traffic you that send it.
.NH 2
Enabling the Dialup IP monitor
.LP
The Dialup IP package provides a full-screen monitor, \fIdialmon\fP, which
can display various traffic statistics.
Statistics available include cumulative and average line usage measured
in packets and bytes.
A collection program, \fIdialmond\fP, gathers these statistics from the
Dialup IP devices and passes them back to the monitor program via
the tcp service ``dip-status.''
The \fIdialmond\fP program is started by \fIinetd\fP when the monitor
attempts to connect to the ``dip-status'' service.
You must add this new service to the \fI/etc/services\fP file:
.DS
dip-status	190/tcp		# dialmond server
.DE
.LP
You must also add the following line to the \fI/etc/inetd.conf\fP file so
that \fIdialmond\fP will be automatically started:
.DS
dip-status      stream tcp nowait       DIAL_ROOT/bin/dialmond
.DE
You will also have restart or signal your \fIinetd\fP(8) so it will pick up the 
new configuration.  For sites that do not run inetd, the dialdmond program may be 
started from the system startup commands. Refer to \fIdialmond\fP(8) for details.
For more information on the Dialup IP monitor, refer to \fIdialmon\fP(8).
.NH 1
Dialup IP Troubleshooting
.LP
While the Dialup IP package was designed to be easy to use, there are still
numerous problems that can be encountered during normal operation.
This section is an attempt to list the most common problems encountered and
provide some assistance in resolving them.
Also included is a summary of the troubleshooting tools available in
Dialup IP such as log files and utility programs.
.NH 2
Common Problems
.IP Unable\ to\ create\ dialup\ interfaces 10
.br
This occurs when the kernel code has not been installed, when the
\fI/dev/dialup0\fP device has not been created, or if the \fIduttach\fP
command is not run by root.
.IP Dial-out\ modem\ not\ responding 10
.br
This is often a cable problem between the modem and the serial port.
It can also occur if the modem does not perform auto-baud detection and
is not set to the speed listed in \fIdiald.conf\fP.
You should verify proper modem operation by using \fItip\fP(1).
.IP Cannot\ connect\ to\ remote\ system 10
.br
This can be caused by a number of conditions:  no \fIdiald.conf\fP entry
for the interface, no username of the remote system, remote username not
set up correctly, or bad script file.
You should enable a transaction log for this interface and examine the log
for the exact cause.
.IP Dial-in\ connections\ fail 10
.br
The most probable reason is a faulty script file being used at the remote site.
A transaction log (as described above) from the remote system can show this.
If that is not the problem, the the local configuration can be confirmed by
logging in under the assigned username and verifing that it works and
the ``Dialup IP connected'' message is issued.
.NH 2
Tools for Troubleshooting Dialup IP
.IP dial.log 15
This file is in directory DIAL_ROOT/log and records all log messages
relating to Dialup IP connections.
The detail of information recorded about dial-out connections is controlled
by the debug level of the \fIdiald\fP daemon.
The information recorded for dial-in connections is fixed.
This log is the first place to look if there is a problem with Dialup IP.
.IP call.log 15
This file is also in the DIAL_ROOT/log directory, but is used primarily
for accounting purposes.
Each successful dial-out call is recorded along with length and amount of
data transferred.
.IP transction\ logs 15
These logs are created for dial-out connections if specified in the
\fI/etc/diald.conf\fP entry for the interface.
These are very useful for tracking script-file progress.
There are several levels of logging available; see \fIdiald.conf\fP for
more details.
.IP tip(1) 15
This program will connect to a serial port and thus allow easy checkout
of the port, cable, and modem.
You may have to change the tty definition before debugging dial-in ports
since getty cannot be active on the line.
See \fIremote\fP(5) for information on configuring and using tip.
.IP duioctl(8) 15
This program can get and set the timers for a given dialup IP interface,
and can be used to manually initiate dial-out connections for testing.
See \fIduioctl\fP(8) for details.
.bp
.SH
Appendix A:  Upgrading from Earlier Releases
.LP
The configuration file formats for release 2.0 are very different from
the formats used by previous releases.
Most notably, the individual ``\fIhost\fP.conf" files are gone, replaced by
a combination of a single \fI/etc/diald.conf\fP file that gives the main
configuration information, and an optional series of ``\fIdiald\fP.access''
files that provide access control on dialing out.
.LP
In addition, it is now possible to provide parameters when specifying the
dialing script.
This can greatly reduce the number of files that must be maintained while
running Dialup IP.
For example, in prior releases the script file for site abc (\fIabc.conf\fP) would 
contain the line:
.DS
script abc.script
.DE
while \fIabc.script\fP would contain the single line:
.DS
use tb-to-unix.script \fIphonenumber\fP \fIpassword\fP
.DE
This can be replaced by the single ``script-file'' field in the
\fI/etc/diald.conf\fP file.
.DS
tb-to-unix.script \fIphonenumber\fP \fIpassword\fP
.DE
.LP
To help convert the configuration files, a utility program, located in the
\fIdiald\fP source directory, has been provided.
To use it, you must first compile it:
.DS
cd DIAL_BUILD/src/diald
cc -o convert convert.c
.DE
You should then change to your existing configuration directory and do the
following:
.DS
cd /usr/dialupip/config
DIAL_BUILD/src/diald/convert
mkdir SAVE
mv *.conf SAVE
.DE
This will create a sample \fIdiald.conf\fP file for all configured
hosts and template ``diald-access'' files for each interface.
Once you are sure the new files are correct, and after you have made any
other edits (such as removing unneeded script files as described above),
you should move \fIdiald.conf\fP to the \fI/etc\fP directory.
.bp
.SH
Appendix B:  Modem Considerations
.LP
You will want to set your modem so that it does not respond to XON/XOFF,
and so that it will briefly drop Data Set Ready (DSR) when the modem
loses carrier.
The following table shows several sample configurations for various modems:
.DS
\fITrailblazer, Dialout\fP

E1 F1 M1 Q0 T V1 X1
S00=001 S01=000 S02=043 S03=013 S04=010 S05=008 S06=002 S07=040 S08=002 S09=006
S10=007 S11=070 S12=050
S45=255 S47=004 S48=001 S49=000
S50=000 S51=004 S52=001 S53=000 S54=003 S55=000 S56=017 S57=019 S58=000 S59=000
S60=000 S61=045 S62=003 S63=001 S64=000 S65=000 S66=001 S67=000 S68=000
S90=000 S91=000 S92=000 S95=000
S100=000 S101=000 S102=000 S104=000
S110=001 S111=255 S112=001
S121=000

.DE
.DS
\fITrailblazer, Dial-in\fP

E1 F1 M1 Q0 T V1 X1
S00=001 S01=004 S02=043 S03=013 S04=010 S05=008 S06=002 S07=040 S08=002 S09=006
S10=007 S11=070 S12=050
S45=255 S47=004 S48=000 S49=000
S50=000 S51=004 S52=001 S53=004 S54=003 S55=003 S56=017 S57=019 S58=000 S59=000
S60=000 S61=045 S62=003 S63=001 S64=001 S65=000 S66=001 S67=001 S68=000
S90=000 S91=000 S92=000 S95=002
S100=000 S101=000 S102=000 S104=000
S110=255 S111=255 S112=001
S121=000

.DE
.DS
\fIMicrocom, Dial-out\fP

AT&F
AT&C0
AT%G0
AT&W

.DE
