/*
**  For systems whose make doesn't handle "include filename" syntax, this
**  program reads in "Makefile" and creates "makefile".
**
**  Usage:
**	fixmake [-i <filename>] [-o <filename>]
**		-i <filename>	Set input filename, default is "Makefile"
**		-o <filename>	Set output filename, default is "makefile"
**
**  Copyright (c) 1991 Bolt Beranek and Newman, Inc.
**  All rights reserved.
**
**  Redistribution and use in source and binary forms are permitted
**  provided that: (1) source distributions retain this entire copyright
**  notice and comment, and (2) distributions including binaries display
**  the following acknowledgement:  ``This product includes software
**  developed by Bolt Beranek and Newman, Inc. and CREN/CSNET'' in the
**  documentation or other materials provided with the distribution and in
**  all advertising materials mentioning features or use of this software.
**  Neither the name of Bolt Beranek and Newman nor CREN/CSNET may be used
**  to endorse or promote products derived from this software without
**  specific prior written permission.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
**  WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/
#include <stdio.h>

#define SUCCESS		0
#define FAILURE		1

static char	*progname;
extern char	*optarg;
extern int	optind;



static int
process_file(in_name, outfile)
    char	*in_name;
    FILE	*outfile;
{
    char	buff[BUFSIZ];
    FILE	*F;
    char	name[BUFSIZ];

    /* Open the input file */
    if ((F = fopen(in_name, "r")) == NULL) {
	perror(in_name);
	fprintf(stderr, "Can't open for reading.\n");
	return FAILURE;
    }

    /* While input lines exist, read them */
    while (fgets(buff, sizeof buff, F)) {
	/* Is this an 'include' line? */
	if (sscanf(buff, "include%*[ \t]%[^ \t\n]", name) == 1) {
	    /* Process the file and try to fix include the file */
	    if (process_file(name, outfile) == FAILURE)
		return FAILURE;
	    continue;
	}
	/* Otherwise just copy to the output */
	fprintf(outfile, buff);
    }

    /* Close the input file and return success */
    (void)fclose(F);
    return SUCCESS;
}


static void
usage()
{
    fprintf(stderr, "%s [-i inputfile] [-o outputfile]\n", progname);
    exit(1);
}


main(argc, argv)
    int		argc;
    char	*argv[];
{
    FILE	*F;
    char	*in_name;
    char	*out_name;
    int		i;

    /* Set defaults. */
    progname = argv[0];
    in_name = "Makefile";
    out_name = "makefile";

    /* Parse flags. */
    while ((i = getopt(argc, argv, "i:o:")) != EOF)
	switch (i) {
	default:		/* Error in command arguments	 */
	    usage();
	    /* NOTREACHED */
	case 'i':		/* Set input filename		 */
	    in_name = optarg;
	    break;
	case 'o':		/* Set output filename		 */
	    out_name = optarg;
	    break;
	}

    /* Parse the parameters. */
    argc -= optind;
    argv += optind;
    if (*argv)
	usage();

    /* Open the output filename */
    if ((F = fopen(out_name, "w")) == NULL) {
	perror(out_name);
	fprintf(stderr, "Can't open for writing.\n");
	exit(1);
    }

    /* Run. */
    i = process_file(in_name, F);

    /* Close the output file */
    (void)fclose(F);
    exit(i);
    /* NOTREACHED */
}
