/*
**  Copyright (c) 1991 Bolt Beranek and Newman, Inc.
**  All rights reserved.
**
**  Redistribution and use in source and binary forms are permitted
**  provided that: (1) source distributions retain this entire copyright
**  notice and comment, and (2) distributions including binaries display
**  the following acknowledgement:  ``This product includes software
**  developed by Bolt Beranek and Newman, Inc. and CREN/CSNET'' in the
**  documentation or other materials provided with the distribution and in
**  all advertising materials mentioning features or use of this software.
**  Neither the name of Bolt Beranek and Newman nor CREN/CSNET may be used
**  to endorse or promote products derived from this software without
**  specific prior written permission.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
**  WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/
#define MAXHOSTS	25		/* Number of known hosts	*/
#define MAXDEVLEN 	8		/* Length of a device name	*/
#define MAXDEVICES	8		/* Number of devices/config	*/
#define MAXFIELDSIZE	30		/* Length of script parameters	*/
#define OPEN_TIMEOUT	10		/* How long to wait for modem	*/
#define INACT_UNDEF	(-1)		/* No inactivity time defined	*/


#ifndef	MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif	/* MAXHOSTNAMELEN */


/*
**  Get the word and bit within the REMOTE.Protocols bitarray (see below).
**  Assumes 32-bit longs.
*/
#define P_WORD(i)		((i) >> 5)
#define P_BIT(i)		(1L << (i & 31))


/*
**  Return codes from makecall.
*/
#define CALL_SUCCESS	 0	/* Call was made successfully		*/
#define CALL_COMPLETED	 1	/* Call was completed normally		*/
#define CALL_NOMODEM	 2	/* No modem available			*/
#define CALL_PERMISSION  3	/* File or device access/protection problem*/
#define CALL_FAIL	 4	/* Call failed (busy for example)	*/
#define CALL_NOCONNECT   5	/* No connection at far end		*/
#define CALL_NOSETUID	 6	/* Program does not have setuid root	*/
#define CALL_IOCTL_ERR	 7	/* Problem setting IOCTL parameters	*/
#define CALL_BAD_IF	 8	/* Interface name is mis-formed		*/
#define CALL_TTYTIMEOUT	 9	/* Open on Modem line timed out		*/
#define CALL_NOSOCKET	10	/* Unable to get a socket		*/


/*
**  Configuration data for a remote host.
*/
typedef struct _REMOTE {
    char		Device[MAXDEVLEN];	/* du device to use	*/
    u_long		Times[7];		/* calling times	*/
    u_long		Protocols[8];		/* Valid protocols	*/
    int			AllowCount;
    int			DisallowCount;
    struct in_addr	AllowTo[MAXHOSTS];	/* Legal destinations	*/
    struct in_addr	DisallowFrom[MAXHOSTS];	/* Bad sources		*/
    char		Sitename[128];		/* Host name		*/
    char		Script[MAXPATHLEN];	/* Dialing script	*/
    char		Transcript[128];	/* Dialing transcript	*/
    int			Transtyle;		/* Transcript style	*/
    int			FieldCount;		/* Number of parameters	*/
    char		FieldData[128];		/* Field storage	*/
    int			Fields[9];		/* Script parameters	*/
    char		Lines[MAXDEVICES][MAXDEVLEN];	/* Lines to use	*/
    int			Speeds[MAXDEVICES];	/* Line speed masks	*/
    int			Inactivity;		/* Inactivity timeout	*/
} REMOTE;

#define TS_LOW		0			/* Low-level transcript	*/
#define TS_HIGH		1			/* Hi-level transcript	*/

extern REMOTE		*findconfig();
extern void		failcall();

extern char		*optarg;
extern int		optind;
extern int		errno;
extern char		*ctime();
extern char		*inet_ntoa();
extern char		*malloc();
extern char		*strchr();
extern char		*strcpy();
extern char		*strncpy();
extern char		*strrchr();
extern char		*strtok();
extern time_t		time();
extern unsigned int	sleep();
extern void		exit();
extern void		free();
