.\" $Header: implement.ms,v 2.0 91/01/11 17:12:01 rsalz Exp $
.\"  Copyright (c) 1991 Bolt Beranek and Newman, Inc.
.\"  All rights reserved.
.\"
.\"  Redistribution and use in source and binary forms are permitted
.\"  provided that: (1) source distributions retain this entire copyright
.\"  notice and comment, and (2) distributions including binaries display
.\"  the following acknowledgement:  ``This product includes software
.\"  developed by Bolt Beranek and Newman, Inc. and CREN/CSNET'' in the
.\"  documentation or other materials provided with the distribution and in
.\"  all advertising materials mentioning features or use of this software.
.\"  Neither the name of Bolt Beranek and Newman nor CREN/CSNET may be used
.\"  to endorse or promote products derived from this software without
.\"  specific prior written permission.
.\"
.\"  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
.\"  WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
.\"  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.TL
Implementation of Dialup IP 2.0
.AU
Rich Salz
.AI
BBN Systems and Technologies
Cambridge, MA  02139
<rsalz@bbn.com>
.AU
Leo Lanzillo
.AI
CSNET Coordination and Information Center
BBN Systems and Technologies
Cambridge, MA  02139
.NH 1
Introduction
.LP
The Dialup IP software package provides full IP support over dialup
phone lines.
It runs on systems based on the 4.3BSD kernel, and requires a modem
connected to a serial port on the machine.
.LP
The Dialup IP device driver is based on a modified SLIP driver originally
written by Rick Adams and distributed with 4.3BSD.
The major difference between SLIP and Dialup IP is that the Dialup IP
disconnects the phone when not in use.
This helps to keep costs down at the price of making the package more
complicated.
Before sending any data, the driver must verify that the line is up
to the remote site, or make a connection if none currently exists.
Similarly, the driver must notice when there is no data to be sent,
and initiate the break-down of the call.
.NH 1
Software Components
.LP
There are kernel and user components to the software package.
The kernel code includes the Dialup IP code and a request device
used to determine when a connection should be initiated.
The user-level components include programs to set up network interfaces
and make the necessary calls.
The dialing program reads configuration files specifying network
devices and calling information and restrictions.
.NH 1
Routing
.LP
The Dialup IP software does not use any special routing to communicate with
remote hosts.
A ``du'' software device allocated for each remote destination, and the
existing IP layer takes care of routing packets to the correct device.
.LP
When the device driver receives a packet for transmission, it faces two
conditions:  either the link is up and the packet can be sent, or
the link is down and the packet must be queued until the link comes up.
Either host on the point-to-point link can bring the link up.
.NH 1
Flow of Control
.LP
The various software components and their interaction are discussed below.
.NH 2
Kernel Code
.LP
If the link is not up, the Dialup IP driver signals a user program which
attempts to bring the line up.
It will then notify the Dialup IP driver that the link is up and ready for
use.
The Dialup IP driver notifies the daemon by writing data to the input
buffer of the \fI/dev/dialup0\fP device and waking up any process waiting
on that buffer.
The data sent contains the interface name, a ``sockaddr' with the address
of the remote host, and the IP header of the first packet destined for
that host.
.NH 2
User Code
.LP
There are two halves to the user code.
One half is used on the initiating, or dialout, end, and the other half
is used on the receiving, or dialin, end.
.LP
On the dialout host the program \fIdiald\fP continually reads from
\fI/dev/dialup0\fP waiting for requests to initiate calls.
When request data comes in, it spawns a child to make the call.
The child reads the config and dialing script files and tries to negotiate
a login to the remote host.
.LP
On the dialin host there is a special login shell which is used to bring
up the Dialup IP line discipline on the incoming line.
.NH 3
Access Control
.LP
Before waiting for requests, \fIdiald\fP reads a configuration file that
lists the each ``du'' interface and the names the the tty ports to use,
and script to execute.
An access file can also be named, limiting the circumstances under which a
call will be initiated.
Calls can be limited based on any combination of the following factors:
.DS
Source host or network
Destination host or network
Time of day
Protocol
.DE
.NH 2
Call Setup
.LP
After reading the packet, \fIdiald\fP finds the entry for the given interface.
It then performs security checks on the protocol, source and destination,
and time of day.
If the request is legitamite, it forks and the child runs the script to
dial the phone number, and go through the login sequence.
.LP
At the remote (dialin) end, a special shell is invoked (normally called
\fIdudisc\fP, although other packages are available), and there can be
further handshaking between the dialing process and the shell.
Once the sequence is complete the both the child and the remote
special shell do \fIioctl\fP's to bring their end of the interface up,
and to change the line discipline on the tty.
Both processes then sleep until the line is dropped, at which time they
clean up and exit.
.LP
Because the dialing process and the special shell sleep instead of dying,
UNIX believes the tty port is still in use.
This prevents other \fIgetty\fP's from running on the passive end and
prevents the line discipline from being reset on both ends.
.NH 2
Data Transmission
.LP
Once the dialing process and remote shell have completed their \fIioctl\fP
calls, the line is ready for data transmission.
.NH 3
Output
.LP
Dialup IP is implemented as an interface to the IP layer; the IP layer
determines on which interface a particular destination can be reached
and transmits the packet out that interface via the \fIifnet\->if_output\fP
routine.
Similarly, Dialup IP \fIioctl\fP's and initialization routines are reached
via the \fIifnet\fP structure.
The Dialup driver's output routine simply verifies that the line is up
and then transmits the packet.
The output routine sends frame characters to delineate the packet.
.LP
The framed packet is transmitted by placing each character into the clist
associated with the tty device.
The hardware device driver asynchronously processes the characters from the
clist.
.NH 3
Input
.LP
On input, data is received by the hardware device.
Since the data is coming in over a tty line, there is a tty structure
for each connection.
This structure contains a pointer to the line discipline which should be used
to process the incoming characters.
When the connection was established, the line discipline on the port was
set up to refer to the Dialup IP driver.
Instead of doing character processing, it collects characters into packets,
does simple header checking and enqueues the packets in the IP input queue.
.NH 2
Call Tear-Down
.LP
In order to close down phone calls when there is no data to send, there are
activity timers on the interface which time out inactive lines and
failed connections.
These are two separate types of failures.
.NH 3
Failed Calls
.LP
The dialing programs recognize a number of reasons why a call can fail,
including but not limited to:
.DS
Configuration file problems such as a bad port or device
Authorization failure
Problems placing a phone call such as line busy
Failure to run the script correctly
.DE
.LP
If such a failure occurs, a log message is reported and the process exits;
the \fIioctl\fP's to change the line discipline and to mark the interface
up are never executed.
As a result, outbound packets collect in the queue and eventually the
Dialup IP driver will time out waiting for the interface to come up.
.NH 3
Timeouts
.LP
The Dialup IP code can recognize timeouts both on connection attempts and
on line activity.
Once it has notified \fIdiald\fP that it has data to send out, the Dialup
driver waits for the interface to come up.
If the interface isn't marked as up within a specified time, the driver
will clear the interface's output queues and reset the state of the interface.
.LP
A similar sequence occurs if the Dialup IP code detects that there has not
been traffic on the interface for some length of time.
When such a timeout occurs, a SIGHUP is sent to the processes associated
with that tty.
This gives both ends the ability to timeout the line.
(Depending on whether the dialout end or the remote end timed out, either
the dialing process or the special shell will receive this signal.)
.LP
The \fIduioctl\fP program can be used to dynamically modify the timeout
parameters.
