/* debug.h -- Connolly's debugging junk
 * $Id: debug.h,v 1.4 92/09/10 22:04:24 connolly Exp $
 * Copyright 1992 by Convex Computer Corporation, Richardson, Texas.
 * See the COPYRIGHT file for details.
 *
 * USE: debug(("debugging message", printf, args))
 * just like you would printf, but with extra ().
 * They turn to a null expression statement ((void)0) at
 * compile time if DEBUG is not true.
 */

#define DEBUG_DEFAULT 0

#ifndef DEBUG
#define DEBUG DEBUG_DEFAULT
#endif

#if DEBUG
#  include <stdio.h>
#  define debug(x) printf x
#  define Debug(s, x) ((debug_##s) ?  printf x : 0)
#else
#  define debug(x) do{}while(0)
#  define Debug(s, x) do{}while(0)
#endif

/*
 * REQUIRE(condition, stmnt_if_fail)
 * be sure to free dynamic memory on failure.
 * e.g.
 * p = malloc(size);
 * REQUIRE(x>0, return (free(p), -1));
 */
#define REQUIRE(x,return_y)                   \
  if(!(x)){                                   \
    debug(("requirement failed: %s\n", #x));  \
    return_y;                                 \
  }

#define TIMING_DEFAULT 0

#ifndef TIMING
#define TIMING TIMING_DEFAULT
#endif

#if TIMING
extern "C" clock(void);
#define timing(s) printf("<%s>clock = %d\n", s, clock())
#else
#define timing(s) do{}while(0)
#endif


