/* HTMLentities.h
 * $Id$
 */


/* implements ... */
#include "HTMLdtd.h"

/* uses ... */
#include "SGML.h"

/**********************
A translation of "ISO 8879:1986//ENTITIES Added Latin 1//EN"
and the postscript encoding of those symbols to C.
***********************/

static HMBinding entities[] = {
  {"AElig",	"\306"},	/* capital AE diphthong (ligature) */ 
  {"Aacute",	"\301"},	/* capital A, acute accent */ 
  {"Acirc",	"\302"},	/* capital A, circumflex accent */ 
  {"Agrave",	"\300"},	/* capital A, grave accent */ 
  {"Aring",	"\305"},	/* capital A, ring */ 
  {"Atilde",	"\303"},	/* capital A, tilde */ 
  {"Auml",	"\304"},	/* capital A, dieresis or umlaut mark */ 
  {"Ccedil",	"\307"},	/* capital C, cedilla */ 
  {"ETH",	"\320"},	/* capital Eth, Icelandic */ 
  {"Eacute",	"\311"},	/* capital E, acute accent */ 
  {"Ecirc",	"\312"},	/* capital E, circumflex accent */ 
  {"Egrave",	"\310"},	/* capital E, grave accent */ 
  {"Euml",	"\313"},	/* capital E, dieresis or umlaut mark */ 
  {"Iacute",	"\315"},	/* capital I, acute accent */ 
  {"Icirc",	"\316"},	/* capital I, circumflex accent */ 
  {"Igrave",	"\314"},	/* capital I, grave accent */ 
  {"Iuml",	"\317"},	/* capital I, dieresis or umlaut mark */ 
  {"Ntilde",	"\321"},	/* capital N, tilde */ 
  {"Oacute",	"\323"},	/* capital O, acute accent */ 
  {"Ocirc",	"\324"},	/* capital O, circumflex accent */ 
  {"Ograve",	"\322"},	/* capital O, grave accent */ 
  {"Oslash",	"\330"},	/* capital O, slash */ 
  {"Otilde",	"\325"},	/* capital O, tilde */ 
  {"Ouml",	"\326"},	/* capital O, dieresis or umlaut mark */ 
  {"THORN",	"\336"},	/* capital THORN, Icelandic */ 
  {"Uacute",	"\332"},	/* capital U, acute accent */ 
  {"Ucirc",	"\333"},	/* capital U, circumflex accent */ 
  {"Ugrave",	"\331"},	/* capital U, grave accent */ 
  {"Uuml",	"\334"},	/* capital U, dieresis or umlaut mark */ 
  {"Yacute",	"\335"},	/* capital Y, acute accent */ 
  {"aacute",	"\341"},	/* small a, acute accent */ 
  {"acirc",	"\342"},	/* small a, circumflex accent */ 
  {"aelig",	"\346"},	/* small ae diphthong (ligature) */ 
  {"agrave",	"\340"},	/* small a, grave accent */ 
  {"amp",	"\046"},	/* ampersand */ 
  {"aring",	"\345"},	/* small a, ring */ 
  {"atilde",	"\343"},	/* small a, tilde */ 
  {"auml",	"\344"},	/* small a, dieresis or umlaut mark */ 
  {"ccedil",	"\347"},	/* small c, cedilla */ 
  {"eacute",	"\351"},	/* small e, acute accent */ 
  {"ecirc",	"\352"},	/* small e, circumflex accent */ 
  {"egrave",	"\350"},	/* small e, grave accent */ 
  {"eth",	"\360"},	/* small eth, Icelandic */ 
  {"euml",	"\353"},	/* small e, dieresis or umlaut mark */ 
  {"gt",	"\076"},	/* greater than */ 
  {"iacute",	"\355"},	/* small i, acute accent */ 
  {"icirc",	"\356"},	/* small i, circumflex accent */ 
  {"igrave",	"\354"},	/* small i, grave accent */ 
  {"iuml",	"\357"},	/* small i, dieresis or umlaut mark */ 
  {"lt",	"\074"},	/* less than */ 
  {"ntilde",	"\361"},	/* small n, tilde */ 
  {"oacute",	"\363"},	/* small o, acute accent */ 
  {"ocirc",	"\364"},	/* small o, circumflex accent */ 
  {"ograve",	"\362"},	/* small o, grave accent */ 
  {"oslash",	"\370"},	/* small o, slash */ 
  {"otilde",	"\365"},	/* small o, tilde */ 
  {"ouml",	"\366"},	/* small o, dieresis or umlaut mark */ 
  {"szlig",	"\337"},	/* small sharp s, German (sz ligature) */ 
  {"thorn",	"\376"},	/* small thorn, Icelandic */ 
  {"uacute",	"\372"},	/* small u, acute accent */ 
  {"ucirc",	"\373"},	/* small u, circumflex accent */ 
  {"ugrave",	"\371"},	/* small u, grave accent */ 
  {"uuml",	"\374"},	/* small u, dieresis or umlaut mark */ 
  {"yacute",	"\375"},	/* small y, acute accent */ 
  {"yuml",	"\377"},	/* small y, dieresis or umlaut mark */ 
};

#define ARRAYSIZE(x) (sizeof(x)/sizeof((x)[0]))

CONST char*
  html_entity_text(unused, name)
HMDoc* unused;
CONST char* name;
{
  /* binary search through sorted list of entity names */

  CONST HMBinding *ed;
  int bottom = 0;
  int top = ARRAYSIZE(entities);
  int sign, half;

  while(half = (top + bottom)/2,
	ed = entities + half,
	sign = strcmp(name, ed->name)){
    if(top - bottom <= 1)
      return 0; /* error: undefined entity */

    if(sign < 0)
      top = half;
    else
      bottom = half;
  }

  return ed->value;
}


int
  HTML_content(gi)
CONST char* gi;
{
  if(!strcmp(gi, "TITLE") ||
     !strcmp(gi, "XMP") ||
     !strcmp(gi, "LISTING")){
    return SGML_RCDATA;
  }else if(!strcmp(gi, "P") ||
	   !strcmp(gi, "LI") ||
	   !strcmp(gi, "DT") ||
	   !strcmp(gi, "DD")
	   ){
    return SGML_EMPTY;
  }else{
    return SGML_MIXED;
  }
}
