/* HMDoc.h -- HyperMedia Document class definition
 * $Id$
 */

#ifndef HMDoc_h
#define HMDoc_h

#include "c_dialect.h"
/* @@ get rid of this depenency... */
#include <stdio.h>

typedef struct _HMDoc HMDoc;

typedef struct{
  char* name;
  char* value;
}HMBinding;


typedef HMDoc*
  HMFileWriterProc PARAMS((FILE* fp));

typedef VOIDPTR HMStream;

typedef int HMGetcProc PARAMS((HMStream in));

typedef int HMWriteProc PARAMS((HMStream out,
				CONST VOIDPTR buf,
				unsigned nbytes));

typedef HMDoc*
  HMWriterProc PARAMS((HMStream out, HMWriteProc write));

typedef VOID
  HMDeleteProc PARAMS((HMDoc* this));

typedef int
  HMStartTagProc PARAMS((HMDoc* this,
			 CONST char* gi,
			 CONST HMBinding attributes[],
			 int nattrs));
typedef VOID
  HMEndTagProc PARAMS((HMDoc* this,
		       CONST char* gi));

typedef VOID
  HMDataProc PARAMS((HMDoc* this,
		     CONST char* data,
		     int char_qty));
typedef CONST char*
  HMEntityProc PARAMS((HMDoc* this, CONST char* name));

typedef struct{
  /* class methods... */
  HMFileWriterProc *fileWriter;
  HMWriterProc *writer;

  /* instance methods */
  HMDeleteProc *delete;
  HMStartTagProc *startTag;
  HMEndTagProc *endTag;
  HMDataProc *data;
  HMEntityProc *entityText;
  /*@@ EOFProc *eof */
}HMDoc_Class;

typedef VOID HMParseProc PARAMS((HMStream stream, HMGetcProc getc,
			     HMDoc* document,
			     CONST HMDoc_Class *docclass));

extern HMDoc_Class InCore;
HMDoc* InCore_new PARAMS(());
VOID InCore_traverse PARAMS((HMDoc* this, HMDoc* that, HMDoc_Class* docclass));

#endif
